-- $Id: sem.ads 15520 2010-01-07 12:53:45Z spark $
--------------------------------------------------------------------------------
-- (C) Altran Praxis Limited
--------------------------------------------------------------------------------
--
-- The SPARK toolset is free software; you can redistribute it and/or modify it
-- under terms of the GNU General Public License as published by the Free
-- Software Foundation; either version 3, or (at your option) any later
-- version. The SPARK toolset is distributed in the hope that it will be
-- useful, but WITHOUT ANY WARRANTY; without even the implied warranty of
-- MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the GNU General
-- Public License for more details. You should have received a copy of the GNU
-- General Public License distributed with the SPARK toolset; see file
-- COPYING3. If not, go to http://www.gnu.org/licenses for a complete copy of
-- the license.
--
--==============================================================================

with CommandLineData;
with STree;

use type CommandLineData.LanguageProfiles;
use type STree.Iterator;
use type STree.SyntaxNode;

--# inherit Casing,
--#         CommandLineData,
--#         CompleteCheck,
--#         ComponentManager,
--#         ContextManager.Ops,
--#         Debug,
--#         Declarations,
--#         Dictionary,
--#         ELStrings,
--#         ErrorHandler,
--#         EStrings,
--#         ExaminerConstants,
--#         FlowAnalyser,
--#         Graph,
--#         Heap,
--#         LexTokenManager,
--#         LexTokenManager.Relation_Algebra,
--#         LexTokenManager.Relation_Algebra.String,
--#         LexTokenManager.Seq_Algebra,
--#         Lists,
--#         Maths,
--#         RefList,
--#         RelationAlgebra,
--#         SeqAlgebra,
--#         SimpleLists,
--#         SLI,
--#         SPARK_IO,
--#         SPrint,
--#         SPSymbols,
--#         Statistics,
--#         StmtStack,
--#         STree,
--#         SystemErrors,
--#         VCG;

package Sem
is

   procedure CompUnit (TopNode : in STree.SyntaxNode;
                       Do_VCG  : in Boolean);
   --# global in     CommandLineData.Content;
   --#        in     ContextManager.Ops.FileHeap;
   --#        in     ContextManager.Ops.UnitHeap;
   --#        in     ContextManager.Ops.UnitStack;
   --#        in out Declarations.State;
   --#        in out Dictionary.Dict;
   --#        in out ErrorHandler.ErrorContext;
   --#        in out Graph.Table;
   --#        in out LexTokenManager.State;
   --#        in out SLI.State;
   --#        in out SPARK_IO.FILE_SYS;
   --#        in out Statistics.TableUsage;
   --#        in out StmtStack.S;
   --#        in out STree.Table;
   --#        in out VCG.Invoked;
   --# derives Declarations.State,
   --#         Dictionary.Dict,
   --#         ErrorHandler.ErrorContext,
   --#         Graph.Table,
   --#         LexTokenManager.State,
   --#         SLI.State,
   --#         SPARK_IO.FILE_SYS,
   --#         Statistics.TableUsage,
   --#         StmtStack.S,
   --#         STree.Table,
   --#         VCG.Invoked               from *,
   --#                                        CommandLineData.Content,
   --#                                        ContextManager.Ops.FileHeap,
   --#                                        ContextManager.Ops.UnitHeap,
   --#                                        ContextManager.Ops.UnitStack,
   --#                                        Dictionary.Dict,
   --#                                        Do_VCG,
   --#                                        ErrorHandler.ErrorContext,
   --#                                        LexTokenManager.State,
   --#                                        SLI.State,
   --#                                        SPARK_IO.FILE_SYS,
   --#                                        STree.Table,
   --#                                        TopNode;

end Sem;
