-- $Id: sem-isexternalinterface.adb 15520 2010-01-07 12:53:45Z spark $
--------------------------------------------------------------------------------
-- (C) Altran Praxis Limited
--------------------------------------------------------------------------------
--
-- The SPARK toolset is free software; you can redistribute it and/or modify it
-- under terms of the GNU General Public License as published by the Free
-- Software Foundation; either version 3, or (at your option) any later
-- version. The SPARK toolset is distributed in the hope that it will be
-- useful, but WITHOUT ANY WARRANTY; without even the implied warranty of
-- MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the GNU General
-- Public License for more details. You should have received a copy of the GNU
-- General Public License distributed with the SPARK toolset; see file
-- COPYING3. If not, go to http://www.gnu.org/licenses for a complete copy of
-- the license.
--
--==============================================================================

-- Synopsis
-- This function idnetifies whether a pragma is Interface or Import and whether
-- it is appropriate for the language varaint in use
--------------------------------------------------------------------------------
separate (Sem)
function IsExternalInterface (PragmaNode : STree.SyntaxNode)
                             return Boolean
is
   Result : Boolean;
begin
   case CommandLineData.Content.LanguageProfile is
      when CommandLineData.SPARK83 =>
         Result := LexTokenManager.Lex_String_Case_Insensitive_Compare (Lex_Str1 => NodeLexString (Child_Node (PragmaNode)),
                                                                        Lex_Str2 => LexTokenManager.Interface_Token) = LexTokenManager.Str_Eq;
      when CommandLineData.SPARK95 |
        CommandLineData.SPARK2005 =>
         Result := LexTokenManager.Lex_String_Case_Insensitive_Compare (Lex_Str1 => NodeLexString (Child_Node (PragmaNode)),
                                                                        Lex_Str2 => LexTokenManager.Import_Token) = LexTokenManager.Str_Eq;
   end case;
   return Result;
end IsExternalInterface;
