-- $Id: sem-indexesmatch.adb 15520 2010-01-07 12:53:45Z spark $
--------------------------------------------------------------------------------
-- (C) Altran Praxis Limited
--------------------------------------------------------------------------------
--
-- The SPARK toolset is free software; you can redistribute it and/or modify it
-- under terms of the GNU General Public License as published by the Free
-- Software Foundation; either version 3, or (at your option) any later
-- version. The SPARK toolset is distributed in the hope that it will be
-- useful, but WITHOUT ANY WARRANTY; without even the implied warranty of
-- MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the GNU General
-- Public License for more details. You should have received a copy of the GNU
-- General Public License distributed with the SPARK toolset; see file
-- COPYING3. If not, go to http://www.gnu.org/licenses for a complete copy of
-- the license.
--
--==============================================================================

separate (Sem)
function IndexesMatch (Target,
                       Source   : Dictionary.Symbol) return Boolean
is
   TgtIt,
   SrcIt : Dictionary.Iterator;
   Ok    : Boolean;

   function BoundsMatch (SrcSym, TgtSym : Dictionary.Symbol) return Boolean
   --# global in Dictionary.Dict;
   --#        in LexTokenManager.State;
   is
      function UpperBoundMatches (SrcSym, TgtSym : Dictionary.Symbol) return Boolean
      --# global in Dictionary.Dict;
      --#        in LexTokenManager.State;
      is
      begin
         return LexTokenManager.Lex_String_Case_Insensitive_Compare (Lex_Str1 => Dictionary.GetScalarAttributeValue (False,
                                                                                                                     LexTokenManager.Last_Token,
                                                                                                                     SrcSym),
                                                                     Lex_Str2 => Dictionary.GetScalarAttributeValue (False,
                                                                                                                     LexTokenManager.Last_Token,
                                                                                                                     TgtSym)) = LexTokenManager.Str_Eq;
      end UpperBoundMatches;

      --------------------

      function LowerBoundMatches (SrcSym, TgtSym : Dictionary.Symbol) return Boolean
      --# global in Dictionary.Dict;
      --#        in LexTokenManager.State;
      is
      begin
         return LexTokenManager.Lex_String_Case_Insensitive_Compare (Lex_Str1 => Dictionary.GetScalarAttributeValue (False,
                                                                                                                     LexTokenManager.First_Token,
                                                                                                                     SrcSym),
                                                                     Lex_Str2 => Dictionary.GetScalarAttributeValue (False,
                                                                                                                     LexTokenManager.First_Token,
                                                                                                                     TgtSym)) = LexTokenManager.Str_Eq;
      end LowerBoundMatches;

      --------------------

   begin --BoundsMatch
      return UpperBoundMatches (SrcSym, TgtSym) and then
         LowerBoundMatches (SrcSym, TgtSym);
   end BoundsMatch;

   ---------------------------------------

begin --IndexesMatch
   Ok := True;
   TgtIt := Dictionary.FirstArrayIndex (Target);
   SrcIt := Dictionary.FirstArrayIndex (Source);
   while not Dictionary.IsNullIterator (TgtIt) loop
      if not BoundsMatch (Dictionary.CurrentSymbol (SrcIt),
                          Dictionary.CurrentSymbol (TgtIt))
      then
         Ok := False;
         exit;
      end if;
      TgtIt := Dictionary.NextSymbol (TgtIt);
      SrcIt := Dictionary.NextSymbol (SrcIt);
   end loop;
   return Ok;
end IndexesMatch;
