-- $Id: sem-compunit-wf_use_type_clause.adb 15520 2010-01-07 12:53:45Z spark $
--------------------------------------------------------------------------------
-- (C) Altran Praxis Limited
--------------------------------------------------------------------------------
--
-- The SPARK toolset is free software; you can redistribute it and/or modify it
-- under terms of the GNU General Public License as published by the Free
-- Software Foundation; either version 3, or (at your option) any later
-- version. The SPARK toolset is distributed in the hope that it will be
-- useful, but WITHOUT ANY WARRANTY; without even the implied warranty of
-- MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the GNU General
-- Public License for more details. You should have received a copy of the GNU
-- General Public License distributed with the SPARK toolset; see file
-- COPYING3. If not, go to http://www.gnu.org/licenses for a complete copy of
-- the license.
--
--==============================================================================


----------------------------------------------------------------------------
-- This unit WFFs use type clauses that appear _inside_ a package body only.
-- Currently these are not allowed in SPARK83 at all, and in SPARK95, we
-- WFF their position (they must directly follow the embedded package to
-- which they refer), but report they are otherwise unimplemented.
--
-- This does NOT WFF use type clauses that appear as part of a context
-- clause - these are handled separately by
-- Sem.CompUnit.wf_context_clause.use_clause
----------------------------------------------------------------------------
separate (Sem.CompUnit)
procedure Wf_Use_Type_Clause (Node  : in STree.SyntaxNode)
is
   It            : STree.Iterator;
   ParentItemRep : STree.SyntaxNode;

   procedure CheckPosition (Node       : in     STree.SyntaxNode;
                            Parent     : in     STree.SyntaxNode;
                            PackString : in     LexTokenManager.Lex_String;
                            PosOk      :    out Boolean)
   --# global in     CommandLineData.Content;
   --#        in     Dictionary.Dict;
   --#        in     LexTokenManager.State;
   --#        in     STree.Table;
   --#        in out ErrorHandler.ErrorContext;
   --#        in out SPARK_IO.FILE_SYS;
   --# derives ErrorHandler.ErrorContext,
   --#         SPARK_IO.FILE_SYS         from CommandLineData.Content,
   --#                                        Dictionary.Dict,
   --#                                        ErrorHandler.ErrorContext,
   --#                                        LexTokenManager.State,
   --#                                        Node,
   --#                                        PackString,
   --#                                        Parent,
   --#                                        SPARK_IO.FILE_SYS,
   --#                                        STree.Table &
   --#         PosOk                     from LexTokenManager.State,
   --#                                        PackString,
   --#                                        Parent,
   --#                                        STree.Table;
   is
      Ident    : LexTokenManager.Lex_String;
   begin -- CheckPosition
      if SyntaxNodeType (Parent) = SPSymbols.initial_declarative_item_rep then
         -- should follow a package declaration
         Ident := FindPreviousPackage (Parent);

         if LexTokenManager.Lex_String_Case_Insensitive_Compare (Lex_Str1 => Ident,
                                                                 Lex_Str2 => LexTokenManager.Null_String) = LexTokenManager.Str_Eq then
            ErrorHandler.SemanticError (112,
                                        ErrorHandler.NoReference,
                                        NodePosition (Node),
                                        LexTokenManager.Null_String);
            PosOk := False;
         elsif LexTokenManager.Lex_String_Case_Insensitive_Compare (Lex_Str1 => Ident,
                                                                    Lex_Str2 => PackString) /= LexTokenManager.Str_Eq then
            ErrorHandler.SemanticError (301,
                                        ErrorHandler.NoReference,
                                        NodePosition (Node),
                                        Ident);
            PosOk := False;
         else
            PosOk := True;
         end if;
      else
         PosOk := False;
      end if;

   end CheckPosition;

   procedure ProcessDottedSimpleName (Node       : in STree.SyntaxNode;
                                      Parent     : in STree.SyntaxNode)
   --# global in     CommandLineData.Content;
   --#        in     Dictionary.Dict;
   --#        in     LexTokenManager.State;
   --#        in     STree.Table;
   --#        in out ErrorHandler.ErrorContext;
   --#        in out SPARK_IO.FILE_SYS;
   --# derives ErrorHandler.ErrorContext,
   --#         SPARK_IO.FILE_SYS         from CommandLineData.Content,
   --#                                        Dictionary.Dict,
   --#                                        ErrorHandler.ErrorContext,
   --#                                        LexTokenManager.State,
   --#                                        Node,
   --#                                        Parent,
   --#                                        SPARK_IO.FILE_SYS,
   --#                                        STree.Table;
   is
      OK         : Boolean;
   begin
      CheckPosition (Node, Parent, NodeLexString (LastChildOf (Node)), OK);
      if OK then
         -- Position is OK, but alas "use type" is currently unimplemented...
         -- If this is ever completed, then remember to revise the comment
         -- at the top of this unit!
         ErrorHandler.SemanticError (110,
                                     ErrorHandler.NoReference,
                                     NodePosition (Node),
                                     LexTokenManager.Null_String);
      end if;
   end ProcessDottedSimpleName;

begin -- wf_use_type_clause
   case CommandLineData.Content.LanguageProfile is
      when CommandLineData.SPARK83 =>

         ErrorHandler.SemanticError (550,
                                     ErrorHandler.NoReference,
                                     NodePosition (Node),
                                     LexTokenManager.Null_String);
      when CommandLineData.SPARK95 |
        CommandLineData.SPARK2005 =>

         -- Could be "use type E.T1, E.T2;" so we need to loop and check
         -- the position of each type mark.

         ParentItemRep := ParentNode (Node);
         It := FindFirstNode (NodeKind    => SPSymbols.dotted_simple_name,
                              FromRoot    => Node,
                              InDirection => STree.Down);

         while not STree.IsNull (It) loop
            ProcessDottedSimpleName (GetNode (It), ParentItemRep);
            It := STree.NextNode (It);
         end loop;
   end case;
end Wf_Use_Type_Clause;
