-- $Id: sem-compunit-wf_tilde.adb 15520 2010-01-07 12:53:45Z spark $
--------------------------------------------------------------------------------
-- (C) Altran Praxis Limited
--------------------------------------------------------------------------------
--
-- The SPARK toolset is free software; you can redistribute it and/or modify it
-- under terms of the GNU General Public License as published by the Free
-- Software Foundation; either version 3, or (at your option) any later
-- version. The SPARK toolset is distributed in the hope that it will be
-- useful, but WITHOUT ANY WARRANTY; without even the implied warranty of
-- MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the GNU General
-- Public License for more details. You should have received a copy of the GNU
-- General Public License distributed with the SPARK toolset; see file
-- COPYING3. If not, go to http://www.gnu.org/licenses for a complete copy of
-- the license.
--
--==============================================================================


separate (Sem.CompUnit)
procedure wf_tilde
   (Node           : in     STree.SyntaxNode;
    Scope          : in     Dictionary.Scopes;
    EStack         : in out ExpStack.ExpStackType;
    Context        : in     Anno_Tilde_Context)
is
   StackTop    : ExpRecord;
   SubprogSym,
   TopSym      : Dictionary.Symbol;
   Abstraction : Dictionary.Abstractions;

begin
   case Context is
      when Precondition  =>  -- Tilde not allowed at all
         ExpStack.Pop (StackTop, EStack);
         StackTop.ErrorsInExpression := True;
         ExpStack.Push (StackTop, EStack);
         ErrorHandler.SemanticError (321,  ErrorHandler.NoReference,
                                     NodePosition (Node),
                                     LexTokenManager.Null_String);
      when FunctionReturn => -- tilde only allowed on imported "stream" variables
         ExpStack.Pop (StackTop, EStack);
         TopSym := StackTop.OtherSymbol;
         -- the test below is sufficient to identify a gloabl of the function which is of mode IN.
         -- This is because eternal variables cannot appear as parameters AND
         -- external variable sof mode OUT cannot be referenced.  Therefore a  variable which is
         -- visible in a function return annotation and which has a mode must be a global of external IN mode.
         if not Dictionary.IsOwnVariableOrConstituentWithMode (TopSym) then
            StackTop.ErrorsInExpression := True;
            ErrorHandler.SemanticError (317,  ErrorHandler.NoReference,
                                        NodePosition (Node),
                                        LexTokenManager.Null_String);
         end if;
         ExpStack.Push (StackTop, EStack);
      when Postcondition =>  -- Tilde may be allowed
         ExpStack.Pop (StackTop, EStack);
         if StackTop.Sort = IsObject then -- May be ok, further checks required
            TopSym := StackTop.OtherSymbol;
            if not Dictionary.IsVariable (TopSym) then
               StackTop.ErrorsInExpression := True;
               ErrorHandler.SemanticError (318,
                                           ErrorHandler.NoReference,
                                           NodePosition (Node),
                                           LexTokenManager.Null_String);

            elsif StackTop.TypeSymbol /= Dictionary.GetType (TopSym) then
               -- New check that variable is entire
               StackTop.ErrorsInExpression := True;
               ErrorHandler.SemanticError (320,
                                           ErrorHandler.NoReference,
                                           NodePosition (Node),
                                           LexTokenManager.Null_String);
            else
               -- It is an entire variable so further checks required
               SubprogSym := Dictionary.GetEnclosingCompilationUnit (Scope);
               Abstraction := Dictionary.GetAbstraction (SubprogSym,
                                                         Scope);
               if not (Dictionary.IsImport (Abstraction, SubprogSym, TopSym) and
                         Dictionary.IsExport (Abstraction, SubprogSym, TopSym)) then
                  StackTop.ErrorsInExpression := True;
                  ErrorHandler.SemanticError (319,  ErrorHandler.NoReference,
                                              NodePosition (Node),
                                              LexTokenManager.Null_String);
               end if;
            end if;
         else -- Cannot be ok so error message needed
            StackTop.ErrorsInExpression := True;
            if not (StackTop.Sort = IsUnknown) then
               -- Supress error for unknown things
               ErrorHandler.SemanticError (318,  ErrorHandler.NoReference,
                                           NodePosition (Node),
                                           LexTokenManager.Null_String);
            end if;
         end if;
         ExpStack.Push (StackTop, EStack);
   end case;

end wf_tilde;
