-- $Id: sem-compunit-wf_subunit.adb 15674 2010-01-20 16:17:20Z spark $
--------------------------------------------------------------------------------
-- (C) Altran Praxis Limited
--------------------------------------------------------------------------------
--
-- The SPARK toolset is free software; you can redistribute it and/or modify it
-- under terms of the GNU General Public License as published by the Free
-- Software Foundation; either version 3, or (at your option) any later
-- version. The SPARK toolset is distributed in the hope that it will be
-- useful, but WITHOUT ANY WARRANTY; without even the implied warranty of
-- MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the GNU General
-- Public License for more details. You should have received a copy of the GNU
-- General Public License distributed with the SPARK toolset; see file
-- COPYING3. If not, go to http://www.gnu.org/licenses for a complete copy of
-- the license.
--
--==============================================================================


separate (Sem.CompUnit)

procedure wf_subunit (Node  : in     STree.SyntaxNode;
                      Scope : in out Dictionary.Scopes)
is
   NextNode : STree.SyntaxNode;
   Sym      : Dictionary.Symbol;
   Parent   : Dictionary.Symbol;
   Ok       : Boolean;

   ---------------------------------------------------

   procedure CheckSym (Sym : in     Dictionary.Symbol;
                       Ok  :    out Boolean)
   --# global in     CommandLineData.Content;
   --#        in     Dictionary.Dict;
   --#        in     LexTokenManager.State;
   --#        in     NextNode;
   --#        in     STree.Table;
   --#        in out ErrorHandler.ErrorContext;
   --#        in out SPARK_IO.FILE_SYS;
   --# derives ErrorHandler.ErrorContext,
   --#         SPARK_IO.FILE_SYS         from CommandLineData.Content,
   --#                                        Dictionary.Dict,
   --#                                        ErrorHandler.ErrorContext,
   --#                                        LexTokenManager.State,
   --#                                        NextNode,
   --#                                        SPARK_IO.FILE_SYS,
   --#                                        STree.Table,
   --#                                        Sym &
   --#         Ok                        from Dictionary.Dict,
   --#                                        Sym;
   is
   begin -- CheckSym
      if (Sym = Dictionary.NullSymbol) or else
         not Dictionary.IsCompilationUnit (Sym)
      then
         Ok := False;
         ErrorHandler.SemanticError (14,
                                     ErrorHandler.NoReference,
                                     NodePosition (Child_Node (NextNode)),
                                     NodeLexString (Child_Node (NextNode)));
      else
         Ok := True;
      end if;
   end CheckSym;

   ---------------------------------------------------

begin
   -- ASSUME Node = subunit
   NextNode := ParentNode (LastChildOf (Node));
   --NextNode is now bottom simple_name in tree
   Sym := Dictionary.LookupItem (Name    => NodeLexString (Child_Node (NextNode)),
                                 Scope   => Dictionary.GlobalScope,
                                 Context => Dictionary.ProgramContext);
   CheckSym (Sym, Ok);
   loop
      exit when not Ok;
      STree.Set_Node_Lex_String (Sym  => Sym,
                                 Node => Child_Node (NextNode));
      NextNode := Next_Sibling (ParentNode (NextNode));
      exit when SyntaxNodeType (NextNode) /= SPSymbols.simple_name;

      Parent := Sym;
      Sym := Dictionary.LookupSelectedItem (Prefix   => Parent,
                                            Selector => NodeLexString (Child_Node (NextNode)),
                                            Scope    => Dictionary.GlobalScope,
                                            Context  => Dictionary.ProofContext);
      if Sym = Dictionary.NullSymbol then
         Sym := Dictionary.LookupImmediateScope (Name    => NodeLexString (Child_Node (NextNode)),
                                                 Scope   => Dictionary.LocalScope (Parent),
                                                 Context => Dictionary.ProgramContext);
      end if;
      -- The above look up may return the symbol of an implicit proof function associated with an
      -- Ada function.  If so, we want to process the subunit in the context of the Ada function
      if Dictionary.IsProofFunction (Sym) then
         Sym := Dictionary.GetAdaFunction (Sym);
      end if;
      CheckSym (Sym, Ok);
   end loop;

   if Ok then
      Scope := Dictionary.LocalScope (Sym);
   end if;

end wf_subunit;
