-- $Id: sem-compunit-wf_subtype_declaration-wf_ravenscar_subtype.adb 16669 2010-04-01 11:26:15Z spark $
--------------------------------------------------------------------------------
-- (C) Altran Praxis Limited
--------------------------------------------------------------------------------
--
-- The SPARK toolset is free software; you can redistribute it and/or modify it
-- under terms of the GNU General Public License as published by the Free
-- Software Foundation; either version 3, or (at your option) any later
-- version. The SPARK toolset is distributed in the hope that it will be
-- useful, but WITHOUT ANY WARRANTY; without even the implied warranty of
-- MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the GNU General
-- Public License for more details. You should have received a copy of the GNU
-- General Public License distributed with the SPARK toolset; see file
-- COPYING3. If not, go to http://www.gnu.org/licenses for a complete copy of
-- the license.
--
--==============================================================================


separate (Sem.CompUnit.wf_subtype_declaration)
procedure Wf_Ravenscar_Subtype (IdStr          : in LexTokenManager.Lex_String;
                                TypeSym        : in Dictionary.Symbol;
                                Scope          : in Dictionary.Scopes;
                                IdNode         : in STree.SyntaxNode;
                                ConstraintNode : in STree.SyntaxNode)
is

   TheSubtype : Dictionary.Symbol;
   AssocNode  : STree.SyntaxNode;

   -- Grammar: --------------------------------------------------------------
   --
   -- index_or_discriminant_constraint (<--ConstraintNode)
   --            |
   --    discriminant_association
   --            |
   --    named_argument_association      OR            positional_argument_association
   --            |                                                   |
   --            |...                                                |
   --    named_argument_association --- simple_name --- expression   |
   --           |                                                    |
   --     simple_name --- expression                                 |...
   --                                                  positional_argument_association --- expression
   --                                                                |
   --                                                            expression
   --
   ----------------------------------------------------------------------------

   procedure ProcessExpression (ExpNode    : in STree.SyntaxNode;
                                FormalSym  : in Dictionary.Symbol;
                                SubtypeSym : in Dictionary.Symbol)
   --# global in     CommandLineData.Content;
   --#        in     ContextManager.Ops.FileHeap;
   --#        in     ContextManager.Ops.UnitHeap;
   --#        in     ContextManager.Ops.UnitStack;
   --#        in     Scope;
   --#        in     TypeSym;
   --#        in out Dictionary.Dict;
   --#        in out ErrorHandler.ErrorContext;
   --#        in out LexTokenManager.State;
   --#        in out SLI.State;
   --#        in out SPARK_IO.FILE_SYS;
   --#        in out Statistics.TableUsage;
   --#        in out STree.Table;
   --#           out AggregateStack.State;
   --#           out TheHeap;
   --# derives AggregateStack.State,
   --#         STree.Table,
   --#         TheHeap                   from CommandLineData.Content,
   --#                                        ContextManager.Ops.UnitStack,
   --#                                        Dictionary.Dict,
   --#                                        ExpNode,
   --#                                        LexTokenManager.State,
   --#                                        Scope,
   --#                                        STree.Table &
   --#         Dictionary.Dict,
   --#         LexTokenManager.State     from CommandLineData.Content,
   --#                                        ContextManager.Ops.UnitStack,
   --#                                        Dictionary.Dict,
   --#                                        ExpNode,
   --#                                        FormalSym,
   --#                                        LexTokenManager.State,
   --#                                        Scope,
   --#                                        STree.Table,
   --#                                        SubtypeSym,
   --#                                        TypeSym &
   --#         ErrorHandler.ErrorContext,
   --#         SPARK_IO.FILE_SYS         from CommandLineData.Content,
   --#                                        ContextManager.Ops.FileHeap,
   --#                                        ContextManager.Ops.UnitHeap,
   --#                                        ContextManager.Ops.UnitStack,
   --#                                        Dictionary.Dict,
   --#                                        ErrorHandler.ErrorContext,
   --#                                        ExpNode,
   --#                                        FormalSym,
   --#                                        LexTokenManager.State,
   --#                                        Scope,
   --#                                        SLI.State,
   --#                                        SPARK_IO.FILE_SYS,
   --#                                        STree.Table,
   --#                                        SubtypeSym,
   --#                                        TypeSym &
   --#         Statistics.TableUsage     from *,
   --#                                        CommandLineData.Content,
   --#                                        ContextManager.Ops.UnitStack,
   --#                                        Dictionary.Dict,
   --#                                        ExpNode,
   --#                                        LexTokenManager.State,
   --#                                        Scope,
   --#                                        STree.Table &
   --#         SLI.State                 from *,
   --#                                        CommandLineData.Content,
   --#                                        ContextManager.Ops.FileHeap,
   --#                                        ContextManager.Ops.UnitHeap,
   --#                                        ContextManager.Ops.UnitStack,
   --#                                        Dictionary.Dict,
   --#                                        ErrorHandler.ErrorContext,
   --#                                        ExpNode,
   --#                                        LexTokenManager.State,
   --#                                        Scope,
   --#                                        SPARK_IO.File_Sys,
   --#                                        STree.Table;
   is
      Result              : ExpRecord;
      UnwantedSeq         : SeqAlgebra.Seq;
      UnusedComponentData : ComponentManager.ComponentData;
      StaticValue         : LexTokenManager.Lex_String;
      PragmaKind          : Dictionary.RavenscarPragmasWithValue;
      ValueRep            : LexTokenManager.Lex_String;
   begin
      Heap.Initialize (TheHeap);
      ComponentManager.Initialise (UnusedComponentData);
      SeqAlgebra.CreateSeq (TheHeap, UnwantedSeq);
      --# accept Flow, 10, UnusedComponentData, "Expected ineffective assignment";
      WalkExpression (ExpNode,
                      Scope,
                      Dictionary.GetUnknownTypeMark,
                      False,
                        --to get
                      Result,
                      UnwantedSeq,
                      UnusedComponentData);
      --# end accept;
      SeqAlgebra.DisposeOfSeq (TheHeap, UnwantedSeq);

      AssignmentCheck (NodePosition (ExpNode),
                       Scope,
                       Dictionary.GetType (FormalSym),
                       Result);

      if Result.IsStatic then
         Maths.StorageRep (Result.Value, StaticValue);
         Dictionary.AddDiscriminantConstraintStaticValue (ProtectedOrTaskSubtype => SubtypeSym,
                                                          Comp_Unit              => ContextManager.Ops.CurrentUnit,
                                                          Declaration            => Dictionary.Location'(NodePosition (ExpNode),
                                                                                                         NodePosition (ExpNode)),
                                                          TheValue               => StaticValue);
         if Dictionary.SetsPriority (FormalSym) then
            if Dictionary.GetTypeHasPragma (TypeSym, Dictionary.Priority) then
               PragmaKind := Dictionary.Priority;
            else
               -- must be
               PragmaKind := Dictionary.InterruptPriority;
            end if;
            CheckPriorityRange (ErrorSym   => SubtypeSym,
                                Scope      => Scope,
                                PragmaKind => PragmaKind,
                                ErrPos     => NodePosition (ExpNode),
                                Value      => Result.Value,
                                ValueRep   => ValueRep);
            -- ValueRep is either a storage rep of a valid value or a null string; we can always add it to dict
            Dictionary.SetSubtypePriority (SubtypeSym, ValueRep);
         end if;
      elsif Dictionary.TypeIsAccess (Dictionary.GetType (FormalSym)) then
         Dictionary.AddDiscriminantConstraintAccessedObject (ProtectedOrTaskSubtype => SubtypeSym,
                                                             Comp_Unit              => ContextManager.Ops.CurrentUnit,
                                                             Declaration            => Dictionary.Location'(NodePosition (ExpNode),
                                                                                                            NodePosition (ExpNode)),
                                                             TheObject              => Result.VariableSymbol);
         -- N.B. VariableSymbol is the accessed _variable_ name, put there by wf_attribute_designator
      else
         -- not static and not a protected types so must be wrong
         ErrorHandler.SemanticError (36,
                                     ErrorHandler.NoReference,
                                     NodePosition (ExpNode),
                                     LexTokenManager.Null_String);
      end if;
   end ProcessExpression;

   ------------------------------------------------------------------------

   procedure HandlePositionalAssociation (Node       : in STree.SyntaxNode;
                                          SubtypeSym : in Dictionary.Symbol)
   --# global in     CommandLineData.Content;
   --#        in     ContextManager.Ops.FileHeap;
   --#        in     ContextManager.Ops.UnitHeap;
   --#        in     ContextManager.Ops.UnitStack;
   --#        in     Scope;
   --#        in     TypeSym;
   --#        in out AggregateStack.State;
   --#        in out Dictionary.Dict;
   --#        in out ErrorHandler.ErrorContext;
   --#        in out LexTokenManager.State;
   --#        in out SLI.State;
   --#        in out SPARK_IO.FILE_SYS;
   --#        in out Statistics.TableUsage;
   --#        in out STree.Table;
   --#        in out TheHeap;
   --# derives AggregateStack.State,
   --#         Dictionary.Dict,
   --#         LexTokenManager.State,
   --#         Statistics.TableUsage,
   --#         STree.Table,
   --#         TheHeap                   from *,
   --#                                        CommandLineData.Content,
   --#                                        ContextManager.Ops.UnitStack,
   --#                                        Dictionary.Dict,
   --#                                        LexTokenManager.State,
   --#                                        Node,
   --#                                        Scope,
   --#                                        STree.Table,
   --#                                        SubtypeSym,
   --#                                        TypeSym &
   --#         ErrorHandler.ErrorContext,
   --#         SLI.State,
   --#         SPARK_IO.FILE_SYS         from CommandLineData.Content,
   --#                                        ContextManager.Ops.FileHeap,
   --#                                        ContextManager.Ops.UnitHeap,
   --#                                        ContextManager.Ops.UnitStack,
   --#                                        Dictionary.Dict,
   --#                                        ErrorHandler.ErrorContext,
   --#                                        LexTokenManager.State,
   --#                                        Node,
   --#                                        Scope,
   --#                                        SLI.State,
   --#                                        SPARK_IO.File_Sys,
   --#                                        STree.Table,
   --#                                        SubtypeSym,
   --#                                        TypeSym;
   is
      ExpressionNode  : STree.SyntaxNode;
      FormalIt        : Dictionary.Iterator;
      ActualIt        : STree.Iterator;
      FormalParameter : Dictionary.Symbol;
   begin
      FormalIt := Dictionary.FirstKnownDiscriminant (TypeSym);

      ActualIt := FindFirstNode
        (NodeKind => SPSymbols.expression,
         FromRoot => Node,
         InDirection => STree.Down);

      while not Dictionary.IsNullIterator (FormalIt) and
        not STree.IsNull (ActualIt) loop

         FormalParameter := Dictionary.CurrentSymbol (FormalIt);
         ExpressionNode  := GetNode (ActualIt);

         ProcessExpression (ExpNode    => ExpressionNode,
                            FormalSym  => FormalParameter,
                            SubtypeSym => SubtypeSym);

         FormalIt := Dictionary.NextSymbol (FormalIt);
         ActualIt := STree.NextNode (ActualIt);
      end loop;

      if not Dictionary.IsNullIterator (FormalIt) or
        not STree.IsNull (ActualIt) then
         ErrorHandler.SemanticErrorSym (893,
                                        ErrorHandler.NoReference,
                                        NodePosition (Node),
                                        TypeSym,
                                        Scope);
      end if;
   end HandlePositionalAssociation;

   ------------------------------------------------------------------------

   procedure HandleNamedAssociation (Node       : in STree.SyntaxNode;
                                     SubtypeSym : in Dictionary.Symbol)
   --# global in     CommandLineData.Content;
   --#        in     ContextManager.Ops.FileHeap;
   --#        in     ContextManager.Ops.UnitHeap;
   --#        in     ContextManager.Ops.UnitStack;
   --#        in     Scope;
   --#        in     TypeSym;
   --#        in out AggregateStack.State;
   --#        in out Dictionary.Dict;
   --#        in out ErrorHandler.ErrorContext;
   --#        in out LexTokenManager.State;
   --#        in out SLI.State;
   --#        in out SPARK_IO.FILE_SYS;
   --#        in out Statistics.TableUsage;
   --#        in out STree.Table;
   --#        in out TheHeap;
   --# derives AggregateStack.State,
   --#         Dictionary.Dict,
   --#         LexTokenManager.State,
   --#         Statistics.TableUsage,
   --#         STree.Table,
   --#         TheHeap                   from *,
   --#                                        CommandLineData.Content,
   --#                                        ContextManager.Ops.UnitStack,
   --#                                        Dictionary.Dict,
   --#                                        LexTokenManager.State,
   --#                                        Node,
   --#                                        Scope,
   --#                                        STree.Table,
   --#                                        SubtypeSym,
   --#                                        TypeSym &
   --#         ErrorHandler.ErrorContext,
   --#         SLI.State,
   --#         SPARK_IO.FILE_SYS         from CommandLineData.Content,
   --#                                        ContextManager.Ops.FileHeap,
   --#                                        ContextManager.Ops.UnitHeap,
   --#                                        ContextManager.Ops.UnitStack,
   --#                                        Dictionary.Dict,
   --#                                        ErrorHandler.ErrorContext,
   --#                                        LexTokenManager.State,
   --#                                        Node,
   --#                                        Scope,
   --#                                        SLI.State,
   --#                                        SPARK_IO.File_Sys,
   --#                                        STree.Table,
   --#                                        SubtypeSym,
   --#                                        TypeSym;
   is
      It             : Dictionary.Iterator;
      ExpressionNode : STree.SyntaxNode;
   begin
      CheckNamedAssociation (TheFormals             => TypeSym,
                             Scope                  => Scope,
                             NamedArgumentAssocNode => Node);

      -- Loop through all the formals
      It := Dictionary.FirstKnownDiscriminant (TypeSym);
      while not Dictionary.IsNullIterator (It) loop
         ExpressionNode :=
           FindActualNode (ForFormal              => Dictionary.CurrentSymbol (It),
                           NamedArgumentAssocNode => Node);

         if ExpressionNode /= STree.NullNode then
            ProcessExpression
              (ExpNode    => ExpressionNode,
               FormalSym  => Dictionary.CurrentSymbol (It),
               SubtypeSym => SubtypeSym);
         end if;

         It := Dictionary.NextSymbol (It);
      end loop;
   end HandleNamedAssociation;

begin -- Wf_Ravenscar_Subtype
   Dictionary.AddTaskOrProtectedSubtype (Name        => IdStr,
                                         Parent      => TypeSym,
                                         Comp_Unit   => ContextManager.Ops.CurrentUnit,
                                         Declaration => Dictionary.Location'(NodePosition (IdNode),
                                                                             NodePosition (IdNode)),
                                         Scope       => Scope,
                                         Context     => Dictionary.ProgramContext,
                                         TheSubtype  => TheSubtype);
   if ErrorHandler.Generate_SLI then
      SLI.Generate_Xref_Symbol (Comp_Unit      => ContextManager.Ops.CurrentUnit,
                                Parse_Tree     => IdNode,
                                Symbol         => TheSubtype,
                                Is_Declaration => True);
   end if;
   AssocNode := Child_Node (Child_Node (ConstraintNode));
   if SyntaxNodeType (AssocNode) = SPSymbols.named_argument_association then
      HandleNamedAssociation (AssocNode,
                              TheSubtype);
   else
      HandlePositionalAssociation (AssocNode,
                                   TheSubtype);
   end if;
   -- Check that subtype has a priority, if one has not been set then inherit parent's
   if LexTokenManager.Lex_String_Case_Insensitive_Compare (Lex_Str1 => Dictionary.GetTypePriority (TheSubtype),
                                                           Lex_Str2 => LexTokenManager.Null_String) = LexTokenManager.Str_Eq then
      Dictionary.SetSubtypePriority (TheSubtype, Dictionary.GetTypePriority (TypeSym));
   end if;
end Wf_Ravenscar_Subtype;
