-- $Id: sem-compunit-wf_subprogram_body-processpartitionannotation.adb 15520 2010-01-07 12:53:45Z spark $
--------------------------------------------------------------------------------
-- (C) Altran Praxis Limited
--------------------------------------------------------------------------------
--
-- The SPARK toolset is free software; you can redistribute it and/or modify it
-- under terms of the GNU General Public License as published by the Free
-- Software Foundation; either version 3, or (at your option) any later
-- version. The SPARK toolset is distributed in the hope that it will be
-- useful, but WITHOUT ANY WARRANTY; without even the implied warranty of
-- MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the GNU General
-- Public License for more details. You should have received a copy of the GNU
-- General Public License distributed with the SPARK toolset; see file
-- COPYING3. If not, go to http://www.gnu.org/licenses for a complete copy of
-- the license.
--
--==============================================================================


separate (Sem.CompUnit.wf_subprogram_body)
procedure ProcessPartitionAnnotation (MainNode : in STree.SyntaxNode;
                                      Scope    : in Dictionary.Scopes)
is
   GlobalNode,
   DerivesNode : STree.SyntaxNode;
   AnnoError   : Boolean;

   function FindMainProgramAnnoNode return STree.SyntaxNode
   --# global in MainNode;
   --#        in STree.Table;
   is
      Result : STree.SyntaxNode;
   begin
      -- MainNode is main_program_declaration
      Result := Child_Node (MainNode);
      if SyntaxNodeType (Result) = SPSymbols.inherit_clause then
         Result := Next_Sibling (Result);
      end if;
      return Result;
   end FindMainProgramAnnoNode;

   function FindGlobalNode return STree.SyntaxNode
   --# global in MainNode;
   --#        in STree.Table;
   is
      Result : STree.SyntaxNode;
   begin
      Result := Next_Sibling (FindMainProgramAnnoNode);
      if SyntaxNodeType (Result) /= SPSymbols.moded_global_definition then
         Result := STree.NullNode;
      end if;
      return Result;
   end FindGlobalNode;

   function FindDerivesNode return STree.SyntaxNode
   --# global in MainNode;
   --#        in STree.Table;
   is
      Result : STree.SyntaxNode;
   begin
      Result := Next_Sibling (FindGlobalNode);
      if SyntaxNodeType (Result) /= SPSymbols.dependency_relation then
         Result := STree.NullNode;
      end if;
      return Result;
   end FindDerivesNode;

   -----------------

begin -- ProcessPartitionAnnotation
   GlobalNode  := FindGlobalNode;
   DerivesNode := FindDerivesNode;

   -- A partition annotation exists if the GlobalNode is not null.
   -- There must be a partition annotation in Ravenscar and there
   -- must not be one otherwise
   if not CommandLineData.RavenscarSelected then
      if GlobalNode /= STree.NullNode then
         -- unexpected partition annotation
         ErrorHandler.SemanticError (949,
                                     ErrorHandler.NoReference,
                                     NodePosition (GlobalNode),
                                     LexTokenManager.Null_String);
      end if;
   else -- Ravenscar IS selected
      if GlobalNode = STree.NullNode then
         -- missing partition annotation
         Dictionary.SetSubprogramSignatureNotWellformed (Dictionary.IsAbstract,
                                                         Dictionary.GetThePartition);
         ErrorHandler.SemanticError (950,
                                     ErrorHandler.NoReference,
                                     NodePosition (FindMainProgramAnnoNode),
                                     LexTokenManager.Null_String);
      else
         -- partition annotation both present and required, so process it
         -- first the globals
         wf_global_definition (Node         => GlobalNode,
                               CurrentScope => Scope,
                               SubprogSym   => Dictionary.GetThePartition,
                               FirstSeen    => True,
                                 -- to get
                               SemErrFound  => AnnoError);
         if AnnoError then
            Dictionary.SetSubprogramSignatureNotWellformed (Dictionary.IsAbstract,
                                                            Dictionary.GetThePartition);
         end if;

         -- now check whether derives is there
         if DerivesNode /= STree.NullNode then
            if CommandLineData.Content.DoInformationFlow then
               -- derives present and required
               wf_dependency_relation (Node         => DerivesNode,
                                       CurrentScope => Scope,
                                       SubprogSym   => Dictionary.GetThePartition,
                                       FirstSeen    => True,
                                       GlobDefErr   => AnnoError);
            else
               -- in DFA mode, we ignore the derives and use the moded globals
               CreateFullSubProgDependency (DerivesNode,
                                            Dictionary.GetThePartition,
                                            Dictionary.IsAbstract);
               ErrorHandler.SemanticNote (1,
                                          NodePosition (DerivesNode),
                                          LexTokenManager.Null_String);
            end if;
         else -- Derives is NOT present
            if  CommandLineData.Content.DoInformationFlow then
               -- but in IFA mode it should have been
               ErrorHandler.SemanticError (501,
                                           ErrorHandler.NoReference,
                                           NodePosition (GlobalNode),
                                           LexTokenManager.Null_String);
            else
               -- not there but ok because DFA selected
               CreateFullSubProgDependency (GlobalNode,
                                            Dictionary.GetThePartition,
                                            Dictionary.IsAbstract);
            end if;
         end if;
      end if;
   end if;
end ProcessPartitionAnnotation;
