-- $Id: sem-compunit-wf_record_component_selector_name.adb 15674 2010-01-20 16:17:20Z spark $
--------------------------------------------------------------------------------
-- (C) Altran Praxis Limited
--------------------------------------------------------------------------------
--
-- The SPARK toolset is free software; you can redistribute it and/or modify it
-- under terms of the GNU General Public License as published by the Free
-- Software Foundation; either version 3, or (at your option) any later
-- version. The SPARK toolset is distributed in the hope that it will be
-- useful, but WITHOUT ANY WARRANTY; without even the implied warranty of
-- MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the GNU General
-- Public License for more details. You should have received a copy of the GNU
-- General Public License distributed with the SPARK toolset; see file
-- COPYING3. If not, go to http://www.gnu.org/licenses for a complete copy of
-- the license.
--
--==============================================================================


separate (Sem.CompUnit)

procedure wf_record_component_selector_name (Node         : in     STree.SyntaxNode;
                                             Scope        : in     Dictionary.Scopes;
                                             EStack       : in out ExpStack.ExpStackType;
                                             HeapParam    : in out Lists.List_Heap;
                                             NextNode     :    out STree.SyntaxNode)
is
   NameExp,
   FieldInfo      : ExpRecord;
   FieldIdent     : LexTokenManager.Lex_String;
   FieldSymbol    : Dictionary.Symbol;
   AlreadyPresent : Boolean;


   function IdentifierNode return STree.SyntaxNode
   --# global in Node;
   --#        in STree.Table;
   is
   begin
      return Child_Node (Node);
   end IdentifierNode;

   --------------------------------------------

   procedure CheckValidField (AggregateType : in     Dictionary.Symbol;
                              AncestorType  : in     Dictionary.Symbol;
                              Ident_Node    : in     STree.SyntaxNode;
                              FieldSymbol   :    out Dictionary.Symbol)
   --# global in     CommandLineData.Content;
   --#        in     Dictionary.Dict;
   --#        in     LexTokenManager.State;
   --#        in     Scope;
   --#        in out ErrorHandler.ErrorContext;
   --#        in out SPARK_IO.File_Sys;
   --#        in out STree.Table;
   --# derives ErrorHandler.ErrorContext,
   --#         SPARK_IO.File_Sys         from AggregateType,
   --#                                        AncestorType,
   --#                                        CommandLineData.Content,
   --#                                        Dictionary.Dict,
   --#                                        ErrorHandler.ErrorContext,
   --#                                        Ident_Node,
   --#                                        LexTokenManager.State,
   --#                                        Scope,
   --#                                        SPARK_IO.File_Sys,
   --#                                        STree.Table &
   --#         FieldSymbol               from AggregateType,
   --#                                        AncestorType,
   --#                                        CommandLineData.Content,
   --#                                        Dictionary.Dict,
   --#                                        Ident_Node,
   --#                                        LexTokenManager.State,
   --#                                        Scope,
   --#                                        STree.Table &
   --#         STree.Table               from AggregateType,
   --#                                        CommandLineData.Content,
   --#                                        Dictionary.Dict,
   --#                                        Ident_Node,
   --#                                        LexTokenManager.State,
   --#                                        Scope,
   --#                                        STree.Table;
   is
      AggregateFieldSym,
      AncestorFieldSym  : Dictionary.Symbol;
      Field_Str         : LexTokenManager.Lex_String;
   begin
      Field_Str := NodeLexString (Ident_Node);
      AggregateFieldSym := Dictionary.LookupSelectedItem (Prefix   => AggregateType,
                                                          Selector => Field_Str,
                                                          Scope    => Scope,
                                                          Context  => Dictionary.ProgramContext);
      if AggregateFieldSym = Dictionary.NullSymbol then --no such field
         ErrorHandler.SemanticError (8,
                                     ErrorHandler.NoReference,
                                     NodePosition (Ident_Node),
                                     Field_Str);
         FieldSymbol := Dictionary.NullSymbol;
      else
         STree.Set_Node_Lex_String (Sym  => AggregateFieldSym,
                                    Node => Ident_Node);
         -- field found, but we need to check that it is not in the ancestor part
         AncestorFieldSym := Dictionary.LookupSelectedItem (Prefix   => AncestorType,
                                                            Selector => Field_Str,
                                                            Scope    => Scope,
                                                            Context  => Dictionary.ProgramContext);
         if AncestorFieldSym = Dictionary.NullSymbol then
            -- not in ancestor part
            FieldSymbol := AggregateFieldSym;
         else
            -- it is in the ancestor part
            ErrorHandler.SemanticError (865,
                                        ErrorHandler.NoReference,
                                        NodePosition (Ident_Node),
                                        Field_Str);
            FieldSymbol := Dictionary.NullSymbol;
         end if;
      end if;
   end CheckValidField;

   --------------------------------------------------------

begin
   ExpStack.Pop (NameExp, EStack);
   FieldIdent := NodeLexString (IdentifierNode);
   CheckValidField (AggregateType => NameExp.TypeSymbol,
                    AncestorType  => NameExp.OtherSymbol,
                    Ident_Node    => IdentifierNode,
                    FieldSymbol   => FieldSymbol);
   if FieldSymbol = Dictionary.NullSymbol then
      -- look up failed so push a null record as a placeholder
      ExpStack.Push (NameExp, EStack);
      ExpStack.Push (NullParameterRecord, EStack);
   else
      -- valid field name
      AddName (FieldIdent,
               NameExp.ParamList,
               HeapParam,
               AlreadyPresent);
      if AlreadyPresent then
         ExpStack.Push (NameExp, EStack);
         ExpStack.Push (NullParameterRecord, EStack);
         ErrorHandler.SemanticError (103,  --already has a value
                                     ErrorHandler.NoReference,
                                     NodePosition (IdentifierNode),
                                     FieldIdent);
      else --no value thus far assigned
         FieldInfo := NullParameterRecord;
         FieldInfo.OtherSymbol := FieldSymbol;
         ExpStack.Push (NameExp, EStack);
         ExpStack.Push (FieldInfo, EStack);
      end if;
   end if;
   NextNode := STree.NullNode;
end wf_record_component_selector_name;
