-- $Id: sem-compunit-wf_proof_function_declaration.adb 15674 2010-01-20 16:17:20Z spark $
--------------------------------------------------------------------------------
-- (C) Altran Praxis Limited
--------------------------------------------------------------------------------
--
-- The SPARK toolset is free software; you can redistribute it and/or modify it
-- under terms of the GNU General Public License as published by the Free
-- Software Foundation; either version 3, or (at your option) any later
-- version. The SPARK toolset is distributed in the hope that it will be
-- useful, but WITHOUT ANY WARRANTY; without even the implied warranty of
-- MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the GNU General
-- Public License for more details. You should have received a copy of the GNU
-- General Public License distributed with the SPARK toolset; see file
-- COPYING3. If not, go to http://www.gnu.org/licenses for a complete copy of
-- the license.
--
--==============================================================================

with SLI;

separate (Sem.CompUnit)

procedure wf_proof_function_declaration (Node       : in     STree.SyntaxNode;
                                         Scope      : in     Dictionary.Scopes;
                                         TheFuncSym :    out Dictionary.Symbol)
is
   SpecNode,
   ConstraintNode,
   FormalPartNode : STree.SyntaxNode;
   FuncSym        : Dictionary.Symbol;

   -----------------------------------------------------------

   procedure CheckFunctionSpecification (Node         : in     STree.SyntaxNode;
                                         CurrentScope : in     Dictionary.Scopes;
                                         SubProgSym   :    out Dictionary.Symbol)
   --# global in     CommandLineData.Content;
   --#        in     ContextManager.Ops.UnitStack;
   --#        in     LexTokenManager.State;
   --#        in out Dictionary.Dict;
   --#        in out ErrorHandler.ErrorContext;
   --#        in out SPARK_IO.FILE_SYS;
   --#        in out STree.Table;
   --# derives Dictionary.Dict,
   --#         STree.Table               from CommandLineData.Content,
   --#                                        ContextManager.Ops.UnitStack,
   --#                                        CurrentScope,
   --#                                        Dictionary.Dict,
   --#                                        LexTokenManager.State,
   --#                                        Node,
   --#                                        STree.Table &
   --#         ErrorHandler.ErrorContext,
   --#         SPARK_IO.FILE_SYS         from CommandLineData.Content,
   --#                                        ContextManager.Ops.UnitStack,
   --#                                        CurrentScope,
   --#                                        Dictionary.Dict,
   --#                                        ErrorHandler.ErrorContext,
   --#                                        LexTokenManager.State,
   --#                                        Node,
   --#                                        SPARK_IO.FILE_SYS,
   --#                                        STree.Table &
   --#         SubProgSym                from ContextManager.Ops.UnitStack,
   --#                                        CurrentScope,
   --#                                        Dictionary.Dict,
   --#                                        LexTokenManager.State,
   --#                                        Node,
   --#                                        STree.Table;
   is
      ReturnTypeNode   : STree.SyntaxNode;
      IdentStr         : LexTokenManager.Lex_String;
      SubProgSymLocal,
      TypeSym          : Dictionary.Symbol;
   begin
      SubProgSymLocal := Dictionary.NullSymbol;
      IdentStr := NodeLexString (Child_Node (Child_Node (Node)));
      if Dictionary.IsDirectlyDefined (IdentStr,
                                       CurrentScope,
                                       Dictionary.ProofContext)
      then
         ErrorHandler.SemanticError (10,
                                     ErrorHandler.NoReference, --illegal redeclaration
                                     NodePosition (Node),
                                     IdentStr);
      else
         Dictionary.AddSubprogram (Name          => IdentStr,
                                   Comp_Unit     => ContextManager.Ops.CurrentUnit,
                                   Specification => Dictionary.Location'(NodePosition (Node),
                                                                         NodePosition (Node)),
                                   Scope         => CurrentScope,
                                   Context       => Dictionary.ProofContext,
                                   -- to get
                                   Subprogram    => SubProgSymLocal);
      end if;
      ReturnTypeNode := LastSiblingOf (Child_Node (Node));
      wf_type_mark (ReturnTypeNode,
                    CurrentScope,
                    Dictionary.ProofContext,
                     --to get
                    TypeSym);
      if Dictionary.IsUnconstrainedArrayType (TypeSym) then
         TypeSym := Dictionary.GetUnknownTypeMark;
         ErrorHandler.SemanticError (39, --illegal use of unconstrained array type
                                     ErrorHandler.NoReference,
                                     NodePosition (ReturnTypeNode),
                                     NodeLexString (ReturnTypeNode));
      elsif Dictionary.IsPredefinedSuspensionObjectType (TypeSym) or
        Dictionary.TypeIsProtected (TypeSym) then
         TypeSym := Dictionary.GetUnknownTypeMark;
         ErrorHandler.SemanticError (905,
                                     ErrorHandler.NoReference,
                                     NodePosition (ReturnTypeNode),
                                     LexTokenManager.Null_String);
      end if;
      if SubProgSymLocal /= Dictionary.NullSymbol then
         Dictionary.AddReturnType (TheFunction   => SubProgSymLocal,
                                   TypeMark      => TypeSym,
                                   Comp_Unit     => ContextManager.Ops.CurrentUnit,
                                   TypeReference => Dictionary.Location'(NodePosition (ReturnTypeNode),
                                                                         NodePosition (ReturnTypeNode)));
      end if;
      SubProgSym := SubProgSymLocal;
   end CheckFunctionSpecification;

   ------------------------------------------------------------------------

begin --wf_proof_function_declaration
      --assume Node is proof_function_declaration
   SpecNode := Child_Node (Node);
   ConstraintNode := Next_Sibling (SpecNode);
   CheckFunctionSpecification (SpecNode,
                               Scope,
                                 --to get
                               FuncSym);
   TheFuncSym := FuncSym; -- return it to caller
   if FuncSym /= Dictionary.NullSymbol then
      FormalPartNode := Next_Sibling (Child_Node (SpecNode));
      if SyntaxNodeType (FormalPartNode) =
        SPSymbols.formal_part
      then
         wf_formal_part (FormalPartNode,
                         Scope,
                         FuncSym,
                         True,   --function cannot already be declared
                         Dictionary.ProofContext);
      end if;
   end if;

   if Child_Node (ConstraintNode) /= STree.NullNode then
      ErrorHandler.SemanticError (315,
                                  ErrorHandler.NoReference,
                                  NodePosition (ConstraintNode),
                                  LexTokenManager.Null_String);
   end if;

   if ErrorHandler.Generate_SLI then
      SLI.Generate_Xref_Proof_Function (Comp_Unit   => ContextManager.Ops.CurrentUnit,
                                        Parse_Tree  => Node,
                                        Scope       => Scope,
                                        Subprog_Sym => FuncSym);
   end if;

end wf_proof_function_declaration;
