-- $Id: sem-compunit-wf_priority_value.adb 15674 2010-01-20 16:17:20Z spark $
--------------------------------------------------------------------------------
-- (C) Altran Praxis Limited
--------------------------------------------------------------------------------
--
-- The SPARK toolset is free software; you can redistribute it and/or modify it
-- under terms of the GNU General Public License as published by the Free
-- Software Foundation; either version 3, or (at your option) any later
-- version. The SPARK toolset is distributed in the hope that it will be
-- useful, but WITHOUT ANY WARRANTY; without even the implied warranty of
-- MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the GNU General
-- Public License for more details. You should have received a copy of the GNU
-- General Public License distributed with the SPARK toolset; see file
-- COPYING3. If not, go to http://www.gnu.org/licenses for a complete copy of
-- the license.
--
--==============================================================================

separate (Sem.CompUnit)

procedure wf_priority_value (Node       : in     STree.SyntaxNode;
                             PragmaKind : in     Dictionary.RavenscarPragmas;
                             Context    : in     Dictionary.Contexts;
                             ErrorSym   : in     Dictionary.Symbol;
                             Scope      : in     Dictionary.Scopes;
                             ValueRep   :    out LexTokenManager.Lex_String;
                             Compatible :    out Boolean)
is
   TypeSym             : Dictionary.Symbol;
   Result              : ExpRecord;
   UnusedSeq           : SeqAlgebra.Seq;
   UnusedComponentData : ComponentManager.ComponentData;
begin
   -- check validity of argument
   -- must be integer and in appropriate System.[Interrupt_]Priority range
   SeqAlgebra.CreateSeq (TheHeap, UnusedSeq);
   ComponentManager.Initialise (UnusedComponentData);
   --# accept Flow, 10, UnusedComponentData, "Expected ineffective assignment";
   if Context = Dictionary.ProgramContext then
      WalkExpression
        (ExpNode               => Node,
         Scope                 => Scope,
         TypeContext           => Dictionary.GetPredefinedIntegerType,
         ContextRequiresStatic => True,
         Result                => Result,
         RefVar                => UnusedSeq,
         ComponentData         => UnusedComponentData);
   else
      WalkAnnotationExpression
        (ExpNode        => Node,
         Scope          => Scope,
         TypeContext    => Dictionary.GetPredefinedIntegerType,
         Context        => Precondition, -- no ~ allowed here, so use Precondition context
         Result         => Result,
         ComponentData  => UnusedComponentData);
   end if;
   --# end accept;

   SeqAlgebra.DisposeOfSeq (TheHeap, UnusedSeq);

   -- actual parameter must be fixed
   if not Result.IsConstant then
      ErrorHandler.SemanticError (37,
                                  ErrorHandler.NoReference,
                                  NodePosition (Node),
                                  LexTokenManager.Null_String);
   end if;

   -- argument must be integer value
   TypeSym := Dictionary.GetRootType (Result.TypeSymbol);
   if Dictionary.CompatibleTypes (Scope, TypeSym, Dictionary.GetPredefinedIntegerType) then
      Compatible := True;
      -- range checking here if values known in Dictionary
      CheckPriorityRange (ErrorSym   => ErrorSym,
                          Scope      => Scope,
                          PragmaKind => PragmaKind,
                          ErrPos     => NodePosition (Node),
                          Value      => Result.Value,
                          ValueRep   => ValueRep);
   else
      Compatible := False;
      ValueRep := LexTokenManager.Null_String;
      ErrorHandler.SemanticError (877,
                                  ErrorHandler.NoReference,
                                  NodePosition (Node),
                                  LexTokenManager.Null_String);
   end if;
end wf_priority_value;
