-- $Id: sem-compunit-wf_package_specification-wf_visible-wf_private_type_declaration.adb 15674 2010-01-20 16:17:20Z spark $
--------------------------------------------------------------------------------
-- (C) Altran Praxis Limited
--------------------------------------------------------------------------------
--
-- The SPARK toolset is free software; you can redistribute it and/or modify it
-- under terms of the GNU General Public License as published by the Free
-- Software Foundation; either version 3, or (at your option) any later
-- version. The SPARK toolset is distributed in the hope that it will be
-- useful, but WITHOUT ANY WARRANTY; without even the implied warranty of
-- MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the GNU General
-- Public License for more details. You should have received a copy of the GNU
-- General Public License distributed with the SPARK toolset; see file
-- COPYING3. If not, go to http://www.gnu.org/licenses for a complete copy of
-- the license.
--
--==============================================================================


separate (Sem.CompUnit.wf_package_specification.wf_visible)

procedure wf_private_type_declaration (Node         : in STree.SyntaxNode;
                                       PackSym      : in Dictionary.Symbol;
                                       CurrentScope : in Dictionary.Scopes)
is
   IsLimited : Boolean;
   IdentNode,
   NextNode  : STree.SyntaxNode;
   IdentStr  : LexTokenManager.Lex_String;
   Sym       : Dictionary.Symbol;
   IsAbstract : Boolean;
   IsTagged   : Boolean;

   procedure SetTagStatus (TagOptionNode : in STree.SyntaxNode)
   --# global in     STree.Table;
   --#           out IsAbstract;
   --#           out IsTagged;
   --# derives IsAbstract,
   --#         IsTagged   from STree.Table,
   --#                         TagOptionNode;
   is
   begin
      IsAbstract := SyntaxNodeType (TagOptionNode) = SPSymbols.abstract_tagged;
      IsTagged := IsAbstract or SyntaxNodeType (TagOptionNode) = SPSymbols.non_abstract_tagged;
   end SetTagStatus;

begin
   -- ASSUME Node = private_type_declaration


   NextNode := Child_Node (Node);
   IsLimited := (SyntaxNodeType (NextNode) =
                 SPSymbols.limited_private_type_declaration);
   IdentNode := Child_Node (NextNode);
   SetTagStatus (Child_Node (Next_Sibling (IdentNode)));

   IdentStr  := NodeLexString (IdentNode);

   -- temporary prevention of use of abstract types
   if IsAbstract then
      ErrorHandler.SemanticError (820,
                                  ErrorHandler.NoReference,
                                  NodePosition (IdentNode),
                                  LexTokenManager.Null_String);
   end if;

   if IsTagged and then
     (Dictionary.PackageDeclaresTaggedType (Dictionary.GetRegion (CurrentScope)) or
        Dictionary.PackageExtendsAnotherPackage (Dictionary.GetRegion (CurrentScope))) then

      -- illegal second private tagged type declaration
      ErrorHandler.SemanticError (839,
                                  ErrorHandler.NoReference,
                                  NodePosition (Node),
                                  LexTokenManager.Null_String);
   else
      Sym := Dictionary.LookupItem (Name    => IdentStr,
                                    Scope   => CurrentScope,
                                    Context => Dictionary.ProofContext);

      if Sym = Dictionary.NullSymbol or else
        (Dictionary.IsTypeMark (Sym) and then
           Dictionary.TypeIsAnnounced (Sym) and then
           not Dictionary.IsDeclared (Sym) and then -- already declared, non private
           not Dictionary.TypeIsPrivate (Sym)) then  -- already declared, private
         if Sym /= Dictionary.NullSymbol then
            STree.Set_Node_Lex_String (Sym  => Sym,
                                       Node => IdentNode);
         end if;
         Dictionary.AddPrivateType (Name           => IdentStr,
                                    Comp_Unit      => ContextManager.Ops.CurrentUnit,
                                    Declaration    => Dictionary.Location'(NodePosition (IdentNode),
                                                                           NodePosition (IdentNode)),
                                    ThePackage     => PackSym,
                                    IsLimited      => IsLimited,
                                    IsTaggedType   => IsTagged,
                                    IsAbstractType => IsAbstract,
                                    Extends        => Dictionary.NullSymbol);
      else
         ErrorHandler.SemanticError (10,
                                     ErrorHandler.NoReference,
                                     NodePosition (IdentNode),
                                     IdentStr);
      end if;
   end if;

end wf_private_type_declaration;
