-- $Id: sem-compunit-wf_package_specification-wf_visible-wf_deferred.adb 15674 2010-01-20 16:17:20Z spark $
--------------------------------------------------------------------------------
-- (C) Altran Praxis Limited
--------------------------------------------------------------------------------
--
-- The SPARK toolset is free software; you can redistribute it and/or modify it
-- under terms of the GNU General Public License as published by the Free
-- Software Foundation; either version 3, or (at your option) any later
-- version. The SPARK toolset is distributed in the hope that it will be
-- useful, but WITHOUT ANY WARRANTY; without even the implied warranty of
-- MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the GNU General
-- Public License for more details. You should have received a copy of the GNU
-- General Public License distributed with the SPARK toolset; see file
-- COPYING3. If not, go to http://www.gnu.org/licenses for a complete copy of
-- the license.
--
--==============================================================================


separate (Sem.CompUnit.wf_package_specification.wf_visible)

procedure wf_deferred (Node         : in STree.SyntaxNode;
                       PackSym      : in Dictionary.Symbol;
                       CurrentScope : in Dictionary.Scopes)
is
   IdentListNode,
   TypeNode,
   NextNode       : STree.SyntaxNode;
   It             : STree.Iterator;
   IdentStr       : LexTokenManager.Lex_String;
   TypeSym        : Dictionary.Symbol;

   ---------------------------------------------------------------------

   procedure wf_local_private_type (Node         : in     STree.SyntaxNode;
                                    CurrentScope : in     Dictionary.Scopes;
                                    TypeSym      :    out Dictionary.Symbol)
   --# global in     CommandLineData.Content;
   --#        in     Dictionary.Dict;
   --#        in     LexTokenManager.State;
   --#        in out ErrorHandler.ErrorContext;
   --#        in out SPARK_IO.FILE_SYS;
   --#        in out STree.Table;
   --# derives ErrorHandler.ErrorContext,
   --#         SPARK_IO.FILE_SYS         from CommandLineData.Content,
   --#                                        CurrentScope,
   --#                                        Dictionary.Dict,
   --#                                        ErrorHandler.ErrorContext,
   --#                                        LexTokenManager.State,
   --#                                        Node,
   --#                                        SPARK_IO.FILE_SYS,
   --#                                        STree.Table &
   --#         STree.Table,
   --#         TypeSym                   from CurrentScope,
   --#                                        Dictionary.Dict,
   --#                                        LexTokenManager.State,
   --#                                        Node,
   --#                                        STree.Table;
   is
      Sym       : Dictionary.Symbol;
      IdentNode : STree.SyntaxNode;
      IdentStr  : LexTokenManager.Lex_String;
   begin
      IdentNode := LastChildOf (Node);
      IdentStr := NodeLexString (IdentNode);
      Sym := Dictionary.LookupItem (Name    => IdentStr,
                                    Scope   => CurrentScope,
                                    Context => Dictionary.ProgramContext);
      if Sym = Dictionary.NullSymbol then   -- not declared or visible
         TypeSym := Dictionary.GetUnknownTypeMark;
         ErrorHandler.SemanticError (141, ErrorHandler.NoReference,
                                     NodePosition (IdentNode),
                                     IdentStr);
      elsif Dictionary.IsType (Sym) and then Dictionary.TypeIsPrivate (Sym) then   --ok if not dotted
         if Next_Sibling (Child_Node (Child_Node (Node))) = STree.NullNode then  --no selector on type mark
            STree.Set_Node_Lex_String (Sym  => Sym,
                                       Node => IdentNode);
            TypeSym := Sym;
         else -- shouldn't have selector on private type!
            TypeSym := Dictionary.GetUnknownTypeMark;
            ErrorHandler.SemanticError (9,
                                        ErrorHandler.NoReference,
                                        NodePosition (IdentNode),
                                        IdentStr);
         end if;
      else   --not a local private type
         TypeSym := Dictionary.GetUnknownTypeMark;
         ErrorHandler.SemanticError (89,
                                     12,
                                     NodePosition (IdentNode),
                                     IdentStr);
      end if;
   end wf_local_private_type;

   ---------------------------------------------------------------------

begin  --wf_deferred_constant_declaration
   -- ASSUME Node = deferred_constant_declaration

   IdentListNode := Child_Node (Node);
   TypeNode := Next_Sibling (IdentListNode);

   case CommandLineData.Content.LanguageProfile is
      when CommandLineData.SPARK83 =>

         -- Can only be a private type in SPARK83
         wf_local_private_type (TypeNode,
                                CurrentScope,
                                --to get
                                TypeSym);

      when CommandLineData.SPARK95 |
        CommandLineData.SPARK2005 =>

         -- Any type allowed in 95 or 2005
         wf_type_mark (TypeNode,
                       CurrentScope,
                       Dictionary.ProgramContext,
                       --to get
                       TypeSym);
   end case;

   It := FindFirstNode (NodeKind    => SPSymbols.identifier,
                        FromRoot    => IdentListNode,
                        InDirection => STree.Down);

   while not STree.IsNull (It) loop
      NextNode := GetNode (It);
      IdentStr := NodeLexString (NextNode);
      if Dictionary.IsDefined (IdentStr,
                               CurrentScope,
                               Dictionary.ProofContext)
      then
         ErrorHandler.SemanticError (10,
                                     ErrorHandler.NoReference,
                                     NodePosition (NextNode),
                                     IdentStr);
      elsif Dictionary.IsPredefinedSuspensionObjectType (TypeSym) or
        Dictionary.TypeIsProtected (TypeSym) then
         ErrorHandler.SemanticError (903,
                                     ErrorHandler.NoReference,
                                     NodePosition (TypeNode),
                                     LexTokenManager.Null_String);
      else
         Dictionary.AddDeferredConstant
           (Name          => IdentStr,
            TypeMark      => TypeSym,
            TypeReference => Dictionary.Location'(NodePosition (TypeNode),
                                                  NodePosition (TypeNode)),
            Comp_Unit     => ContextManager.Ops.CurrentUnit,
            Declaration   => Dictionary.Location'(NodePosition (NextNode),
                                                  NodePosition (NextNode)),
            ThePackage    => PackSym);
      end if;
      It := STree.NextNode (It);
   end loop;
end wf_deferred;
