-- $Id: sem-compunit-wf_package_specification-wf_anno.adb 15674 2010-01-20 16:17:20Z spark $
--------------------------------------------------------------------------------
-- (C) Altran Praxis Limited
--------------------------------------------------------------------------------
--
-- The SPARK toolset is free software; you can redistribute it and/or modify it
-- under terms of the GNU General Public License as published by the Free
-- Software Foundation; either version 3, or (at your option) any later
-- version. The SPARK toolset is distributed in the hope that it will be
-- useful, but WITHOUT ANY WARRANTY; without even the implied warranty of
-- MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the GNU General
-- Public License for more details. You should have received a copy of the GNU
-- General Public License distributed with the SPARK toolset; see file
-- COPYING3. If not, go to http://www.gnu.org/licenses for a complete copy of
-- the license.
--
--==============================================================================


separate (Sem.CompUnit.wf_package_specification)

procedure wf_anno (Node         : in STree.SyntaxNode;
                   PackSym      : in Dictionary.Symbol;
                   ScopeType    : in EnclosingScopeTypes;
                   CurrentScope : in Dictionary.Scopes)
is
   --ASSUME CurrentScope is VisibleScope of PackSym

   OwnVarClauseNode,
   InitSpecNode   : STree.SyntaxNode;

   ----------------------------------------------------------

   procedure wf_own (Node         : in STree.SyntaxNode;
                     PackSym      : in Dictionary.Symbol;
                     ScopeType    : in EnclosingScopeTypes;
                     CurrentScope : in Dictionary.Scopes)
   --# global in     CommandLineData.Content;
   --#        in     ContextManager.Ops.FileHeap;
   --#        in     ContextManager.Ops.UnitHeap;
   --#        in     ContextManager.Ops.UnitStack;
   --#        in out AggregateStack.State;
   --#        in out Dictionary.Dict;
   --#        in out ErrorHandler.ErrorContext;
   --#        in out LexTokenManager.State;
   --#        in out SLI.State;
   --#        in out SPARK_IO.FILE_SYS;
   --#        in out Statistics.TableUsage;
   --#        in out STree.Table;
   --#        in out TheHeap;
   --# derives AggregateStack.State,
   --#         Dictionary.Dict,
   --#         LexTokenManager.State,
   --#         Statistics.TableUsage,
   --#         STree.Table,
   --#         TheHeap                   from *,
   --#                                        CommandLineData.Content,
   --#                                        ContextManager.Ops.UnitStack,
   --#                                        CurrentScope,
   --#                                        Dictionary.Dict,
   --#                                        LexTokenManager.State,
   --#                                        Node,
   --#                                        PackSym,
   --#                                        ScopeType,
   --#                                        STree.Table,
   --#                                        TheHeap &
   --#         ErrorHandler.ErrorContext,
   --#         SLI.State,
   --#         SPARK_IO.FILE_SYS         from CommandLineData.Content,
   --#                                        ContextManager.Ops.FileHeap,
   --#                                        ContextManager.Ops.UnitHeap,
   --#                                        ContextManager.Ops.UnitStack,
   --#                                        CurrentScope,
   --#                                        Dictionary.Dict,
   --#                                        ErrorHandler.ErrorContext,
   --#                                        LexTokenManager.State,
   --#                                        Node,
   --#                                        PackSym,
   --#                                        ScopeType,
   --#                                        SLI.State,
   --#                                        SPARK_IO.File_Sys,
   --#                                        STree.Table,
   --#                                        TheHeap;
      is separate;

   ----------------------------------------------------------

   procedure wf_init_spec (Node         : in STree.SyntaxNode;
                           PackSym      : in Dictionary.Symbol;
                           ScopeType    : in EnclosingScopeTypes;
                           CurrentScope : in Dictionary.Scopes)
   --# global in     CommandLineData.Content;
   --#        in     ContextManager.Ops.FileHeap;
   --#        in     ContextManager.Ops.UnitHeap;
   --#        in     ContextManager.Ops.UnitStack;
   --#        in     LexTokenManager.State;
   --#        in out Dictionary.Dict;
   --#        in out ErrorHandler.ErrorContext;
   --#        in out SLI.State;
   --#        in out SPARK_IO.FILE_SYS;
   --#        in out STree.Table;
   --# derives Dictionary.Dict,
   --#         STree.Table               from CurrentScope,
   --#                                        Dictionary.Dict,
   --#                                        LexTokenManager.State,
   --#                                        Node,
   --#                                        ScopeType,
   --#                                        STree.Table &
   --#         ErrorHandler.ErrorContext from *,
   --#                                        CommandLineData.Content,
   --#                                        CurrentScope,
   --#                                        Dictionary.Dict,
   --#                                        LexTokenManager.State,
   --#                                        Node,
   --#                                        PackSym,
   --#                                        ScopeType,
   --#                                        SPARK_IO.FILE_SYS,
   --#                                        STree.Table &
   --#         SLI.State                 from *,
   --#                                        CommandLineData.Content,
   --#                                        ContextManager.Ops.UnitHeap,
   --#                                        ContextManager.Ops.UnitStack,
   --#                                        CurrentScope,
   --#                                        Dictionary.Dict,
   --#                                        ErrorHandler.ErrorContext,
   --#                                        LexTokenManager.State,
   --#                                        Node,
   --#                                        PackSym,
   --#                                        ScopeType,
   --#                                        SPARK_IO.File_Sys,
   --#                                        STree.Table &
   --#         SPARK_IO.FILE_SYS         from *,
   --#                                        CommandLineData.Content,
   --#                                        ContextManager.Ops.FileHeap,
   --#                                        ContextManager.Ops.UnitHeap,
   --#                                        ContextManager.Ops.UnitStack,
   --#                                        CurrentScope,
   --#                                        Dictionary.Dict,
   --#                                        ErrorHandler.ErrorContext,
   --#                                        LexTokenManager.State,
   --#                                        Node,
   --#                                        PackSym,
   --#                                        ScopeType,
   --#                                        SLI.State,
   --#                                        STree.Table;
      is separate;

   ----------------------------------------------------------

   procedure DoLibraryPackage (
                               OwnVarClauseNode,
                                  InitSpecNode : in    STree.SyntaxNode;
                               PackSym      : in    Dictionary.Symbol;
                               CurrentScope : in    Dictionary.Scopes)
   --# global in     CommandLineData.Content;
   --#        in     ContextManager.Ops.FileHeap;
   --#        in     ContextManager.Ops.UnitHeap;
   --#        in     ContextManager.Ops.UnitStack;
   --#        in     Node;
   --#        in out AggregateStack.State;
   --#        in out Dictionary.Dict;
   --#        in out ErrorHandler.ErrorContext;
   --#        in out LexTokenManager.State;
   --#        in out SLI.State;
   --#        in out SPARK_IO.FILE_SYS;
   --#        in out Statistics.TableUsage;
   --#        in out STree.Table;
   --#        in out TheHeap;
   --# derives AggregateStack.State,
   --#         LexTokenManager.State,
   --#         Statistics.TableUsage,
   --#         TheHeap                   from *,
   --#                                        CommandLineData.Content,
   --#                                        ContextManager.Ops.UnitStack,
   --#                                        CurrentScope,
   --#                                        Dictionary.Dict,
   --#                                        LexTokenManager.State,
   --#                                        OwnVarClauseNode,
   --#                                        PackSym,
   --#                                        STree.Table,
   --#                                        TheHeap &
   --#         Dictionary.Dict,
   --#         STree.Table               from CommandLineData.Content,
   --#                                        ContextManager.Ops.UnitStack,
   --#                                        CurrentScope,
   --#                                        Dictionary.Dict,
   --#                                        InitSpecNode,
   --#                                        LexTokenManager.State,
   --#                                        OwnVarClauseNode,
   --#                                        PackSym,
   --#                                        STree.Table,
   --#                                        TheHeap &
   --#         SLI.State                 from *,
   --#                                        CommandLineData.Content,
   --#                                        ContextManager.Ops.FileHeap,
   --#                                        ContextManager.Ops.UnitHeap,
   --#                                        ContextManager.Ops.UnitStack,
   --#                                        CurrentScope,
   --#                                        Dictionary.Dict,
   --#                                        ErrorHandler.ErrorContext,
   --#                                        InitSpecNode,
   --#                                        LexTokenManager.State,
   --#                                        OwnVarClauseNode,
   --#                                        PackSym,
   --#                                        SPARK_IO.File_Sys,
   --#                                        STree.Table,
   --#                                        TheHeap &
   --#         ErrorHandler.ErrorContext,
   --#         SPARK_IO.FILE_SYS         from CommandLineData.Content,
   --#                                        ContextManager.Ops.FileHeap,
   --#                                        ContextManager.Ops.UnitHeap,
   --#                                        ContextManager.Ops.UnitStack,
   --#                                        CurrentScope,
   --#                                        Dictionary.Dict,
   --#                                        ErrorHandler.ErrorContext,
   --#                                        InitSpecNode,
   --#                                        LexTokenManager.State,
   --#                                        Node,
   --#                                        OwnVarClauseNode,
   --#                                        PackSym,
   --#                                        SLI.State,
   --#                                        SPARK_IO.FILE_SYS,
   --#                                        STree.Table,
   --#                                        TheHeap;
   is
      It        : Dictionary.Iterator;
      VarSym    : Dictionary.Symbol;
      ErrorNode : STree.SyntaxNode;
   begin

      ErrorNode := Node;
      if OwnVarClauseNode /= STree.NullNode then
         ErrorNode := OwnVarClauseNode;
         wf_own (Node         => OwnVarClauseNode,
                 PackSym      => PackSym,
                 ScopeType    => InLibrary,
                 CurrentScope => CurrentScope);
      end if;

      if InitSpecNode /= STree.NullNode then
         ErrorNode := InitSpecNode;
         Dictionary.AddInitializationSpecification
            (PackSym,
             Dictionary.Location'(NodePosition (InitSpecNode),
                                  NodePosition (InitSpecNode)));
         wf_init_spec (InitSpecNode,
                       PackSym,
                       InLibrary,
                       CurrentScope);
      end if;

      It := Dictionary.FirstOwnVariable (PackSym);
      while not Dictionary.IsNullIterator (It) loop
         VarSym := Dictionary.CurrentSymbol (It);
         if Dictionary.IsVirtualElement (VarSym) and then
           not Dictionary.IsOwnVariableOrConstituentWithMode (VarSym) and then
           not Dictionary.OwnVariableIsInitialized (VarSym) then
            -- Unmoded own variables that appear in a protects list MUST appear in
            -- an intializes clause.
            ErrorHandler.SemanticError (860,
                                        ErrorHandler.NoReference,
                                        NodePosition (ErrorNode),
                                        Dictionary.GetSimpleName (VarSym));
         end if;
         It := Dictionary.NextSymbol (It);
      end loop;
   end DoLibraryPackage;

   ----------------------------------------------------------

   procedure DoEmbeddedPackage (AnnoNode,
                                OwnVarClauseNode,
                                InitSpecNode : in    STree.SyntaxNode;
                                PackSym      : in    Dictionary.Symbol;
                                CurrentScope : in    Dictionary.Scopes)
   --# global in     CommandLineData.Content;
   --#        in     ContextManager.Ops.FileHeap;
   --#        in     ContextManager.Ops.UnitHeap;
   --#        in     ContextManager.Ops.UnitStack;
   --#        in out AggregateStack.State;
   --#        in out Dictionary.Dict;
   --#        in out ErrorHandler.ErrorContext;
   --#        in out LexTokenManager.State;
   --#        in out SLI.State;
   --#        in out SPARK_IO.FILE_SYS;
   --#        in out Statistics.TableUsage;
   --#        in out STree.Table;
   --#        in out TheHeap;
   --# derives AggregateStack.State,
   --#         LexTokenManager.State,
   --#         Statistics.TableUsage,
   --#         TheHeap                   from *,
   --#                                        CommandLineData.Content,
   --#                                        ContextManager.Ops.UnitStack,
   --#                                        CurrentScope,
   --#                                        Dictionary.Dict,
   --#                                        LexTokenManager.State,
   --#                                        OwnVarClauseNode,
   --#                                        PackSym,
   --#                                        STree.Table,
   --#                                        TheHeap &
   --#         Dictionary.Dict,
   --#         STree.Table               from CommandLineData.Content,
   --#                                        ContextManager.Ops.UnitStack,
   --#                                        CurrentScope,
   --#                                        Dictionary.Dict,
   --#                                        InitSpecNode,
   --#                                        LexTokenManager.State,
   --#                                        OwnVarClauseNode,
   --#                                        PackSym,
   --#                                        STree.Table,
   --#                                        TheHeap &
   --#         SLI.State                 from *,
   --#                                        CommandLineData.Content,
   --#                                        ContextManager.Ops.FileHeap,
   --#                                        ContextManager.Ops.UnitHeap,
   --#                                        ContextManager.Ops.UnitStack,
   --#                                        CurrentScope,
   --#                                        Dictionary.Dict,
   --#                                        ErrorHandler.ErrorContext,
   --#                                        InitSpecNode,
   --#                                        LexTokenManager.State,
   --#                                        OwnVarClauseNode,
   --#                                        PackSym,
   --#                                        SPARK_IO.File_Sys,
   --#                                        STree.Table,
   --#                                        TheHeap &
   --#         ErrorHandler.ErrorContext,
   --#         SPARK_IO.FILE_SYS         from AnnoNode,
   --#                                        CommandLineData.Content,
   --#                                        ContextManager.Ops.FileHeap,
   --#                                        ContextManager.Ops.UnitHeap,
   --#                                        ContextManager.Ops.UnitStack,
   --#                                        CurrentScope,
   --#                                        Dictionary.Dict,
   --#                                        ErrorHandler.ErrorContext,
   --#                                        InitSpecNode,
   --#                                        LexTokenManager.State,
   --#                                        OwnVarClauseNode,
   --#                                        PackSym,
   --#                                        SLI.State,
   --#                                        SPARK_IO.FILE_SYS,
   --#                                        STree.Table,
   --#                                        TheHeap;
   is
      type InitExpected is (Yes, No, NoProtected);

      function InitializationExpected (PackSym : Dictionary.Symbol)
                                      return InitExpected
      --# global in Dictionary.Dict;
      is
         OwnVarList : Dictionary.Iterator;
         Expected   : InitExpected;

      begin
         Expected := No;
         OwnVarList := Dictionary.FirstOwnVariable (PackSym);
         while not Dictionary.IsNullIterator (OwnVarList) loop
            if not Dictionary.IsOwnVariableOrConstituentWithMode        --939
              (Dictionary.CurrentSymbol (OwnVarList)) and then
              Dictionary.OwnVariableIsInitialized
              (Dictionary.GetSubject (Dictionary.CurrentSymbol (OwnVarList))) and then
              not Dictionary.GetOwnVariableProtected (Dictionary.CurrentSymbol (OwnVarList)) -- 1011
            then
               Expected := Yes;
               exit;
            end if;
            --# assert True;
            if Dictionary.GetOwnVariableProtected (Dictionary.CurrentSymbol (OwnVarList)) then
               if Expected = No then
                  Expected := NoProtected;
               end if;
            end if;
            OwnVarList := Dictionary.NextSymbol (OwnVarList);
         end loop;

         return Expected;

      end InitializationExpected;

      ---------------------------------------------------------

   begin -- DoEmbeddedPackage
      if Dictionary.FirstOwnVariable (PackSym) =
         Dictionary.NullIterator
      then  --no refines announcements found
         if OwnVarClauseNode /= STree.NullNode then
            --unexpected own var clause
            ErrorHandler.SemanticError (80,
                                        ErrorHandler.NoReference,
                                        NodePosition (OwnVarClauseNode),
                                        LexTokenManager.Null_String);
         end if;

      else --at least one announcement found so there must be an own var clause
         if OwnVarClauseNode = STree.NullNode then
            --required own var clause is missing
            ErrorHandler.SemanticError (81,
                                        ErrorHandler.NoReference,
                                        NodePosition (ParentNode (AnnoNode)),
                                        LexTokenManager.Null_String);
         else -- own var clause both needed and present
            wf_own (Node         => OwnVarClauseNode,
                    PackSym      => PackSym,
                    ScopeType    => InPackage,
                    CurrentScope => CurrentScope);

            --now check for required or superfluous initializations
            case InitializationExpected (PackSym) is
               when Yes =>
                  if InitSpecNode = STree.NullNode then
                     --initialization missing from inner package
                     ErrorHandler.SemanticError (83,
                                                 ErrorHandler.NoReference,
                                                 NodePosition (OwnVarClauseNode),
                                                 LexTokenManager.Null_String);
                  else --initialization both required and present
                     wf_init_spec (InitSpecNode,
                                   PackSym,
                                   InPackage,
                                   CurrentScope);
                  end if;

               when No =>
                  if InitSpecNode /= STree.NullNode then
                     --unexpected init
                     ErrorHandler.SemanticError (82,
                                                 ErrorHandler.NoReference,
                                                 NodePosition (InitSpecNode),
                                                 LexTokenManager.Null_String);
                  end if;

               when NoProtected =>
                  if InitSpecNode /= STree.NullNode then
                     -- unexpected init on protected state
                     ErrorHandler.SemanticError (864,
                                                 ErrorHandler.NoReference,
                                                 NodePosition (InitSpecNode),
                                                 LexTokenManager.Null_String);
                  end if;
            end case;
         end if;
      end if;
   end DoEmbeddedPackage;

   ----------------------------------------------------------

begin  --wf_anno
   OwnVarClauseNode := Child_Node (Node);
   if OwnVarClauseNode = STree.NullNode then
      InitSpecNode := STree.NullNode;
   else
      InitSpecNode := Next_Sibling (OwnVarClauseNode);
   end if;

   if OwnVarClauseNode /= STree.NullNode then
      --annotation exists
      Dictionary.AddOwnAnnotation (PackSym,
                                   Dictionary.Location'(NodePosition (Node),
                                                        NodePosition (Node)));
   end if;

   if ScopeType = InPackage then
      --package embedded in package
      DoEmbeddedPackage (AnnoNode         => Node,
                         OwnVarClauseNode => OwnVarClauseNode,
                         InitSpecNode     => InitSpecNode,
                         PackSym          => PackSym,
                         CurrentScope     => CurrentScope);

   else  --library unit or package embedded in procedure
      DoLibraryPackage (OwnVarClauseNode => OwnVarClauseNode,
                        InitSpecNode     => InitSpecNode,
                        PackSym          => PackSym,
                        CurrentScope     => CurrentScope);
   end if;
end wf_anno;
