-- $Id: sem-compunit-wf_package_specification-wf_anno-wf_own.adb 15674 2010-01-20 16:17:20Z spark $
--------------------------------------------------------------------------------
-- (C) Altran Praxis Limited
--------------------------------------------------------------------------------
--
-- The SPARK toolset is free software; you can redistribute it and/or modify it
-- under terms of the GNU General Public License as published by the Free
-- Software Foundation; either version 3, or (at your option) any later
-- version. The SPARK toolset is distributed in the hope that it will be
-- useful, but WITHOUT ANY WARRANTY; without even the implied warranty of
-- MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the GNU General
-- Public License for more details. You should have received a copy of the GNU
-- General Public License distributed with the SPARK toolset; see file
-- COPYING3. If not, go to http://www.gnu.org/licenses for a complete copy of
-- the license.
--
--==============================================================================

separate (Sem.CompUnit.wf_package_specification.wf_anno)

procedure wf_own (Node         : in STree.SyntaxNode;
                  PackSym      : in Dictionary.Symbol;
                  ScopeType    : in EnclosingScopeTypes;
                  CurrentScope : in Dictionary.Scopes)
is
   It : STree.Iterator;

   -------------------------------------------------------------------------

   procedure wf_own_task (Node          : in     STree.SyntaxNode;
                          IdentStr      : in     LexTokenManager.Lex_String;
                          Declaration   : in     Dictionary.Location;
                          TypeAnnounced : in     Boolean;
                          AnnouncedType : in     Dictionary.Symbol;
                          PackSym       : in     Dictionary.Symbol;
                          TaskSym       :    out Dictionary.Symbol)
   --# global in     CommandLineData.Content;
   --#        in     ContextManager.Ops.UnitStack;
   --#        in     LexTokenManager.State;
   --#        in     STree.Table;
   --#        in out Dictionary.Dict;
   --#        in out ErrorHandler.ErrorContext;
   --#        in out SPARK_IO.FILE_SYS;
   --# derives Dictionary.Dict           from *,
   --#                                        AnnouncedType,
   --#                                        ContextManager.Ops.UnitStack,
   --#                                        Declaration,
   --#                                        IdentStr,
   --#                                        PackSym,
   --#                                        TypeAnnounced &
   --#         ErrorHandler.ErrorContext,
   --#         SPARK_IO.FILE_SYS         from CommandLineData.Content,
   --#                                        Dictionary.Dict,
   --#                                        ErrorHandler.ErrorContext,
   --#                                        IdentStr,
   --#                                        LexTokenManager.State,
   --#                                        Node,
   --#                                        SPARK_IO.FILE_SYS,
   --#                                        STree.Table,
   --#                                        TypeAnnounced &
   --#         TaskSym                   from ContextManager.Ops.UnitStack,
   --#                                        Declaration,
   --#                                        Dictionary.Dict,
   --#                                        TypeAnnounced;
   is
   begin
      if not TypeAnnounced then
         TaskSym := Dictionary.NullSymbol;
         -- Tasks must announce their type
         ErrorHandler.SemanticError (925,
                                     ErrorHandler.NoReference,
                                     NodePosition (Node),
                                     IdentStr);
      else
         Dictionary.AddOwnTask (Name        => IdentStr,
                                Comp_Unit   => ContextManager.Ops.CurrentUnit,
                                Declaration => Declaration,
                                TypeMark    => AnnouncedType,
                                ThePackage  => PackSym,
                                -- to get
                                TaskSym     => TaskSym);
      end if;
   end wf_own_task;

   -------------------------------------------------------------------------

   procedure wf_own_variable_specification (Node         : in STree.SyntaxNode;
                                            PackSym      : in Dictionary.Symbol;
                                            ScopeType    : in EnclosingScopeTypes;
                                            CurrentScope : in Dictionary.Scopes)
   --# global in     CommandLineData.Content;
   --#        in     ContextManager.Ops.FileHeap;
   --#        in     ContextManager.Ops.UnitHeap;
   --#        in     ContextManager.Ops.UnitStack;
   --#        in out AggregateStack.State;
   --#        in out Dictionary.Dict;
   --#        in out ErrorHandler.ErrorContext;
   --#        in out LexTokenManager.State;
   --#        in out SLI.State;
   --#        in out SPARK_IO.FILE_SYS;
   --#        in out Statistics.TableUsage;
   --#        in out STree.Table;
   --#        in out TheHeap;
   --# derives ErrorHandler.ErrorContext,
   --#         SLI.State,
   --#         SPARK_IO.FILE_SYS         from CommandLineData.Content,
   --#                                        ContextManager.Ops.FileHeap,
   --#                                        ContextManager.Ops.UnitHeap,
   --#                                        ContextManager.Ops.UnitStack,
   --#                                        CurrentScope,
   --#                                        Dictionary.Dict,
   --#                                        ErrorHandler.ErrorContext,
   --#                                        LexTokenManager.State,
   --#                                        Node,
   --#                                        PackSym,
   --#                                        ScopeType,
   --#                                        SLI.State,
   --#                                        SPARK_IO.File_Sys,
   --#                                        STree.Table,
   --#                                        TheHeap &
   --#         AggregateStack.State,
   --#         Dictionary.Dict,
   --#         LexTokenManager.State,
   --#         Statistics.TableUsage,
   --#         STree.Table,
   --#         TheHeap                   from *,
   --#                                        CommandLineData.Content,
   --#                                        ContextManager.Ops.UnitStack,
   --#                                        CurrentScope,
   --#                                        Dictionary.Dict,
   --#                                        LexTokenManager.State,
   --#                                        Node,
   --#                                        PackSym,
   --#                                        ScopeType,
   --#                                        STree.Table,
   --#                                        TheHeap;
   is
      type WffRules is (UseEmbedded, UseLibrary);
      type Modes is
         record
            Value   : Dictionary.Modes;
            IsValid : Boolean;
         end record;

      WffRule        : WffRules;
      TypeAnnounced  : Boolean;
      TypeNode,
      PropertyListNode,
      IdentListNode,
      IdentNode,
      NextNode       : STree.SyntaxNode;
      It             : STree.Iterator;
      Mode           : Modes;
      IsProtected,
      IsTask         : Boolean;
      AnnouncedType  : Dictionary.Symbol;
      TypeToUse      : Dictionary.Symbol;
      OwnVarSym      : Dictionary.Symbol;
      IdentStr       : LexTokenManager.Lex_String;
      Valid          : Boolean;

      procedure CheckOwnVarType (Node     : in     STree.SyntaxNode;
                                 PackSym  : in     Dictionary.Symbol;
                                 Scope    : in     Dictionary.Scopes;
                                 TypeSym  :    out Dictionary.Symbol)
      --# global in     CommandLineData.Content;
      --#        in     ContextManager.Ops.UnitStack;
      --#        in     LexTokenManager.State;
      --#        in out Dictionary.Dict;
      --#        in out ErrorHandler.ErrorContext;
      --#        in out SPARK_IO.FILE_SYS;
      --#        in out STree.Table;
      --# derives Dictionary.Dict           from *,
      --#                                        ContextManager.Ops.UnitStack,
      --#                                        LexTokenManager.State,
      --#                                        Node,
      --#                                        PackSym,
      --#                                        Scope,
      --#                                        STree.Table &
      --#         STree.Table               from *,
      --#                                        CommandLineData.Content,
      --#                                        Dictionary.Dict,
      --#                                        LexTokenManager.State,
      --#                                        Node,
      --#                                        Scope &
      --#         ErrorHandler.ErrorContext from *,
      --#                                        CommandLineData.Content,
      --#                                        Dictionary.Dict,
      --#                                        LexTokenManager.State,
      --#                                        Node,
      --#                                        Scope,
      --#                                        SPARK_IO.FILE_SYS,
      --#                                        STree.Table &
      --#         SPARK_IO.FILE_SYS         from *,
      --#                                        CommandLineData.Content,
      --#                                        ContextManager.Ops.UnitStack,
      --#                                        Dictionary.Dict,
      --#                                        ErrorHandler.ErrorContext,
      --#                                        LexTokenManager.State,
      --#                                        Node,
      --#                                        PackSym,
      --#                                        Scope,
      --#                                        STree.Table &
      --#         TypeSym                   from CommandLineData.Content,
      --#                                        ContextManager.Ops.UnitStack,
      --#                                        Dictionary.Dict,
      --#                                        LexTokenManager.State,
      --#                                        Node,
      --#                                        Scope,
      --#                                        STree.Table;
      is
         Sym        : Dictionary.Symbol;
         TypeString : LexTokenManager.Lex_String;
      begin
         if SyntaxNodeType (Child_Node (Child_Node (Node))) = SPSymbols.identifier then
            --simple identifier which either exists or is an announcement
            TypeString := NodeLexString (Child_Node (Child_Node (Node)));
            Sym := Dictionary.LookupItem (Name    => TypeString,
                                          Scope   => Scope,
                                          Context => Dictionary.ProofContext);
            if Sym = Dictionary.NullSymbol then
               --process type announcement
               Dictionary.AddTypeAnnouncement (Name         => TypeString,
                                               Comp_Unit    => ContextManager.Ops.CurrentUnit,
                                               Announcement => Dictionary.Location'(NodePosition (Node),
                                                                                    NodePosition (Node)),
                                               ThePackage   => PackSym,
                                               --to get
                                               TypeMark     => Sym);

            elsif not Dictionary.IsTypeMark (Sym) then
               --illegal type mark
               Sym := Dictionary.GetUnknownTypeMark;
               ErrorHandler.SemanticError (63,
                                           ErrorHandler.NoReference,
                                           NodePosition (Node),
                                           TypeString);
            else
               STree.Set_Node_Lex_String (Sym  => Sym,
                                          Node => Child_Node (Child_Node (Node)));
            end if;

         else --dotted identifier, this must already exist as type
            wf_type_mark (Node,
                          Scope,
                          Dictionary.ProofContext,
                           --to get
                          Sym);
            -- check to prevent use of abstract proof types outside their package
            if Dictionary.TypeIsAbstractProof (Sym) then
               ErrorHandler.SemanticErrorSym (148,
                                              ErrorHandler.NoReference,
                                              NodePosition (Node),
                                              Sym,
                                              Scope);
               Sym := Dictionary.GetUnknownTypeMark;
            end if;
         end if;
         TypeSym := Sym;
      end CheckOwnVarType;

      --------------------------------------------------------------------------

      procedure Validate (Node          : in     STree.SyntaxNode;
                          WffRule       : in     WffRules;
                          PackSym       : in     Dictionary.Symbol;
                          CurrentScope  : in     Dictionary.Scopes;
                          Mode          : in     Modes;
                          IsProtected   : in     Boolean;
                          IsTask        : in     Boolean;
                          Valid         :    out Boolean)
      --# global in     CommandLineData.Content;
      --#        in     Dictionary.Dict;
      --#        in     LexTokenManager.State;
      --#        in out ErrorHandler.ErrorContext;
      --#        in out SPARK_IO.FILE_SYS;
      --#        in out STree.Table;
      --# derives ErrorHandler.ErrorContext,
      --#         SPARK_IO.FILE_SYS         from CommandLineData.Content,
      --#                                        CurrentScope,
      --#                                        Dictionary.Dict,
      --#                                        ErrorHandler.ErrorContext,
      --#                                        IsProtected,
      --#                                        IsTask,
      --#                                        LexTokenManager.State,
      --#                                        Mode,
      --#                                        Node,
      --#                                        PackSym,
      --#                                        SPARK_IO.FILE_SYS,
      --#                                        STree.Table,
      --#                                        WffRule &
      --#         STree.Table,
      --#         Valid                     from CommandLineData.Content,
      --#                                        CurrentScope,
      --#                                        Dictionary.Dict,
      --#                                        IsProtected,
      --#                                        IsTask,
      --#                                        LexTokenManager.State,
      --#                                        Mode,
      --#                                        Node,
      --#                                        PackSym,
      --#                                        STree.Table,
      --#                                        WffRule;
      is
         IdentStr      : LexTokenManager.Lex_String;
         EnclosingScope : Dictionary.Scopes;
         Sym            : Dictionary.Symbol;
         ErrNum         : Natural;
      begin --Validate
         IdentStr := NodeLexString (Node);
         Valid := False;
         case WffRule is
            when UseLibrary =>
               if (IsTask or IsProtected) and then not CommandLineData.RavenscarSelected then
                  ErrorHandler.SemanticError (850,
                                              ErrorHandler.NoReference,
                                              NodePosition (Node),
                                              LexTokenManager.Null_String);
               elsif Dictionary.IsDefined (IdentStr,
                                           CurrentScope,
                                           Dictionary.ProofContext)
               then
                  ErrorHandler.SemanticError (10,
                                              ErrorHandler.NoReference,
                                              NodePosition (Node),
                                              IdentStr);
               else
                  Valid := True;
               end if;

            when UseEmbedded =>
               EnclosingScope := Dictionary.GetEnclosingScope (CurrentScope);
               Sym := Dictionary.LookupSelectedItem (Prefix   => PackSym,
                                                     Selector => IdentStr,
                                                     Scope    => EnclosingScope,
                                                     Context  => Dictionary.ProofContext);
               if (IsTask or IsProtected) and then not CommandLineData.RavenscarSelected then
                  ErrorHandler.SemanticError (850,
                                              ErrorHandler.NoReference,
                                              NodePosition (Node),
                                              LexTokenManager.Null_String);
               elsif Sym = Dictionary.NullSymbol or else
                 not Dictionary.IsRefinementConstituent
                 (Dictionary.GetRegion (EnclosingScope), Sym) then
                  ErrorHandler.SemanticError (88,
                                              ErrorHandler.NoReference,
                                              NodePosition (Node),
                                              IdentStr);
               elsif not Dictionary.IsDefined (IdentStr,
                                               CurrentScope,
                                               Dictionary.ProofContext) or else
                 (Dictionary.IsOwnVariable (Sym) and not Dictionary.OwnVariableIsAnnounced (Sym)) then
                  -- potentially ok to add, the own variable name matches a refinement
                  -- constituent of the enclosing package, we just need to check that
                  -- any modes are the same, and that the protected status is also the
                  -- same.
                  if Mode.Value = Dictionary.GetConstituentMode (Sym) then
                     Valid := not IsProtected;
                     if IsProtected then
                        -- Cannot have protected refinement constituents
                        ErrorHandler.SemanticError (859,
                                                    ErrorHandler.NoReference,
                                                    NodePosition (Node),
                                                    IdentStr);
                     else
                        STree.Set_Node_Lex_String (Sym  => Sym,
                                                   Node => Node);
                     end if;
                  else
                     if Dictionary.GetConstituentMode (Sym) = Dictionary.InMode then
                        ErrNum := 702; -- must be IN
                     elsif Dictionary.GetConstituentMode (Sym) = Dictionary.OutMode then
                        ErrNum := 703; -- must be OUT
                     else
                        ErrNum := 704; -- no mode permitted
                     end if;
                     Valid := False;
                     ErrorHandler.SemanticError (ErrNum,
                                                 ErrorHandler.NoReference,
                                                 NodePosition (Node),
                                                 IdentStr);
                  end if;
               else -- illegal redeclaration
                  ErrorHandler.SemanticError (10,
                                              ErrorHandler.NoReference,
                                              NodePosition (Node),
                                              IdentStr);
               end if;
         end case;
      end Validate;

      ------------------------------------------------------------------------

      procedure DetermineType (TypeAnnounced : in     Boolean;
                               AnnouncedType : in     Dictionary.Symbol;
                               IdentStr      : in     LexTokenManager.Lex_String;
                               Location      : in     Dictionary.Location;
                               CurrentScope  : in     Dictionary.Scopes;
                               TypeToUse     :    out Dictionary.Symbol)
      --# global in     ContextManager.Ops.UnitStack;
      --#        in out Dictionary.Dict;
      --#        in out LexTokenManager.State;
      --#        in out SPARK_IO.FILE_SYS;
      --# derives Dictionary.Dict,
      --#         SPARK_IO.FILE_SYS     from *,
      --#                                    ContextManager.Ops.UnitStack,
      --#                                    CurrentScope,
      --#                                    Dictionary.Dict,
      --#                                    IdentStr,
      --#                                    LexTokenManager.State,
      --#                                    Location,
      --#                                    TypeAnnounced &
      --#         LexTokenManager.State from *,
      --#                                    IdentStr,
      --#                                    TypeAnnounced &
      --#         TypeToUse             from AnnouncedType,
      --#                                    ContextManager.Ops.UnitStack,
      --#                                    CurrentScope,
      --#                                    Dictionary.Dict,
      --#                                    IdentStr,
      --#                                    LexTokenManager.State,
      --#                                    Location,
      --#                                    TypeAnnounced;
      is
      begin  --DetermineType
         if TypeAnnounced then
            TypeToUse := AnnouncedType;
         else --create a default proof type and return that
            Dictionary.AddDefaultAbstractProofType (OwnVarName  => IdentStr,
                                                    Comp_Unit   => ContextManager.Ops.CurrentUnit,
                                                    Declaration => Location,
                                                    Scope       => CurrentScope,
                                                    --to get
                                                    TypeSym     => TypeToUse);
         end if;
      end DetermineType;

      ------------------------------------------------------------------------

      procedure CheckModifiers (Node          : in     STree.SyntaxNode;
                                IdentNode     : in     STree.SyntaxNode;
                                AnnouncedType : in     Dictionary.Symbol;
                                Mode          :    out Modes;
                                IsProtected   :    out Boolean;
                                IsTask        :    out Boolean;
                                Valid         :    out Boolean)
      --# global in     CommandLineData.Content;
      --#        in     Dictionary.Dict;
      --#        in     LexTokenManager.State;
      --#        in     STree.Table;
      --#        in out ErrorHandler.ErrorContext;
      --#        in out SPARK_IO.FILE_SYS;
      --# derives ErrorHandler.ErrorContext,
      --#         SPARK_IO.FILE_SYS         from AnnouncedType,
      --#                                        CommandLineData.Content,
      --#                                        Dictionary.Dict,
      --#                                        ErrorHandler.ErrorContext,
      --#                                        IdentNode,
      --#                                        LexTokenManager.State,
      --#                                        Node,
      --#                                        SPARK_IO.FILE_SYS,
      --#                                        STree.Table &
      --#         IsProtected,
      --#         IsTask,
      --#         Mode                      from Node,
      --#                                        STree.Table &
      --#         Valid                     from AnnouncedType,
      --#                                        CommandLineData.Content,
      --#                                        Dictionary.Dict,
      --#                                        Node,
      --#                                        STree.Table;
      is
         ModifierNode,
         ErrNode          : STree.SyntaxNode;
         Consistent       : Boolean;
         LocalIsTask      : Boolean;
         LocalIsProtected : Boolean;

         procedure GetMode (FromNode : in     STree.SyntaxNode;
                            ErrNode  : in     STree.SyntaxNode;
                            TheMode  :    out Modes)
         --# global in     CommandLineData.Content;
         --#        in     Dictionary.Dict;
         --#        in     LexTokenManager.State;
         --#        in     STree.Table;
         --#        in out ErrorHandler.ErrorContext;
         --#        in out SPARK_IO.FILE_SYS;
         --# derives ErrorHandler.ErrorContext,
         --#         SPARK_IO.FILE_SYS         from CommandLineData.Content,
         --#                                        Dictionary.Dict,
         --#                                        ErrNode,
         --#                                        ErrorHandler.ErrorContext,
         --#                                        FromNode,
         --#                                        LexTokenManager.State,
         --#                                        SPARK_IO.FILE_SYS,
         --#                                        STree.Table &
         --#         TheMode                   from FromNode,
         --#                                        STree.Table;
         is
         begin
            TheMode := Modes'(Dictionary.DefaultMode, True);
            if FromNode /= STree.NullNode then
               -- Mode is present
               case SyntaxNodeType (FromNode) is
                  when SPSymbols.in_mode =>
                     TheMode := Modes'(Dictionary.InMode, True);

                  when SPSymbols.outmode =>
                     TheMode := Modes'(Dictionary.OutMode, True);

                  when SPSymbols.inout_mode =>
                     TheMode := Modes'(Dictionary.InOutMode, False);
                     ErrorHandler.SemanticError (700,
                                                 ErrorHandler.NoReference,
                                                 NodePosition (ErrNode),
                                                 LexTokenManager.Null_String);
                  when others =>
                     SystemErrors.FatalError (SysErr => SystemErrors.SyntaxTreeWalkError,
                                              Msg => "Invalid mode node");
               end case;
            end if;
         end GetMode;

      begin
         -- NodeType (Node) = own_variable_modifier

         Mode := Modes'(Dictionary.DefaultMode, True);
         LocalIsProtected := False; -- default answers
         LocalIsTask := False;

         ModifierNode := Child_Node (Node);
         ErrNode := Next_Sibling (Node);
         -- own_variable, we can't point at modes

         case SyntaxNodeType (ModifierNode) is

            when SPSymbols.mode =>

               GetMode (FromNode => Child_Node (ModifierNode),
                        ErrNode  => ErrNode,
                        TheMode  => Mode);

            when SPSymbols.protected_moded_modifier =>

               GetMode (FromNode => Next_Sibling (Child_Node (ModifierNode)),
                        ErrNode  => ErrNode,
                        TheMode  => Mode);

               LocalIsProtected := True;

            when SPSymbols.protected_modifier =>

               LocalIsProtected := True;

            when SPSymbols.task_modifier =>

               LocalIsTask := True;

            when others =>
               SystemErrors.FatalError (SysErr => SystemErrors.SyntaxTreeWalkError,
                                        Msg => "Invalid modifier node");
         end case;

         CheckTaskModifierConsistency
           (TheOwnVarType  => AnnouncedType,
            TheVarType     => Dictionary.NullSymbol,
            ModifierIsTask => LocalIsTask,
            ErrorNode      => IdentNode,
            Consistent     => Consistent);

         if Consistent then -- make sure we don't get two errors
            CheckProtectedModifierConsistency
              (TheType             => AnnouncedType,
               ModifierIsProtected => LocalIsProtected,
               ErrorNode           => IdentNode,
               Consistent          => Consistent);
         end if;

         Valid := Consistent;
         IsTask := LocalIsTask;
         IsProtected := LocalIsProtected;

      end CheckModifiers;

      ------------------------------------------------------------------------

      procedure CheckForIllegalMultipleInstances
        (OwnVarSym : in     Dictionary.Symbol;
         Node      : in     STree.SyntaxNode)
      --# global in     CommandLineData.Content;
      --#        in     CurrentScope;
      --#        in     Dictionary.Dict;
      --#        in     LexTokenManager.State;
      --#        in     STree.Table;
      --#        in out ErrorHandler.ErrorContext;
      --#        in out SPARK_IO.FILE_SYS;
      --# derives ErrorHandler.ErrorContext,
      --#         SPARK_IO.FILE_SYS         from CommandLineData.Content,
      --#                                        CurrentScope,
      --#                                        Dictionary.Dict,
      --#                                        ErrorHandler.ErrorContext,
      --#                                        LexTokenManager.State,
      --#                                        Node,
      --#                                        OwnVarSym,
      --#                                        SPARK_IO.FILE_SYS,
      --#                                        STree.Table;
      is
         It             : Dictionary.Iterator;
         SearchSym      : Dictionary.Symbol;
         OwnVarType     : Dictionary.Symbol;
         SearchType     : Dictionary.Symbol;
         DuplicateFound : Boolean := False;
      begin
         -- This restriction only applies to protected own variables
         --
         if Dictionary.GetOwnVariableProtected (OwnVarSym) and then
           Dictionary.OwnVariableHasType (OwnVariable => OwnVarSym,
                                          Scope       => CurrentScope) then
            OwnVarType := Dictionary.GetType (OwnVarSym);
            -- go through all the own variables
            --
            It := Dictionary.FirstOwnVariable (Dictionary.GetRegion (CurrentScope));
            while not Dictionary.IsNullIterator (It) loop
               SearchSym := Dictionary.CurrentSymbol (It);
               -- don't compare it against itself
               if SearchSym /= OwnVarSym then
                  if Dictionary.OwnVariableHasType (OwnVariable => SearchSym,
                                                    Scope       => CurrentScope) then
                     SearchType := Dictionary.GetType (SearchSym);
                     -- are the types the same?
                     if SearchType = OwnVarType then
                        -- If either has a protects property then report illegal
                        -- multiple instance of the type.
                        if Dictionary.FirstVirtualElement (OwnVarType) /=
                          Dictionary.NullIterator or
                          Dictionary.FirstVirtualElement (SearchType) /=
                          Dictionary.NullIterator then
                           ErrorHandler.SemanticErrorSym (942,
                                                          ErrorHandler.NoReference,
                                                          NodePosition (Node),
                                                          OwnVarType,
                                                          CurrentScope);
                           DuplicateFound := True;
                        end if;
                     end if;
                  end if;
               end if;
               exit when DuplicateFound;
               It := Dictionary.NextSymbol (It);
            end loop;
         end if;
      end CheckForIllegalMultipleInstances;

      ------------------------------------------------------------------------

   begin -- wf_own_variable_specification
         -- determine what checks we will need to do on each own var
      if ScopeType = InPackage then
         WffRule := UseEmbedded;
      else
         WffRule := UseLibrary;
      end if;

      -- Determine if there is a type announcement and/or properties
      --
      IdentListNode := Child_Node (Node);
      NextNode := Next_Sibling (IdentListNode);

      AnnouncedType := Dictionary.GetUnknownTypeMark;
      TypeNode := Node; -- so that errors get reported somewhere other than the null node
      TypeAnnounced := False;

      if SyntaxNodeType (NextNode) = SPSymbols.type_mark then

         TypeAnnounced := True;
         TypeNode := NextNode;

         CheckOwnVarType (TypeNode,
                          PackSym,
                          CurrentScope,
                           --to get
                          AnnouncedType);

         PropertyListNode := Next_Sibling (TypeNode);

      else
         PropertyListNode := NextNode;
      end if;

      -- loop through each own variable calling a validate routine for each
      It := FindFirstNode (NodeKind    => SPSymbols.own_variable_modifier,
                           FromRoot    => IdentListNode,
                           InDirection => STree.Down);

      while not STree.IsNull (It) loop

         NextNode := GetNode (It);

         IdentNode := Child_Node
           (Child_Node
              (Next_Sibling (NextNode))); -- dig down to identifier

         IdentStr := NodeLexString (IdentNode);

         CheckModifiers (NextNode,
                         IdentNode,
                         AnnouncedType,
                           --to get
                         Mode,
                         IsProtected,
                         IsTask,
                         Valid);

         if Valid then

            Validate (IdentNode,     -- for error reporting
                      WffRule,       -- sort of checks to make
                      PackSym,       -- needed for checks
                      CurrentScope,  -- needed for checks
                      Mode,          -- because embedded owns must have same mode as enclosing
                      IsProtected,   -- because protected and unprotected mustn't refine
                      IsTask,
                        --to get
                      Valid);

            if Valid and then
              TypeAnnounced then
               if Dictionary.IsSubtype (AnnouncedType) and then
                 Dictionary.TypeIsProtected (Dictionary.GetRootType (AnnouncedType)) then
                  -- Cannot use subtypes of protected types in own variable type announcements
                  ErrorHandler.SemanticError (948,
                                              ErrorHandler.NoReference,
                                              NodePosition (Node),
                                              IdentStr);
               else
                  if Dictionary.FirstVirtualElement (AnnouncedType) /=
                    Dictionary.NullIterator then
                     -- There is an own variable declaring a protects list for this type and
                     -- hence this is an illegal second instance.
                     --
                     Valid := False;
                     ErrorHandler.SemanticErrorSym (942,
                                                    ErrorHandler.NoReference,
                                                    NodePosition (IdentNode),
                                                    AnnouncedType,
                                                    CurrentScope);
                  else
                     Valid := True;
                  end if;
               end if;
            end if;

            if Valid then
               if IsTask then
                  wf_own_task (Node          => Node,
                               IdentStr      => IdentStr,
                               Declaration   => Dictionary.Location'(NodePosition (IdentNode),
                                                                     NodePosition (IdentNode)),
                               TypeAnnounced => TypeAnnounced,
                               AnnouncedType => AnnouncedType,
                               PackSym       => PackSym,
                               -- to get
                               TaskSym       => OwnVarSym);
               else
                  DetermineType (TypeAnnounced,   -- use announced or create a new type?
                                 AnnouncedType,
                                 IdentStr,        -- in case we need to create a type
                                 Dictionary.Location'(NodePosition (IdentNode),
                                                      NodePosition (IdentNode)), -- for any newly-created type
                                 CurrentScope,    -- for any newly-created type
                                 --to get
                                 TypeToUse);

                  if Mode.IsValid then -- expect stable
                     Dictionary.AddOwnVariable
                       (Name              => IdentStr,
                        ThePackage        => PackSym,
                        Mode              => Mode.Value,
                        IsProtected       => IsProtected,
                        IsInterruptStream => False,
                        Comp_Unit         => ContextManager.Ops.CurrentUnit,
                        Reference         => Dictionary.Location'(NodePosition (IdentNode),
                                                                  NodePosition (IdentNode)),
                        --to get
                        Variable          => OwnVarSym);

                     if IsProtected and
                       Mode.Value = Dictionary.DefaultMode then
                        -- Protected own variables are implicitly initialized and hence
                        -- effectively appear in the initializes clause.
                        -- Protected streams should not implicitly appear in the
                        -- initializes clause as we will never initialize them.
                        Dictionary.AddInitializedOwnVariable
                          (OwnVarSym,
                           Dictionary.Location'(NodePosition (IdentNode),
                                                NodePosition (IdentNode)));
                     end if;

                     Dictionary.AddOwnVariableType
                       (OwnVarSym,
                        TypeToUse,
                        Dictionary.Location'(NodePosition (TypeNode),
                                             NodePosition (TypeNode)));
                  else
                     OwnVarSym := Dictionary.NullSymbol;
                  end if;
               end if;
               if PropertyListNode /= STree.NullNode and then
                 OwnVarSym /= Dictionary.NullSymbol then  -- expect stable expression
                  wf_property_list (Node     => PropertyListNode,
                                    TypeNode => TypeNode,
                                    Scope    => CurrentScope,
                                    TheOwner => OwnVarSym);
               end if;
               if OwnVarSym /= Dictionary.NullSymbol and then
                 Dictionary.IsOwnVariable (OwnVarSym) then
                  CheckForIllegalMultipleInstances (OwnVarSym, IdentNode);
               end if;
            end if;
         end if;
         It := STree.NextNode (It);
      end loop;
   end wf_own_variable_specification;

   --------------------------------------------------------------------

   procedure CheckAllRefinementsAccountedFor
     (OwnVarClauseNode : in STree.SyntaxNode;
      PackSym          : in Dictionary.Symbol)
   --# global in     CommandLineData.Content;
   --#        in     Dictionary.Dict;
   --#        in     LexTokenManager.State;
   --#        in     STree.Table;
   --#        in out ErrorHandler.ErrorContext;
   --#        in out SPARK_IO.FILE_SYS;
   --# derives ErrorHandler.ErrorContext,
   --#         SPARK_IO.FILE_SYS         from CommandLineData.Content,
   --#                                        Dictionary.Dict,
   --#                                        ErrorHandler.ErrorContext,
   --#                                        LexTokenManager.State,
   --#                                        OwnVarClauseNode,
   --#                                        PackSym,
   --#                                        SPARK_IO.FILE_SYS,
   --#                                        STree.Table;
   is
      VarSym : Dictionary.Symbol;
      It     : Dictionary.Iterator;
      ErrPos : LexTokenManager.Token_Position;

      ----------------------------------------------------

      function FindLastInOwnVarClause (OwnVarClauseNode : STree.SyntaxNode)
                                      return LexTokenManager.Token_Position
      --# global in STree.Table;
      is
         RetNode,
         NextNode : STree.SyntaxNode;

      begin
         RetNode := Child_Node (Child_Node (OwnVarClauseNode));
         NextNode := Next_Sibling (RetNode);
         if NextNode /= STree.NullNode then
            RetNode := NextNode;
         end if;
         -- RetNode is now last own_variable_specification
         RetNode := Child_Node (Child_Node (RetNode));
         NextNode := Next_Sibling (RetNode);
         if SyntaxNodeType (NextNode) = SPSymbols.own_variable_list then
            RetNode := NextNode;
         end if;
         -- RetNode is now own variable modifier preceding last own_variable
         return NodePosition (Next_Sibling (RetNode));
      end FindLastInOwnVarClause;

      ----------------------------------------------------

   begin --CheckAllRefinementsAccountedFor
      ErrPos := FindLastInOwnVarClause (OwnVarClauseNode);
      It := Dictionary.FirstOwnVariable (PackSym);
      while not Dictionary.IsNullIterator (It) loop
         VarSym := Dictionary.CurrentSymbol (It);
         if not Dictionary.OwnVariableIsAnnounced (VarSym) then
            ErrorHandler.SemanticError (77,
                                        ErrorHandler.NoReference,
                                        ErrPos,
                                        Dictionary.GetSimpleName (VarSym));
         end if;
         It := Dictionary.NextSymbol (It);
      end loop;
   end CheckAllRefinementsAccountedFor;

   --------------------------------------------------------------------

   procedure CheckOwnerBodyNotYetDeclared (OwnVarClauseNode : in STree.SyntaxNode;
                                           PackSym          : in Dictionary.Symbol)
   --# global in     CommandLineData.Content;
   --#        in     Dictionary.Dict;
   --#        in     LexTokenManager.State;
   --#        in     STree.Table;
   --#        in out ErrorHandler.ErrorContext;
   --#        in out SPARK_IO.FILE_SYS;
   --# derives ErrorHandler.ErrorContext,
   --#         SPARK_IO.FILE_SYS         from CommandLineData.Content,
   --#                                        Dictionary.Dict,
   --#                                        ErrorHandler.ErrorContext,
   --#                                        LexTokenManager.State,
   --#                                        OwnVarClauseNode,
   --#                                        PackSym,
   --#                                        SPARK_IO.FILE_SYS,
   --#                                        STree.Table;
   is
      Owner : Dictionary.Symbol;
   begin
      Owner := Dictionary.GetPackageOwner (PackSym);
      if Owner /= Dictionary.NullSymbol and then
        Dictionary.HasBody (Owner)
      then
         ErrorHandler.SemanticError (620,
                                     ErrorHandler.NoReference,
                                     NodePosition (OwnVarClauseNode),
                                     Dictionary.GetSimpleName (Owner));
      end if;
   end CheckOwnerBodyNotYetDeclared;

   --------------------------------------------------------------------

begin --wf_own_variable_clause
   It := FindFirstNode (NodeKind    => SPSymbols.own_variable_specification,
                        FromRoot    => Node,
                        InDirection => STree.Down);

   while not STree.IsNull (It) loop
      wf_own_variable_specification (GetNode (It),
                                     PackSym,
                                     ScopeType,
                                     CurrentScope);
      It := STree.NextNode (It);
   end loop;

   if ScopeType = InPackage then
      CheckAllRefinementsAccountedFor (Node,
                                       PackSym);
   elsif ScopeType = InLibrary then
      CheckOwnerBodyNotYetDeclared (Node,
                                    PackSym);
   end if;

end wf_own;
