-- $Id: sem-compunit-wf_package_specification-checkmodes.adb 15520 2010-01-07 12:53:45Z spark $
--------------------------------------------------------------------------------
-- (C) Altran Praxis Limited
--------------------------------------------------------------------------------
--
-- The SPARK toolset is free software; you can redistribute it and/or modify it
-- under terms of the GNU General Public License as published by the Free
-- Software Foundation; either version 3, or (at your option) any later
-- version. The SPARK toolset is distributed in the hope that it will be
-- useful, but WITHOUT ANY WARRANTY; without even the implied warranty of
-- MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the GNU General
-- Public License for more details. You should have received a copy of the GNU
-- General Public License distributed with the SPARK toolset; see file
-- COPYING3. If not, go to http://www.gnu.org/licenses for a complete copy of
-- the license.
--
--==============================================================================

with LexTokenManager.Relation_Algebra.String;
with LexTokenManager.Seq_Algebra;

separate (Sem.CompUnit.wf_package_specification)

procedure CheckModes (Node    : in STree.SyntaxNode;
                      PackSym : in Dictionary.Symbol)
is

   PrivTypeIt,
   SubprogIt,
   ParamIt           : Dictionary.Iterator;
   TypeSym,
   SubprogSym,
   ParamSym          : Dictionary.Symbol;
   VisPartRepNode,
   ProcSpecNode      : STree.SyntaxNode;
   SubprogramsToMark : Boolean;
   CurrentParamList  : LexTokenManager.Seq_Algebra.Seq;
   The_Relation      : LexTokenManager.Relation_Algebra.String.Relation;

   procedure ProcessProcedure (Node      : in STree.SyntaxNode;
                               ParamList : in LexTokenManager.Seq_Algebra.Seq)
   --# global in     CommandLineData.Content;
   --#        in     Dictionary.Dict;
   --#        in     LexTokenManager.State;
   --#        in     STree.Table;
   --#        in     TheHeap;
   --#        in out ErrorHandler.ErrorContext;
   --#        in out SPARK_IO.FILE_SYS;
   --# derives ErrorHandler.ErrorContext,
   --#         SPARK_IO.FILE_SYS         from CommandLineData.Content,
   --#                                        Dictionary.Dict,
   --#                                        ErrorHandler.ErrorContext,
   --#                                        LexTokenManager.State,
   --#                                        Node,
   --#                                        ParamList,
   --#                                        SPARK_IO.FILE_SYS,
   --#                                        STree.Table,
   --#                                        TheHeap;
   is
      It          : STree.Iterator;
      IdNode      : STree.SyntaxNode;
   begin --ProcessProcedure (Node is formal_part)

      It := FindFirstNode (NodeKind    => SPSymbols.identifier,
                           FromRoot    => Node,
                           InDirection => STree.Down);

      while not STree.IsNull (It) loop
         IdNode := GetNode (It);
         if LexTokenManager.Seq_Algebra.Is_Member (The_Heap    => TheHeap,
                                                   S           => ParamList,
                                                   Given_Value => NodeLexString (IdNode)) then
            ErrorHandler.SemanticError (338,
                                        ErrorHandler.NoReference,
                                        NodePosition (IdNode),
                                        NodeLexString (IdNode));
         end if;
         It := STree.NextNode (It);
      end loop;
   end ProcessProcedure;

begin --CheckModes
   LexTokenManager.Relation_Algebra.String.Create_Relation (The_Heap => TheHeap,
                                                            R        => The_Relation);
   SubprogramsToMark := False;
   PrivTypeIt := Dictionary.FirstPrivateType (PackSym);
   while not Dictionary.IsNullIterator (PrivTypeIt) loop
      TypeSym := Dictionary.CurrentSymbol (PrivTypeIt);
      if Dictionary.IsDeclared (TypeSym) and then
         Dictionary.TypeIsScalar (TypeSym)
      then --we have a scalar private type which may affect subprog params
         SubprogIt := Dictionary.FirstVisibleSubprogram (PackSym);
         while not Dictionary.IsNullIterator (SubprogIt) loop
            SubprogSym := Dictionary.CurrentSymbol (SubprogIt);

            ParamIt := Dictionary.FirstSubprogramParameter (SubprogSym);
            while not Dictionary.IsNullIterator (ParamIt) loop
               ParamSym := Dictionary.CurrentSymbol (ParamIt);
               if Dictionary.GetType (ParamSym) = TypeSym and then
                  Dictionary.GetSubprogramParameterMode (ParamSym) =
                  Dictionary.InOutMode and then
                  not Dictionary.IsImport (Dictionary.IsAbstract,
                                           SubprogSym,
                                           ParamSym)
               then
                  SubprogramsToMark := True;
                  LexTokenManager.Relation_Algebra.String.Insert_Pair
                    (The_Heap => TheHeap,
                     R        => The_Relation,
                     I        => Dictionary.GetSimpleName (SubprogSym),
                     J        => Dictionary.GetSimpleName (ParamSym));
               end if;
               ParamIt := Dictionary.NextSymbol (ParamIt);
            end loop;

            SubprogIt := Dictionary.NextSymbol (SubprogIt);
         end loop;
      end if;
      PrivTypeIt := Dictionary.NextSymbol (PrivTypeIt);
   end loop;

   -- At this point we have created in SubprogList a data structure listing
   -- all the procedures made illegal by the private types' full declarations
   -- and for each of them a list of affected parameters.  We now walk the
   -- syntax tree marking each parameter occurrence found.
   if SubprogramsToMark then
      VisPartRepNode := Child_Node (Node);
      while VisPartRepNode /= STree.NullNode
      loop
         ProcSpecNode := Child_Node (Next_Sibling (VisPartRepNode));
         if SyntaxNodeType (ProcSpecNode) =
            SPSymbols.procedure_specification
         then
            LexTokenManager.Relation_Algebra.String.Row_Extraction
              (The_Heap    => TheHeap,
               R           => The_Relation,
               Given_Index => NodeLexString (Child_Node (ProcSpecNode)),
               S           => CurrentParamList);
            if not LexTokenManager.Seq_Algebra.Is_Null_Seq (S => CurrentParamList) then
               ProcessProcedure (Node      => Next_Sibling (Child_Node (ProcSpecNode)),
                                 ParamList => CurrentParamList);
            end if;
         end if;
         VisPartRepNode := Child_Node (VisPartRepNode);
      end loop;
   end if;
end CheckModes;
