-- $Id: sem-compunit-wf_identifier.adb 16669 2010-04-01 11:26:15Z spark $
--------------------------------------------------------------------------------
-- (C) Altran Praxis Limited
--------------------------------------------------------------------------------
--
-- The SPARK toolset is free software; you can redistribute it and/or modify it
-- under terms of the GNU General Public License as published by the Free
-- Software Foundation; either version 3, or (at your option) any later
-- version. The SPARK toolset is distributed in the hope that it will be
-- useful, but WITHOUT ANY WARRANTY; without even the implied warranty of
-- MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the GNU General
-- Public License for more details. You should have received a copy of the GNU
-- General Public License distributed with the SPARK toolset; see file
-- COPYING3. If not, go to http://www.gnu.org/licenses for a complete copy of
-- the license.
--
--==============================================================================

with SLI;

separate (Sem.CompUnit)

procedure wf_identifier (Node         : in     STree.SyntaxNode;
                         Scope        : in     Dictionary.Scopes;
                         EStack       : in out ExpStack.ExpStackType;
                         RefVar       : in     SeqAlgebra.Seq;
                         Context      : in     Tilde_Context;
                         IsAnnotation : in     Boolean)
is
   Sym : Dictionary.Symbol;
begin -- wf_identifier
   if IsAnnotation then
      Sym := Dictionary.LookupItem (Name    => NodeLexString (Node),
                                    Scope   => Scope,
                                    Context => Dictionary.ProofContext);
      if Sym /= Dictionary.NullSymbol and then
        ErrorHandler.Generate_SLI then
         SLI.Generate_Xref_Symbol (Comp_Unit      => ContextManager.Ops.CurrentUnit,
                                   Parse_Tree     => Node,
                                   Symbol         => Sym,
                                   Is_Declaration => False);
      end if;
   else
      Sym := Dictionary.LookupItem (Name    => NodeLexString (Node),
                                    Scope   => Scope,
                                    Context => Dictionary.ProgramContext);
   end if;
   if Sym /= Dictionary.NullSymbol then
      STree.Set_Node_Lex_String (Sym  => Sym,
                                 Node => Node);
   end if;
   if Dictionary.IsPackage (Sym) then
      ExpStack.Push (ExpRecord'(TypeSymbol            => Dictionary.GetUnknownTypeMark,
                                OtherSymbol           => Sym,
                                StreamSymbol          => Dictionary.NullSymbol,
                                TaggedParameterSymbol => Dictionary.NullSymbol,
                                VariableSymbol        => Dictionary.NullSymbol,
                                ParamCount            => 0,
                                ParamList             => Lists.Null_List,
                                Sort                  => IsPackage,
                                ArgListFound          => False,
                                IsAVariable           => False,
                                IsAnEntireVariable    => False,
                                ErrorsInExpression    => False,
                                HasOperators          => False,
                                IsStatic              => False,
                                IsConstant            => False,
                                IsARange              => False,
                                Value                 => Maths.NoValue,
                                RangeRHS              => Maths.NoValue),
                     EStack);
   else
      StackIdentifier (Sym            => Sym,
                       IdStr          => NodeLexString (Node),
                       Node           => Node,
                       Prefix         => Dictionary.NullSymbol,
                       Scope          => Scope,
                       EStack         => EStack,
                       RefVar         => RefVar,
                       Dotted         => False,
                       Context        => Context,
                       IsAnnotation   => IsAnnotation);
   end if;

   if IsAnnotation and then
     Next_Sibling (Node) /= STree.NullNode then -- identifier may have ~ or % after it
      case SyntaxNodeType (Next_Sibling (Node)) is
         when SPSymbols.tilde =>
            wf_tilde (Next_Sibling (Node),
                      Scope,
                      EStack,
                      Context);
         when SPSymbols.percent =>
            wf_percent (Next_Sibling (Node),
                        Scope,
                        EStack);
         when others =>
            null; -- unreachable unless grammar of annotation_identifier altered
      end case;
   end if;
end wf_identifier;
