-- $Id: sem-compunit-wf_function_constraint.adb 15674 2010-01-20 16:17:20Z spark $
--------------------------------------------------------------------------------
-- (C) Altran Praxis Limited
--------------------------------------------------------------------------------
--
-- The SPARK toolset is free software; you can redistribute it and/or modify it
-- under terms of the GNU General Public License as published by the Free
-- Software Foundation; either version 3, or (at your option) any later
-- version. The SPARK toolset is distributed in the hope that it will be
-- useful, but WITHOUT ANY WARRANTY; without even the implied warranty of
-- MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the GNU General
-- Public License for more details. You should have received a copy of the GNU
-- General Public License distributed with the SPARK toolset; see file
-- COPYING3. If not, go to http://www.gnu.org/licenses for a complete copy of
-- the license.
--
--==============================================================================

separate (Sem.CompUnit)
procedure wf_function_constraint (Node      : in STree.SyntaxNode;
                                  Scope     : in Dictionary.Scopes;
                                  FirstSeen : in Boolean)
is
   ConNode                : STree.SyntaxNode;
   ErrorsFound            : Boolean := False;
   ErrorsFoundInPredicate : Boolean;
   -- look up table: if FirstSeen then we are dealing with Abstract spec else Refined
   type WhichAbstractions is array (Boolean) of Dictionary.Abstractions;
   WhichAbstraction       : constant WhichAbstractions :=
      WhichAbstractions'(False => Dictionary.IsRefined,
                         True  => Dictionary.IsAbstract);

   ---------------------------------------------

   procedure wf_return_expression (Node  : in STree.SyntaxNode;
                                   Scope : in Dictionary.Scopes)
   --# global in     CommandLineData.Content;
   --#        in     ContextManager.Ops.FileHeap;
   --#        in     ContextManager.Ops.UnitHeap;
   --#        in     ContextManager.Ops.UnitStack;
   --#        in     FirstSeen;
   --#        in out AggregateStack.State;
   --#        in out Dictionary.Dict;
   --#        in out ErrorHandler.ErrorContext;
   --#        in out ErrorsFound;
   --#        in out GlobalComponentData;
   --#        in out LexTokenManager.State;
   --#        in out SLI.State;
   --#        in out SPARK_IO.FILE_SYS;
   --#        in out Statistics.TableUsage;
   --#        in out STree.Table;
   --#        in out TheHeap;
   --# derives AggregateStack.State,
   --#         Dictionary.Dict,
   --#         ErrorsFound,
   --#         GlobalComponentData,
   --#         LexTokenManager.State,
   --#         Statistics.TableUsage,
   --#         STree.Table,
   --#         TheHeap                   from *,
   --#                                        CommandLineData.Content,
   --#                                        ContextManager.Ops.UnitStack,
   --#                                        Dictionary.Dict,
   --#                                        FirstSeen,
   --#                                        GlobalComponentData,
   --#                                        LexTokenManager.State,
   --#                                        Node,
   --#                                        Scope,
   --#                                        STree.Table,
   --#                                        TheHeap &
   --#         ErrorHandler.ErrorContext,
   --#         SLI.State,
   --#         SPARK_IO.FILE_SYS         from CommandLineData.Content,
   --#                                        ContextManager.Ops.FileHeap,
   --#                                        ContextManager.Ops.UnitHeap,
   --#                                        ContextManager.Ops.UnitStack,
   --#                                        Dictionary.Dict,
   --#                                        ErrorHandler.ErrorContext,
   --#                                        FirstSeen,
   --#                                        GlobalComponentData,
   --#                                        LexTokenManager.State,
   --#                                        Node,
   --#                                        Scope,
   --#                                        SLI.State,
   --#                                        SPARK_IO.File_Sys,
   --#                                        STree.Table,
   --#                                        TheHeap;
   is
      RetExp                 : ExpRecord;
      ImplicitNode           : STree.SyntaxNode;
      ImplicitStr            : LexTokenManager.Lex_String;
      ImplicitVar            : Dictionary.Symbol;
      ReturnType             : Dictionary.Symbol;
      ErrorsFoundInPredicate : Boolean;
   begin
      --node is node below return_expression
      if SyntaxNodeType (Node) =
         SPSymbols.annotation_expression
      then
         ReturnType := Dictionary.GetType (Dictionary.GetRegion (Scope));
         WalkAnnotationExpression
           (ExpNode         => Node,
            Scope           => Scope,
            TypeContext     => ReturnType,
            Context         => FunctionReturn, -- ~ may be allowed for external variables
            Result          => RetExp,
            ComponentData   => GlobalComponentData);
         ErrorsFound := ErrorsFound or (RetExp.ErrorsInExpression);

         AssignmentCheck (Position   => NodePosition (Node),
                          Scope      => Scope,
                          TargetType => ReturnType,
                          ExpResult  => RetExp);
         ErrorsFound := ErrorsFound or (RetExp.ErrorsInExpression);

      else --must be simple_name of implicit return expression
         ImplicitNode := Child_Node (Node);
         ImplicitStr := NodeLexString (ImplicitNode);
         if Dictionary.IsDefined (ImplicitStr,
                                  Scope,
                                  Dictionary.ProofContext)
         then
            ErrorsFound := True;
            ErrorHandler.SemanticError (10,
                                        ErrorHandler.NoReference,
                                        NodePosition (Node),
                                        ImplicitStr);
         else --valid implicit return variable so add it and then wf predicate
            Dictionary.AddImplicitReturnVariable (Abstraction => WhichAbstraction (FirstSeen),
                                                  Comp_Unit   => ContextManager.Ops.CurrentUnit,
                                                  Declaration => Dictionary.Location'(NodePosition (ImplicitNode),
                                                                                      NodePosition (ImplicitNode)),
                                                  Name        => ImplicitStr,
                                                  TheFunction => Dictionary.GetRegion (Scope),
                                                  --to get
                                                  Variable    => ImplicitVar);
            wf_predicate (Node           => Next_Sibling (Node),
                          Scope          => Dictionary.LocalScope (ImplicitVar),
                          Context        => FunctionReturn, -- ~ may be allowed for external variables
                          ErrorsFound    => ErrorsFoundInPredicate);
            ErrorsFound := ErrorsFound or ErrorsFoundInPredicate;
         end if;
      end if;
   end wf_return_expression;

   ---------------------------------------------

begin --wf_function_constraint
      --assume node is function_constraint
   ConNode := Child_Node (Node);
   if ConNode /= STree.NullNode then
      if SyntaxNodeType (ConNode) =
         SPSymbols.precondition
      then
         Dictionary.AddPrecondition (WhichAbstraction (FirstSeen),
                                     Dictionary.GetRegion (Scope),
                                     STree.NodeToRef (Child_Node (ConNode)),
                                     Dictionary.Location'(NodePosition (ConNode),
                                                          NodePosition (ConNode)));
         wf_predicate (Node           => Child_Node (ConNode),
                       Scope          => Scope,
                       Context        => Precondition,
                       ErrorsFound    => ErrorsFoundInPredicate);
         ErrorsFound := ErrorsFound or ErrorsFoundInPredicate;
         ConNode := Next_Sibling (ConNode);
      end if;

      if SyntaxNodeType (ConNode) =
         SPSymbols.return_expression
      then
         Dictionary.AddPostcondition (WhichAbstraction (FirstSeen),
                                      Dictionary.GetRegion (Scope),
                                      STree.NodeToRef
                                      (Child_Node (ConNode)),
                                      Dictionary.Location'(NodePosition (ConNode),
                                                           NodePosition (ConNode)));
         wf_return_expression (Node          => Child_Node (ConNode),
                               Scope         => Scope);
      end if;
      if ErrorsFound then
         Dictionary.SetSubprogramSignatureNotWellformed (WhichAbstraction (FirstSeen),
                                                         Dictionary.GetRegion (Scope));
      end if;
   end if;
end wf_function_constraint;
