-- $Id: sem-compunit-wf_function_annotation.adb 11354 2008-10-06 17:02:56Z Bill Ellis $
--------------------------------------------------------------------------------
-- (C) Altran Praxis Limited
--------------------------------------------------------------------------------
--
-- The SPARK toolset is free software; you can redistribute it and/or modify it
-- under terms of the GNU General Public License as published by the Free
-- Software Foundation; either version 3, or (at your option) any later
-- version. The SPARK toolset is distributed in the hope that it will be
-- useful, but WITHOUT ANY WARRANTY; without even the implied warranty of
-- MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the GNU General
-- Public License for more details. You should have received a copy of the GNU
-- General Public License distributed with the SPARK toolset; see file
-- COPYING3. If not, go to http://www.gnu.org/licenses for a complete copy of
-- the license.
--
--==============================================================================


separate (Sem.CompUnit)

procedure wf_function_annotation (Node         : in STree.SyntaxNode;
                                  CurrentScope : in Dictionary.Scopes;
                                  SubprogSym   : in Dictionary.Symbol;
                                  FirstSeen    : in Boolean)
is
   NextNode   : STree.SyntaxNode;
   NodeType   : SPSymbols.SPSymbol;
   GlobalHasErrors : Boolean;

   -- look up table: if FirstSeen then we are dealing with Abstract spec else Refined
   type WhichAbstractions is array (Boolean) of Dictionary.Abstractions;
   WhichAbstraction       : constant WhichAbstractions :=
      WhichAbstractions'(False => Dictionary.IsRefined,
                         True  => Dictionary.IsAbstract);
begin
   -- ASSUME Node = function_annotation

   NextNode := Child_Node (Node);
   NodeType := SyntaxNodeType (NextNode);

   if NodeType = SPSymbols.moded_global_definition then
      wf_global_definition (NextNode,
                            CurrentScope,
                            SubprogSym,
                            FirstSeen,
                            GlobalHasErrors);
      if GlobalHasErrors then
         Dictionary.SetSubprogramSignatureNotWellformed (WhichAbstraction (FirstSeen),
                                                         SubprogSym);
      end if;
   end if;
end wf_function_annotation;
