-- $Id: sem-compunit-wf_full_type_declaration.adb 16567 2010-03-25 16:09:40Z spark $
--------------------------------------------------------------------------------
-- (C) Altran Praxis Limited
--------------------------------------------------------------------------------
--
-- The SPARK toolset is free software; you can redistribute it and/or modify it
-- under terms of the GNU General Public License as published by the Free
-- Software Foundation; either version 3, or (at your option) any later
-- version. The SPARK toolset is distributed in the hope that it will be
-- useful, but WITHOUT ANY WARRANTY; without even the implied warranty of
-- MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the GNU General
-- Public License for more details. You should have received a copy of the GNU
-- General Public License distributed with the SPARK toolset; see file
-- COPYING3. If not, go to http://www.gnu.org/licenses for a complete copy of
-- the license.
--
--==============================================================================


separate (Sem.CompUnit)

procedure wf_full_type_declaration (Node  : in STree.SyntaxNode;
                                    Scope : in Dictionary.Scopes)
is
   IdentNode : STree.SyntaxNode;
   IdentStr  : LexTokenManager.Lex_String;
   Sym       : Dictionary.Symbol;

   TypeDeclaredAsLimited : Boolean;
   TypeDeclaredAsTagged  : Boolean;
   Error_Found           : Boolean;

   -------------------------------

   function IsPrivateTypeResolution (Sym   : Dictionary.Symbol;
                                     Scope : Dictionary.Scopes) return Boolean
   --# global in Dictionary.Dict;
   is
   begin
      return (not Dictionary.IsDeclared (Sym) and then
              not Dictionary.IsVisibleScope (Scope) and then
              Dictionary.IsType (Sym) and then
              Dictionary.TypeIsPrivate (Sym) and then
              (Dictionary.GetRegion (Scope) =
               Dictionary.GetRegion (Dictionary.GetScope (Sym))));
   end IsPrivateTypeResolution;

   -------------------------------

   procedure EmptyTypeCheck (DecLoc : in     LexTokenManager.Token_Position;
                             Lower,
                             Upper  : in out LexTokenManager.Lex_String)
   --# global in     CommandLineData.Content;
   --#        in     Dictionary.Dict;
   --#        in     LexTokenManager.State;
   --#        in out ErrorHandler.ErrorContext;
   --#        in out SPARK_IO.File_Sys;
   --# derives ErrorHandler.ErrorContext,
   --#         SPARK_IO.File_Sys         from CommandLineData.Content,
   --#                                        DecLoc,
   --#                                        Dictionary.Dict,
   --#                                        ErrorHandler.ErrorContext,
   --#                                        LexTokenManager.State,
   --#                                        Lower,
   --#                                        SPARK_IO.File_Sys,
   --#                                        Upper &
   --#         Lower,
   --#         Upper                     from LexTokenManager.State,
   --#                                        Lower,
   --#                                        Upper;
   is
      Unused        : Maths.ErrorCode;
      MathsResult   : Maths.Value;
      RangeIsEmpty  : Boolean;
   begin
      if LexTokenManager.Lex_String_Case_Insensitive_Compare (Lex_Str1 => Lower,
                                                              Lex_Str2 => LexTokenManager.Null_String) /= LexTokenManager.Str_Eq and then
        LexTokenManager.Lex_String_Case_Insensitive_Compare (Lex_Str1 => Upper,
                                                             Lex_Str2 => LexTokenManager.Null_String) /= LexTokenManager.Str_Eq then
         --# accept Flow, 10, Unused, "Expected ineffective assignment";
         Maths.Lesser (Maths.ValueRep (Upper),
                       Maths.ValueRep (Lower),
                        --to get
                       MathsResult,
                       Unused);  --not used because it can only be ok or type mismatch
         Maths.ValueToBool (MathsResult,
                              --to get
                            RangeIsEmpty,
                            Unused);
         if RangeIsEmpty then
            Lower := LexTokenManager.Null_String;
            Upper := LexTokenManager.Null_String;
            ErrorHandler.SemanticError (416,  -- type may not have an empty range
                                        ErrorHandler.NoReference,
                                        DecLoc,
                                        LexTokenManager.Null_String);
         end if;
      end if;
      --# accept Flow, 33, Unused, "Expected to be neither referenced nor exported";
   end EmptyTypeCheck;

   -------------------------------

   procedure wf_integer (Node       : in STree.SyntaxNode;
                         Scope      : in Dictionary.Scopes;
                         Ident_Node : in STree.SyntaxNode;
                         DecLoc     : in LexTokenManager.Token_Position)
   --# global in     CommandLineData.Content;
   --#        in     ContextManager.Ops.FileHeap;
   --#        in     ContextManager.Ops.UnitHeap;
   --#        in     ContextManager.Ops.UnitStack;
   --#        in out Dictionary.Dict;
   --#        in out ErrorHandler.ErrorContext;
   --#        in out LexTokenManager.State;
   --#        in out SLI.State;
   --#        in out SPARK_IO.File_Sys;
   --#        in out Statistics.TableUsage;
   --#        in out STree.Table;
   --#        in out TheHeap;
   --#           out AggregateStack.State;
   --# derives AggregateStack.State      from CommandLineData.Content,
   --#                                        ContextManager.Ops.UnitStack,
   --#                                        Dictionary.Dict,
   --#                                        LexTokenManager.State,
   --#                                        Node,
   --#                                        Scope,
   --#                                        STree.Table,
   --#                                        TheHeap &
   --#         Dictionary.Dict           from *,
   --#                                        CommandLineData.Content,
   --#                                        ContextManager.Ops.UnitStack,
   --#                                        DecLoc,
   --#                                        Ident_Node,
   --#                                        LexTokenManager.State,
   --#                                        Node,
   --#                                        Scope,
   --#                                        STree.Table,
   --#                                        TheHeap &
   --#         ErrorHandler.ErrorContext from *,
   --#                                        CommandLineData.Content,
   --#                                        ContextManager.Ops.FileHeap,
   --#                                        ContextManager.Ops.UnitHeap,
   --#                                        ContextManager.Ops.UnitStack,
   --#                                        DecLoc,
   --#                                        Dictionary.Dict,
   --#                                        LexTokenManager.State,
   --#                                        Node,
   --#                                        Scope,
   --#                                        SLI.State,
   --#                                        SPARK_IO.File_Sys,
   --#                                        STree.Table,
   --#                                        TheHeap &
   --#         LexTokenManager.State,
   --#         Statistics.TableUsage,
   --#         STree.Table,
   --#         TheHeap                   from *,
   --#                                        CommandLineData.Content,
   --#                                        ContextManager.Ops.UnitStack,
   --#                                        Dictionary.Dict,
   --#                                        LexTokenManager.State,
   --#                                        Node,
   --#                                        Scope,
   --#                                        STree.Table,
   --#                                        TheHeap &
   --#         SLI.State,
   --#         SPARK_IO.File_Sys         from CommandLineData.Content,
   --#                                        ContextManager.Ops.FileHeap,
   --#                                        ContextManager.Ops.UnitHeap,
   --#                                        ContextManager.Ops.UnitStack,
   --#                                        DecLoc,
   --#                                        Dictionary.Dict,
   --#                                        ErrorHandler.ErrorContext,
   --#                                        Ident_Node,
   --#                                        LexTokenManager.State,
   --#                                        Node,
   --#                                        Scope,
   --#                                        SLI.State,
   --#                                        SPARK_IO.File_Sys,
   --#                                        STree.Table,
   --#                                        TheHeap;
      is separate;

   -------------------------------

   procedure wf_modular
     (Node       : in STree.SyntaxNode;
      Scope      : in Dictionary.Scopes;
      Ident_Node : in STree.SyntaxNode;
      DecLoc     : in LexTokenManager.Token_Position)
   --# global in     CommandLineData.Content;
   --#        in     ContextManager.Ops.FileHeap;
   --#        in     ContextManager.Ops.UnitHeap;
   --#        in     ContextManager.Ops.UnitStack;
   --#        in out AggregateStack.State;
   --#        in out Dictionary.Dict;
   --#        in out ErrorHandler.ErrorContext;
   --#        in out LexTokenManager.State;
   --#        in out SLI.State;
   --#        in out SPARK_IO.File_Sys;
   --#        in out Statistics.TableUsage;
   --#        in out STree.Table;
   --#        in out TheHeap;
   --# derives AggregateStack.State,
   --#         LexTokenManager.State,
   --#         Statistics.TableUsage,
   --#         STree.Table,
   --#         TheHeap                   from *,
   --#                                        CommandLineData.Content,
   --#                                        ContextManager.Ops.UnitStack,
   --#                                        Dictionary.Dict,
   --#                                        LexTokenManager.State,
   --#                                        Node,
   --#                                        Scope,
   --#                                        STree.Table,
   --#                                        TheHeap &
   --#         ErrorHandler.ErrorContext from *,
   --#                                        CommandLineData.Content,
   --#                                        ContextManager.Ops.FileHeap,
   --#                                        ContextManager.Ops.UnitHeap,
   --#                                        ContextManager.Ops.UnitStack,
   --#                                        Dictionary.Dict,
   --#                                        LexTokenManager.State,
   --#                                        Node,
   --#                                        Scope,
   --#                                        SLI.State,
   --#                                        SPARK_IO.File_Sys,
   --#                                        STree.Table,
   --#                                        TheHeap &
   --#         SLI.State,
   --#         SPARK_IO.File_Sys         from CommandLineData.Content,
   --#                                        ContextManager.Ops.FileHeap,
   --#                                        ContextManager.Ops.UnitHeap,
   --#                                        ContextManager.Ops.UnitStack,
   --#                                        DecLoc,
   --#                                        Dictionary.Dict,
   --#                                        ErrorHandler.ErrorContext,
   --#                                        Ident_Node,
   --#                                        LexTokenManager.State,
   --#                                        Node,
   --#                                        Scope,
   --#                                        SLI.State,
   --#                                        SPARK_IO.File_Sys,
   --#                                        STree.Table,
   --#                                        TheHeap &
   --#         Dictionary.Dict           from *,
   --#                                        CommandLineData.Content,
   --#                                        ContextManager.Ops.UnitStack,
   --#                                        DecLoc,
   --#                                        Ident_Node,
   --#                                        LexTokenManager.State,
   --#                                        Node,
   --#                                        Scope,
   --#                                        STree.Table,
   --#                                        TheHeap;
      is separate;

   -------------------------------

   procedure wf_enum (Node       : in STree.SyntaxNode;
                      Scope      : in Dictionary.Scopes;
                      Ident_Node : in STree.SyntaxNode;
                      DecLoc     : in LexTokenManager.Token_Position)
   --# global in     CommandLineData.Content;
   --#        in     ContextManager.Ops.FileHeap;
   --#        in     ContextManager.Ops.UnitHeap;
   --#        in     ContextManager.Ops.UnitStack;
   --#        in     STree.Table;
   --#        in out Dictionary.Dict;
   --#        in out ErrorHandler.ErrorContext;
   --#        in out LexTokenManager.State;
   --#        in out SLI.State;
   --#        in out SPARK_IO.File_Sys;
   --# derives SLI.State                 from *,
   --#                                        CommandLineData.Content,
   --#                                        ContextManager.Ops.UnitHeap,
   --#                                        ContextManager.Ops.UnitStack,
   --#                                        DecLoc,
   --#                                        Dictionary.Dict,
   --#                                        ErrorHandler.ErrorContext,
   --#                                        Ident_Node,
   --#                                        LexTokenManager.State,
   --#                                        Scope,
   --#                                        STree.Table &
   --#         Dictionary.Dict,
   --#         LexTokenManager.State     from ContextManager.Ops.UnitStack,
   --#                                        DecLoc,
   --#                                        Dictionary.Dict,
   --#                                        Ident_Node,
   --#                                        LexTokenManager.State,
   --#                                        Node,
   --#                                        Scope,
   --#                                        STree.Table &
   --#         ErrorHandler.ErrorContext,
   --#         SPARK_IO.File_Sys         from CommandLineData.Content,
   --#                                        ContextManager.Ops.FileHeap,
   --#                                        ContextManager.Ops.UnitHeap,
   --#                                        ContextManager.Ops.UnitStack,
   --#                                        DecLoc,
   --#                                        Dictionary.Dict,
   --#                                        ErrorHandler.ErrorContext,
   --#                                        Ident_Node,
   --#                                        LexTokenManager.State,
   --#                                        Node,
   --#                                        Scope,
   --#                                        SLI.State,
   --#                                        SPARK_IO.File_Sys,
   --#                                        STree.Table;
      is separate;

   -------------------------------

   procedure wf_record (Node                     : in STree.SyntaxNode;
                        Scope                    : in Dictionary.Scopes;
                        Ident_Node               : in STree.SyntaxNode;
                        DecLoc                   : in LexTokenManager.Token_Position;
                        Extends                  : in Dictionary.Symbol;
                        PrivateTypeBeingResolved : in Dictionary.Symbol)
   --# global in     CommandLineData.Content;
   --#        in     ContextManager.Ops.FileHeap;
   --#        in     ContextManager.Ops.UnitHeap;
   --#        in     ContextManager.Ops.UnitStack;
   --#        in     LexTokenManager.State;
   --#        in out Dictionary.Dict;
   --#        in out ErrorHandler.ErrorContext;
   --#        in out SLI.State;
   --#        in out SPARK_IO.File_Sys;
   --#        in out STree.Table;
   --# derives SLI.State                 from *,
   --#                                        CommandLineData.Content,
   --#                                        ContextManager.Ops.UnitHeap,
   --#                                        ContextManager.Ops.UnitStack,
   --#                                        DecLoc,
   --#                                        Dictionary.Dict,
   --#                                        ErrorHandler.ErrorContext,
   --#                                        Extends,
   --#                                        Ident_Node,
   --#                                        LexTokenManager.State,
   --#                                        Node,
   --#                                        PrivateTypeBeingResolved,
   --#                                        Scope,
   --#                                        SPARK_IO.File_Sys,
   --#                                        STree.Table &
   --#         Dictionary.Dict,
   --#         STree.Table               from CommandLineData.Content,
   --#                                        ContextManager.Ops.UnitStack,
   --#                                        DecLoc,
   --#                                        Dictionary.Dict,
   --#                                        Extends,
   --#                                        Ident_Node,
   --#                                        LexTokenManager.State,
   --#                                        Node,
   --#                                        PrivateTypeBeingResolved,
   --#                                        Scope,
   --#                                        STree.Table &
   --#         ErrorHandler.ErrorContext,
   --#         SPARK_IO.File_Sys         from CommandLineData.Content,
   --#                                        ContextManager.Ops.FileHeap,
   --#                                        ContextManager.Ops.UnitHeap,
   --#                                        ContextManager.Ops.UnitStack,
   --#                                        DecLoc,
   --#                                        Dictionary.Dict,
   --#                                        ErrorHandler.ErrorContext,
   --#                                        Extends,
   --#                                        Ident_Node,
   --#                                        LexTokenManager.State,
   --#                                        Node,
   --#                                        PrivateTypeBeingResolved,
   --#                                        Scope,
   --#                                        SLI.State,
   --#                                        SPARK_IO.File_Sys,
   --#                                        STree.Table;
      is separate;

   -------------------------------

   procedure wf_real (Node       : in STree.SyntaxNode;
                      Scope      : in Dictionary.Scopes;
                      Ident_Node : in STree.SyntaxNode;
                      DecLoc     : in LexTokenManager.Token_Position)
   --# global in     CommandLineData.Content;
   --#        in     ContextManager.Ops.FileHeap;
   --#        in     ContextManager.Ops.UnitHeap;
   --#        in     ContextManager.Ops.UnitStack;
   --#        in out Dictionary.Dict;
   --#        in out ErrorHandler.ErrorContext;
   --#        in out LexTokenManager.State;
   --#        in out SLI.State;
   --#        in out SPARK_IO.File_Sys;
   --#        in out Statistics.TableUsage;
   --#        in out STree.Table;
   --#        in out TheHeap;
   --#           out AggregateStack.State;
   --# derives AggregateStack.State      from CommandLineData.Content,
   --#                                        ContextManager.Ops.UnitStack,
   --#                                        Dictionary.Dict,
   --#                                        LexTokenManager.State,
   --#                                        Node,
   --#                                        Scope,
   --#                                        STree.Table,
   --#                                        TheHeap &
   --#         Dictionary.Dict           from *,
   --#                                        CommandLineData.Content,
   --#                                        ContextManager.Ops.UnitStack,
   --#                                        DecLoc,
   --#                                        Ident_Node,
   --#                                        LexTokenManager.State,
   --#                                        Node,
   --#                                        Scope,
   --#                                        STree.Table,
   --#                                        TheHeap &
   --#         ErrorHandler.ErrorContext from CommandLineData.Content,
   --#                                        ContextManager.Ops.FileHeap,
   --#                                        ContextManager.Ops.UnitHeap,
   --#                                        ContextManager.Ops.UnitStack,
   --#                                        DecLoc,
   --#                                        Dictionary.Dict,
   --#                                        ErrorHandler.ErrorContext,
   --#                                        LexTokenManager.State,
   --#                                        Node,
   --#                                        Scope,
   --#                                        SLI.State,
   --#                                        SPARK_IO.File_Sys,
   --#                                        STree.Table,
   --#                                        TheHeap &
   --#         SLI.State,
   --#         SPARK_IO.File_Sys         from CommandLineData.Content,
   --#                                        ContextManager.Ops.FileHeap,
   --#                                        ContextManager.Ops.UnitHeap,
   --#                                        ContextManager.Ops.UnitStack,
   --#                                        DecLoc,
   --#                                        Dictionary.Dict,
   --#                                        ErrorHandler.ErrorContext,
   --#                                        Ident_Node,
   --#                                        LexTokenManager.State,
   --#                                        Node,
   --#                                        Scope,
   --#                                        SLI.State,
   --#                                        SPARK_IO.File_Sys,
   --#                                        STree.Table,
   --#                                        TheHeap &
   --#         LexTokenManager.State,
   --#         Statistics.TableUsage,
   --#         STree.Table,
   --#         TheHeap                   from *,
   --#                                        CommandLineData.Content,
   --#                                        ContextManager.Ops.UnitStack,
   --#                                        Dictionary.Dict,
   --#                                        LexTokenManager.State,
   --#                                        Node,
   --#                                        Scope,
   --#                                        STree.Table,
   --#                                        TheHeap;
      is separate;

   -------------------------------

   procedure wf_type_extension (Node                     : in STree.SyntaxNode;
                                Scope                    : in Dictionary.Scopes;
                                Ident_Node               : in STree.SyntaxNode;
                                DecLoc                   : in LexTokenManager.Token_Position;
                                PrivateTypeBeingResolved : in Dictionary.Symbol)
   --# global in     CommandLineData.Content;
   --#        in     ContextManager.Ops.FileHeap;
   --#        in     ContextManager.Ops.UnitHeap;
   --#        in     ContextManager.Ops.UnitStack;
   --#        in     LexTokenManager.State;
   --#        in out Dictionary.Dict;
   --#        in out ErrorHandler.ErrorContext;
   --#        in out SLI.State;
   --#        in out SPARK_IO.File_Sys;
   --#        in out STree.Table;
   --# derives SLI.State                 from *,
   --#                                        CommandLineData.Content,
   --#                                        ContextManager.Ops.UnitHeap,
   --#                                        ContextManager.Ops.UnitStack,
   --#                                        DecLoc,
   --#                                        Dictionary.Dict,
   --#                                        ErrorHandler.ErrorContext,
   --#                                        Ident_Node,
   --#                                        LexTokenManager.State,
   --#                                        Node,
   --#                                        PrivateTypeBeingResolved,
   --#                                        Scope,
   --#                                        SPARK_IO.File_Sys,
   --#                                        STree.Table &
   --#         Dictionary.Dict,
   --#         STree.Table               from CommandLineData.Content,
   --#                                        ContextManager.Ops.UnitStack,
   --#                                        DecLoc,
   --#                                        Dictionary.Dict,
   --#                                        Ident_Node,
   --#                                        LexTokenManager.State,
   --#                                        Node,
   --#                                        PrivateTypeBeingResolved,
   --#                                        Scope,
   --#                                        STree.Table &
   --#         ErrorHandler.ErrorContext,
   --#         SPARK_IO.File_Sys         from CommandLineData.Content,
   --#                                        ContextManager.Ops.FileHeap,
   --#                                        ContextManager.Ops.UnitHeap,
   --#                                        ContextManager.Ops.UnitStack,
   --#                                        DecLoc,
   --#                                        Dictionary.Dict,
   --#                                        ErrorHandler.ErrorContext,
   --#                                        Ident_Node,
   --#                                        LexTokenManager.State,
   --#                                        Node,
   --#                                        PrivateTypeBeingResolved,
   --#                                        Scope,
   --#                                        SLI.State,
   --#                                        SPARK_IO.File_Sys,
   --#                                        STree.Table;
      is separate;

   -------------------------------

   procedure wf_protected_type_declaration (Node  : in STree.SyntaxNode;
                                            Scope : in Dictionary.Scopes)
   --# global in     CommandLineData.Content;
   --#        in     ContextManager.Ops.FileHeap;
   --#        in     ContextManager.Ops.UnitHeap;
   --#        in     ContextManager.Ops.UnitStack;
   --#        in out AggregateStack.State;
   --#        in out Dictionary.Dict;
   --#        in out ErrorHandler.ErrorContext;
   --#        in out GlobalComponentData;
   --#        in out LexTokenManager.State;
   --#        in out SLI.State;
   --#        in out SPARK_IO.File_Sys;
   --#        in out Statistics.TableUsage;
   --#        in out STree.Table;
   --#        in out TheHeap;
   --# derives ErrorHandler.ErrorContext,
   --#         SLI.State,
   --#         SPARK_IO.File_Sys         from CommandLineData.Content,
   --#                                        ContextManager.Ops.FileHeap,
   --#                                        ContextManager.Ops.UnitHeap,
   --#                                        ContextManager.Ops.UnitStack,
   --#                                        Dictionary.Dict,
   --#                                        ErrorHandler.ErrorContext,
   --#                                        GlobalComponentData,
   --#                                        LexTokenManager.State,
   --#                                        Node,
   --#                                        Scope,
   --#                                        SLI.State,
   --#                                        SPARK_IO.File_Sys,
   --#                                        STree.Table,
   --#                                        TheHeap &
   --#         AggregateStack.State,
   --#         Dictionary.Dict,
   --#         GlobalComponentData,
   --#         LexTokenManager.State,
   --#         Statistics.TableUsage,
   --#         STree.Table,
   --#         TheHeap                   from *,
   --#                                        CommandLineData.Content,
   --#                                        ContextManager.Ops.UnitStack,
   --#                                        Dictionary.Dict,
   --#                                        GlobalComponentData,
   --#                                        LexTokenManager.State,
   --#                                        Node,
   --#                                        Scope,
   --#                                        STree.Table,
   --#                                        TheHeap;
      is separate;

   -------------------------------

   procedure wf_task_type_declaration (Node  : in STree.SyntaxNode;
                                       Scope : in Dictionary.Scopes)
   --# global in     CommandLineData.Content;
   --#        in     ContextManager.Ops.FileHeap;
   --#        in     ContextManager.Ops.UnitHeap;
   --#        in     ContextManager.Ops.UnitStack;
   --#        in out AggregateStack.State;
   --#        in out Dictionary.Dict;
   --#        in out ErrorHandler.ErrorContext;
   --#        in out LexTokenManager.State;
   --#        in out SLI.State;
   --#        in out SPARK_IO.File_Sys;
   --#        in out Statistics.TableUsage;
   --#        in out STree.Table;
   --#        in out TheHeap;
   --# derives ErrorHandler.ErrorContext,
   --#         SLI.State,
   --#         SPARK_IO.File_Sys         from CommandLineData.Content,
   --#                                        ContextManager.Ops.FileHeap,
   --#                                        ContextManager.Ops.UnitHeap,
   --#                                        ContextManager.Ops.UnitStack,
   --#                                        Dictionary.Dict,
   --#                                        ErrorHandler.ErrorContext,
   --#                                        LexTokenManager.State,
   --#                                        Node,
   --#                                        Scope,
   --#                                        SLI.State,
   --#                                        SPARK_IO.File_Sys,
   --#                                        STree.Table,
   --#                                        TheHeap &
   --#         AggregateStack.State,
   --#         Dictionary.Dict,
   --#         LexTokenManager.State,
   --#         Statistics.TableUsage,
   --#         STree.Table,
   --#         TheHeap                   from *,
   --#                                        CommandLineData.Content,
   --#                                        ContextManager.Ops.UnitStack,
   --#                                        Dictionary.Dict,
   --#                                        LexTokenManager.State,
   --#                                        Node,
   --#                                        Scope,
   --#                                        STree.Table,
   --#                                        TheHeap;
      is separate;

   -------------------------------

   procedure wf_type_definition (Node                     : in STree.SyntaxNode;
                                 Scope                    : in Dictionary.Scopes;
                                 Ident_Node               : in STree.SyntaxNode;
                                 DecLoc                   : in LexTokenManager.Token_Position;
                                 PrivateTypeBeingResolved : in Dictionary.Symbol)
   --# global in     CommandLineData.Content;
   --#        in     ContextManager.Ops.FileHeap;
   --#        in     ContextManager.Ops.UnitHeap;
   --#        in     ContextManager.Ops.UnitStack;
   --#        in out AggregateStack.State;
   --#        in out Dictionary.Dict;
   --#        in out ErrorHandler.ErrorContext;
   --#        in out LexTokenManager.State;
   --#        in out SLI.State;
   --#        in out SPARK_IO.File_Sys;
   --#        in out Statistics.TableUsage;
   --#        in out STree.Table;
   --#        in out TheHeap;
   --# derives AggregateStack.State,
   --#         Statistics.TableUsage,
   --#         TheHeap                   from *,
   --#                                        CommandLineData.Content,
   --#                                        ContextManager.Ops.UnitStack,
   --#                                        Dictionary.Dict,
   --#                                        LexTokenManager.State,
   --#                                        Node,
   --#                                        Scope,
   --#                                        STree.Table,
   --#                                        TheHeap &
   --#         LexTokenManager.State     from *,
   --#                                        CommandLineData.Content,
   --#                                        ContextManager.Ops.UnitStack,
   --#                                        DecLoc,
   --#                                        Dictionary.Dict,
   --#                                        Ident_Node,
   --#                                        Node,
   --#                                        Scope,
   --#                                        STree.Table,
   --#                                        TheHeap &
   --#         Dictionary.Dict,
   --#         STree.Table               from CommandLineData.Content,
   --#                                        ContextManager.Ops.UnitStack,
   --#                                        DecLoc,
   --#                                        Dictionary.Dict,
   --#                                        Ident_Node,
   --#                                        LexTokenManager.State,
   --#                                        Node,
   --#                                        PrivateTypeBeingResolved,
   --#                                        Scope,
   --#                                        STree.Table,
   --#                                        TheHeap &
   --#         ErrorHandler.ErrorContext,
   --#         SLI.State,
   --#         SPARK_IO.File_Sys         from CommandLineData.Content,
   --#                                        ContextManager.Ops.FileHeap,
   --#                                        ContextManager.Ops.UnitHeap,
   --#                                        ContextManager.Ops.UnitStack,
   --#                                        DecLoc,
   --#                                        Dictionary.Dict,
   --#                                        ErrorHandler.ErrorContext,
   --#                                        Ident_Node,
   --#                                        LexTokenManager.State,
   --#                                        Node,
   --#                                        PrivateTypeBeingResolved,
   --#                                        Scope,
   --#                                        SLI.State,
   --#                                        SPARK_IO.File_Sys,
   --#                                        STree.Table,
   --#                                        TheHeap;
   is
      ChildNode             : STree.SyntaxNode;
      NodeType              : SPSymbols.SPSymbol;
      UnusedArrayTypeSymbol : Dictionary.Symbol;
      UnusedErrorsFound     : Boolean;
   begin
      -- ASSUME Node = type_definition

      ChildNode := Child_Node (Node);
      NodeType := SyntaxNodeType (ChildNode);
      case NodeType is
         when SPSymbols.enumeration_type_definition =>
            wf_enum (Node       => ChildNode,
                     Scope      => Scope,
                     Ident_Node => Ident_Node,
                     DecLoc     => DecLoc);
         when SPSymbols.real_type_definition =>
            wf_real (Node       => ChildNode,
                     Scope      => Scope,
                     Ident_Node => Ident_Node,
                     DecLoc     => DecLoc);
         when SPSymbols.record_type_definition =>
            wf_record (Node                     => ChildNode,
                       Scope                    => Scope,
                       Ident_Node               => Ident_Node,
                       DecLoc                   => DecLoc,
                       Extends                  => Dictionary.NullSymbol,
                       PrivateTypeBeingResolved => PrivateTypeBeingResolved);
         when SPSymbols.integer_type_definition =>
            wf_integer (Node       => ChildNode,
                        Scope      => Scope,
                        Ident_Node => Ident_Node,
                        DecLoc     => DecLoc);
         when SPSymbols.modular_type_definition =>
            wf_modular (Node       => ChildNode,
                        Scope      => Scope,
                        Ident_Node => Ident_Node,
                        DecLoc     => DecLoc);
         when SPSymbols.array_type_definition =>
            --# accept Flow, 10, UnusedErrorsFound, "Expected ineffective assignment" &
            --#        Flow, 10, UnusedArrayTypeSymbol, "Expected ineffective assignment";
            wf_array_type_definition (Node        => ChildNode,
                                      Scope       => Scope,
                                      Ident_Node  => Ident_Node,
                                      DecLoc      => DecLoc,
                                      IsGeneric   => False,
                                      ErrorsFound => UnusedErrorsFound,
                                      TheArray    => UnusedArrayTypeSymbol);
            --# end accept;
         when SPSymbols.type_extension =>
            wf_type_extension (Node                     => ChildNode,
                               Scope                    => Scope,
                               Ident_Node               => Ident_Node,
                               DecLoc                   => DecLoc,
                               PrivateTypeBeingResolved => PrivateTypeBeingResolved);
         when others =>
            null;        -- error
      end case;
      --# accept Flow, 33, UnusedErrorsFound, "Expected to be neither referenced nor exported" &
      --#        Flow, 33, UnusedArrayTypeSymbol, "Expected to be neither referenced nor exported";
   end wf_type_definition;

   -------------------------------

   function ValidScopeForTaskOrProtectedTypeDeclaration (Scope : Dictionary.Scopes) return Boolean
   --# global in Dictionary.Dict;
   is
   begin
      return (Dictionary.IsVisibleScope (Scope) or else
                Dictionary.IsPrivateScope (Scope)) and then
        Dictionary.IsPackage (Dictionary.GetRegion (Scope));
   end ValidScopeForTaskOrProtectedTypeDeclaration;

   -------------------------------

begin --wf_full_type_declaration
      --ASSUME Node = full_type_declaration

   IdentNode := Child_Node (Node);
   case SyntaxNodeType (IdentNode) is
      when SPSymbols.identifier =>  -- a type other than a task or protected object
         IdentStr := NodeLexString (IdentNode);
         Sym := Dictionary.LookupItem (Name    => IdentStr,
                                       Scope   => Scope,
                                       Context => Dictionary.ProofContext);

         if Sym = Dictionary.NullSymbol or else
           (Dictionary.IsTypeMark (Sym) and then
              Dictionary.TypeIsAnnounced (Sym) and then
              not Dictionary.IsDeclared (Sym)) or else
           IsPrivateTypeResolution (Sym, Scope) then
            if Sym = Dictionary.NullSymbol then
               --initial type declaration
               wf_type_definition (Node                     => Next_Sibling (IdentNode),
                                   Scope                    => Scope,
                                   Ident_Node               => IdentNode,
                                   DecLoc                   => NodePosition (Node),
                                   PrivateTypeBeingResolved => Sym);
            else
               TypeDeclaredAsLimited := Dictionary.IsLimitedPrivateType (Sym);
               TypeDeclaredAsTagged  := Dictionary.TypeIsTagged (Sym);
               Error_Found           := False;
               wf_type_definition (Node                     => Next_Sibling (IdentNode),
                                   Scope                    => Scope,
                                   Ident_Node               => IdentNode,
                                   DecLoc                   => NodePosition (Node),
                                   PrivateTypeBeingResolved => Sym);
               if Dictionary.IsUnconstrainedArrayType (Sym) then
                  if Dictionary.TypeIsAnnounced (Sym) then
                     Error_Found := True;
                     ErrorHandler.SemanticError (311,
                                                 ErrorHandler.NoReference,
                                                 NodePosition (IdentNode),
                                                 IdentStr);
                  else --private type
                     Error_Found := True;
                     ErrorHandler.SemanticError (331,
                                                 ErrorHandler.NoReference,
                                                 NodePosition (IdentNode),
                                                 IdentStr);
                  end if;
               end if;

               if not TypeDeclaredAsLimited and then
                 Dictionary.TypeIsLimited (Sym, Dictionary.GlobalScope) then
                  Error_Found := True;
                  ErrorHandler.SemanticError (332,
                                              ErrorHandler.NoReference,
                                              NodePosition (IdentNode),
                                              IdentStr);
               end if;

               -- initial declaration tagged but completion is not
               if TypeDeclaredAsTagged and then
                 not Dictionary.TypeIsTagged (Sym) then
                  Error_Found := True;
                  ErrorHandler.SemanticError (821,
                                              ErrorHandler.NoReference,
                                              NodePosition (IdentNode),
                                              IdentStr);
               end if;

               -- reverse case; this could be made legal but is not allowed for now
               if not TypeDeclaredAsTagged and then
                 Dictionary.TypeIsTagged (Sym) then
                  Error_Found := True;
                  ErrorHandler.SemanticError (830,
                                              ErrorHandler.NoReference,
                                              NodePosition (IdentNode),
                                              IdentStr);
               end if;

               if not Error_Found then
                  STree.Set_Node_Lex_String (Sym  => Sym,
                                             Node => IdentNode);
               end if;

            end if;
         else
            ErrorHandler.SemanticError (10,
                                        ErrorHandler.NoReference,
                                        NodePosition (IdentNode),
                                        IdentStr);
         end if;

      when SPSymbols.task_type_declaration =>
         if CommandLineData.RavenscarSelected then
            if ValidScopeForTaskOrProtectedTypeDeclaration (Scope) then
               wf_task_type_declaration (IdentNode, Scope);
            else
               ErrorHandler.SemanticError (987,
                                           ErrorHandler.NoReference,
                                           NodePosition (IdentNode),
                                           LexTokenManager.Null_String);
            end if;
         else -- declaration not allowed
            ErrorHandler.SemanticError (850,
                                        ErrorHandler.NoReference,
                                        NodePosition (IdentNode),
                                        LexTokenManager.Null_String);
         end if;

      when SPSymbols.protected_type_declaration =>
         if CommandLineData.RavenscarSelected then
            if ValidScopeForTaskOrProtectedTypeDeclaration (Scope) then
               wf_protected_type_declaration (IdentNode, Scope);
            else
               ErrorHandler.SemanticError (987,
                                           ErrorHandler.NoReference,
                                           NodePosition (IdentNode),
                                           LexTokenManager.Null_String);
            end if;
         else -- declaration not allowed
            ErrorHandler.SemanticError (850,
                                        ErrorHandler.NoReference,
                                        NodePosition (IdentNode),
                                        LexTokenManager.Null_String);
         end if;

      when others =>
         SystemErrors.FatalError (SystemErrors.InvalidSyntaxTree, "in wf_full_type_declaration");
   end case;
end wf_full_type_declaration;
