-- $Id: sem-compunit-wf_full_type_declaration-wf_type_extension.adb 16567 2010-03-25 16:09:40Z spark $
--------------------------------------------------------------------------------
-- (C) Altran Praxis Limited
--------------------------------------------------------------------------------
--
-- The SPARK toolset is free software; you can redistribute it and/or modify it
-- under terms of the GNU General Public License as published by the Free
-- Software Foundation; either version 3, or (at your option) any later
-- version. The SPARK toolset is distributed in the hope that it will be
-- useful, but WITHOUT ANY WARRANTY; without even the implied warranty of
-- MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the GNU General
-- Public License for more details. You should have received a copy of the GNU
-- General Public License distributed with the SPARK toolset; see file
-- COPYING3. If not, go to http://www.gnu.org/licenses for a complete copy of
-- the license.
--
--==============================================================================


separate (Sem.CompUnit.wf_full_type_declaration)
procedure wf_type_extension (Node                     : in STree.SyntaxNode;
                             Scope                    : in Dictionary.Scopes;
                             Ident_Node               : in STree.SyntaxNode;
                             DecLoc                   : in LexTokenManager.Token_Position;
                             PrivateTypeBeingResolved : in Dictionary.Symbol)
is
   RootTypeNode : STree.SyntaxNode;
   RootTypeSym  : Dictionary.Symbol;
   ThisPackage  : Dictionary.Symbol;

begin --wf_type_extension
   -- Node is type_extension node.
   -- Grammar: type_extension          or      type_extension
   --               |                               |
   --        private_type_extension         record_type_extension
   --               |                               |
   --           type_mark                      type_mark -- record_definition
   --
   -- Rules: 1 type_mark must be visible tagged type from another package
   --        2 this package must not already contain a type extension
   --        3 record components handled as for any other record

   -- first check that we do not already have a type extension in this package
   -- since SPARK requires a maximum of one per package to avoid overloading
   -- introduced by unherited operations.  A second declaration is allowed if
   -- it completing a private extension in which case it must be compatible with
   -- the first declaration.
   case CommandLineData.Content.LanguageProfile is
      when CommandLineData.SPARK83 =>
         ErrorHandler.SemanticError (826,
                                     ErrorHandler.NoReference,
                                     NodePosition (Node),
                                     LexTokenManager.Null_String);
      when CommandLineData.SPARK95 |
        CommandLineData.SPARK2005 =>

         -- check that we are in a library package spec
         if Dictionary.GetLibraryPackage (Scope) = Dictionary.GetRegion (Scope) and then
           (Dictionary.IsVisibleScope (Scope) or Dictionary.IsPrivateScope (Scope)) then

            ThisPackage := Dictionary.GetRegion (Scope);
            if Dictionary.PackageDeclaresTaggedType (ThisPackage) then

               ErrorHandler.SemanticError (839,
                                           ErrorHandler.NoReference,
                                           NodePosition (Node),
                                           LexTokenManager.Null_String);

            elsif Dictionary.PackageExtendsAnotherPackage (ThisPackage) and then
              not IsPrivateTypeResolution (PrivateTypeBeingResolved, Scope) then

               ErrorHandler.SemanticError (824,
                                           ErrorHandler.NoReference,
                                           NodePosition (Node),
                                           Dictionary.GetSimpleName
                                             (Dictionary.GetPackageThatIsExtended
                                                (ThisPackage)));
            else -- first extension or resolution of a private extension
               RootTypeNode := Child_Node (Child_Node (Node));
               wf_type_mark (RootTypeNode,
                             Scope,
                             Dictionary.ProgramContext,
                             -- to get
                             RootTypeSym);

               -- if we are resolving a private extension then the RootTypeSym must be the same as
               -- the type we originally extended
               if IsPrivateTypeResolution (PrivateTypeBeingResolved, Scope) and then
                 RootTypeSym /= Dictionary.GetRootOfExtendedType (PrivateTypeBeingResolved) then
                  ErrorHandler.SemanticErrorSym (825,
                                                 ErrorHandler.NoReference,
                                                 NodePosition (RootTypeNode),
                                                 Dictionary.GetRootOfExtendedType (PrivateTypeBeingResolved),
                                                 Scope);
               end if;

               -- wf_type_mark will return the unknown type if it found any errors
               if RootTypeSym /= Dictionary.GetUnknownTypeMark then
                  -- check that RootTypeSym represents a tagged
                  if Dictionary.TypeIsTagged (RootTypeSym) then
                     -- check that type being extended is not locally declared
                     if Dictionary.GetScope (RootTypeSym) /= Scope then
                        -- mark this package as extending the one declaring the root type
                        Dictionary.SetPackageAsExtendingAnother (ThisPackage,
                                                                 Dictionary.GetRegion
                                                                   (Dictionary.GetScope (RootTypeSym)));

                        -- add private type or add record type
                        if SyntaxNodeType (Child_Node (Node)) = SPSymbols.private_type_extension then
                           -- process with private
                           Dictionary.AddPrivateType (Name           => NodeLexString (Ident_Node),
                                                      Comp_Unit      => ContextManager.Ops.CurrentUnit,
                                                      Declaration    => Dictionary.Location'(DecLoc, DecLoc),
                                                      ThePackage     => ThisPackage,
                                                      IsLimited      => False,
                                                      IsTaggedType   => False,
                                                      IsAbstractType => False,
                                                      Extends        => RootTypeSym);
                        else
                           -- process rest of with record
                           wf_record (Node                     => Next_Sibling (RootTypeNode),
                                      Scope                    => Scope,
                                      Ident_Node               => Ident_Node,
                                      DecLoc                   => DecLoc,
                                      Extends                  => RootTypeSym,
                                      PrivateTypeBeingResolved => PrivateTypeBeingResolved);
                        end if;

                     else -- local type being extended
                        ErrorHandler.SemanticError (823,
                                                    ErrorHandler.NoReference,
                                                    NodePosition (RootTypeNode),
                                                    LexTokenManager.Null_String);
                     end if;

                  else -- illegal type being extended
                     ErrorHandler.SemanticErrorSym (822,
                                                    ErrorHandler.NoReference,
                                                    NodePosition (RootTypeNode),
                                                    RootTypeSym,
                                                    Scope);
                  end if;
               end if;
            end if;
         else -- not in library spec
            ErrorHandler.SemanticError (828,
                                        ErrorHandler.NoReference,
                                        NodePosition (Node),
                                        LexTokenManager.Null_String);

         end if;
   end case;

end wf_type_extension;
