-- $Id: sem-compunit-wf_full_type_declaration-wf_modular.adb 16669 2010-04-01 11:26:15Z spark $
--------------------------------------------------------------------------------
-- (C) Altran Praxis Limited
--------------------------------------------------------------------------------
--
-- The SPARK toolset is free software; you can redistribute it and/or modify it
-- under terms of the GNU General Public License as published by the Free
-- Software Foundation; either version 3, or (at your option) any later
-- version. The SPARK toolset is distributed in the hope that it will be
-- useful, but WITHOUT ANY WARRANTY; without even the implied warranty of
-- MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the GNU General
-- Public License for more details. You should have received a copy of the GNU
-- General Public License distributed with the SPARK toolset; see file
-- COPYING3. If not, go to http://www.gnu.org/licenses for a complete copy of
-- the license.
--
--==============================================================================

with SLI;

separate (Sem.CompUnit.wf_full_type_declaration)

procedure wf_modular
  (Node       : in STree.SyntaxNode;
   Scope      : in Dictionary.Scopes;
   Ident_Node : in STree.SyntaxNode;
   DecLoc     : in LexTokenManager.Token_Position)
is
   ExpNode               : STree.SyntaxNode;
   ExpType               : ExpRecord;
   UnwantedSeq           : SeqAlgebra.Seq;
   Modulus               : LexTokenManager.Lex_String;
   UnusedComponentData   : ComponentManager.ComponentData;
   Type_Symbol           : Dictionary.Symbol;
   SystemSym             : Dictionary.Symbol;
   Max_Binary_ModulusSym : Dictionary.Symbol;
   Max_Binary_ModulusVal : LexTokenManager.Lex_String;
   Result                : Maths.Value;
   Unused                : Maths.ErrorCode;
   ModulusOK             : Boolean;

begin
   -- Assume Node is modular_type_definition

   case CommandLineData.Content.LanguageProfile is
      when CommandLineData.SPARK83 =>

         ErrorHandler.SemanticError (801,
                                     ErrorHandler.NoReference,
                                     NodePosition (Node),
                                     LexTokenManager.Null_String);

      when CommandLineData.SPARK95 |
        CommandLineData.SPARK2005 =>

         -- Fetch Modulus, which is a simple_expression
         ExpNode := Next_Sibling (Child_Node (Node));

         SeqAlgebra.CreateSeq (TheHeap, UnwantedSeq);
         ComponentManager.Initialise (UnusedComponentData);
         --# accept Flow, 10, UnusedComponentData, "Expected ineffective assignment";
         WalkExpression (ExpNode,
                         Scope,
                         -- The context given in the LRM (3.5.4(5)) is "any integer type", but we
                         -- never resolve by context here, so UnknownTypeMark will do.
                         Dictionary.GetUnknownTypeMark,
                         True, -- static expression required.
                         -- to get
                         ExpType,
                         UnwantedSeq,
                         UnusedComponentData);
         --# end accept;
         SeqAlgebra.DisposeOfSeq (TheHeap, UnwantedSeq);
         Maths.StorageRep (ExpType.Value, Modulus);

         if not (Dictionary.TypeIsInteger (ExpType.TypeSymbol) or
                   Dictionary.TypeIsModular (ExpType.TypeSymbol) or
                   Dictionary.IsUnknownTypeMark (ExpType.TypeSymbol)) then
            Modulus := LexTokenManager.Null_String;
            ErrorHandler.SemanticError (38,
                                        ErrorHandler.NoReference,
                                        NodePosition (ExpNode),
                                        LexTokenManager.Null_String);
         end if;

         if not ExpType.IsStatic then
            Modulus := LexTokenManager.Null_String;
            ErrorHandler.SemanticError (36,
                                        1,
                                        NodePosition (ExpNode),
                                        LexTokenManager.Null_String);
         elsif ExpType.IsARange then
            ErrorHandler.SemanticError (114,
                                        ErrorHandler.NoReference,
                                        NodePosition (ExpNode),
                                        LexTokenManager.Null_String);
         else
            if Maths.IsAPositivePowerOf2 (ExpType.Value) then

               -- All is OK so far, so finally check the modulus against
               -- System.Max_Binary_Modulus
               SystemSym := Dictionary.LookupItem (Name    => LexTokenManager.System_Token,
                                                   Scope   => Dictionary.GlobalScope,
                                                   Context => Dictionary.ProgramContext);
               -- The user may or may not have bothered to supply
               -- package System, so...
               if SystemSym /= Dictionary.NullSymbol then

                  -- Find System.Max_Binary_Modulus
                  Max_Binary_ModulusSym := Dictionary.LookupSelectedItem
                    (Prefix   => SystemSym,
                     Selector => LexTokenManager.Max_Binary_Modulus_Token,
                     Scope    => Dictionary.GetScope (SystemSym),
                     Context  => Dictionary.ProgramContext);

                  -- Even if the user has supplied a package System, they might
                  -- not have declared Max_Binary_Modulus, so again we have to guard...
                  if Max_Binary_ModulusSym /= Dictionary.NullSymbol then

                     Max_Binary_ModulusVal := Dictionary.GetValue (Max_Binary_ModulusSym);

                     --# accept Flow, 10, Unused, "Expected ineffective assignment";
                     Maths.LesserOrEqual (ExpType.Value,
                                          Maths.ValueRep (Max_Binary_ModulusVal),
                                          Result,
                                          Unused);

                     Maths.ValueToBool (Result, ModulusOK, Unused);
                     --# end accept;

                     if not ModulusOK then
                        ErrorHandler.SemanticError (783,
                                                    ErrorHandler.NoReference,
                                                    NodePosition (ExpNode),
                                                    LexTokenManager.Null_String);
                     end if;
                  end if;
               end if;
            else

               Modulus := LexTokenManager.Null_String;
               ErrorHandler.SemanticError (800,
                                           ErrorHandler.NoReference,
                                           NodePosition (ExpNode),
                                           LexTokenManager.Null_String);
            end if;
         end if;

         Dictionary.AddModularType (Name        => NodeLexString (Ident_Node),
                                    Comp_Unit   => ContextManager.Ops.CurrentUnit,
                                    Declaration => Dictionary.Location'(DecLoc, DecLoc),
                                    Modulus     => Modulus,
                                    Scope       => Scope,
                                    Context     => Dictionary.ProgramContext,
                                    Type_Symbol => Type_Symbol);
         if ErrorHandler.Generate_SLI then
            SLI.Generate_Xref_Symbol (Comp_Unit      => ContextManager.Ops.CurrentUnit,
                                      Parse_Tree     => Ident_Node,
                                      Symbol         => Type_Symbol,
                                      Is_Declaration => True);
         end if;
   end case;
   --# accept Flow, 33, Unused, "Expected to be neither referenced nor exported";
end wf_modular;
