-- $Id: sem-compunit-wf_elaborate_body.adb 15674 2010-01-20 16:17:20Z spark $
--------------------------------------------------------------------------------
-- (C) Altran Praxis Limited
--------------------------------------------------------------------------------
--
-- The SPARK toolset is free software; you can redistribute it and/or modify it
-- under terms of the GNU General Public License as published by the Free
-- Software Foundation; either version 3, or (at your option) any later
-- version. The SPARK toolset is distributed in the hope that it will be
-- useful, but WITHOUT ANY WARRANTY; without even the implied warranty of
-- MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the GNU General
-- Public License for more details. You should have received a copy of the GNU
-- General Public License distributed with the SPARK toolset; see file
-- COPYING3. If not, go to http://www.gnu.org/licenses for a complete copy of
-- the license.
--
--==============================================================================

-- Synopsis
-- This procedure checks the validity of a pragma elaborate_body for SPARK 95
--------------------------------------------------------------------------------
separate (Sem.CompUnit)
procedure wf_elaborate_body (PragmaNode : in STree.SyntaxNode;
                             PackSym    : in Dictionary.Symbol)
is
   IdNode           : STree.SyntaxNode;
   ExpNode          : STree.SyntaxNode;

   procedure CheckRepresentSameName (Exp_Node : in STree.SyntaxNode;
                                     Pack_Sym : in Dictionary.Symbol)
   --# global in     CommandLineData.Content;
   --#        in     Dictionary.Dict;
   --#        in     LexTokenManager.State;
   --#        in out ErrorHandler.ErrorContext;
   --#        in out SPARK_IO.FILE_SYS;
   --#        in out STree.Table;
   --# derives ErrorHandler.ErrorContext,
   --#         SPARK_IO.FILE_SYS         from CommandLineData.Content,
   --#                                        Dictionary.Dict,
   --#                                        ErrorHandler.ErrorContext,
   --#                                        Exp_Node,
   --#                                        LexTokenManager.State,
   --#                                        Pack_Sym,
   --#                                        SPARK_IO.FILE_SYS,
   --#                                        STree.Table &
   --#         STree.Table               from *,
   --#                                        Dictionary.Dict,
   --#                                        Exp_Node,
   --#                                        LexTokenManager.State,
   --#                                        Pack_Sym;
   is
      IsChain  : Boolean;
      IdNode,
      NextNode : STree.SyntaxNode;
      Name     : LexTokenManager.Lex_String;
   begin
      Name := Dictionary.GetSimpleName (Item => Pack_Sym);
      IdNode := Exp_Node;
      loop
         IsChain := Next_Sibling (IdNode) =
           STree.NullNode;
         NextNode := Child_Node (IdNode);
         exit when not IsChain or NextNode = STree.NullNode;

         IdNode := NextNode;
      end loop;

      if IsChain and then
        SyntaxNodeType (IdNode) = SPSymbols.identifier and then
        LexTokenManager.Lex_String_Case_Insensitive_Compare (Lex_Str1 => NodeLexString (IdNode),
                                                             Lex_Str2 => Name) = LexTokenManager.Str_Eq then
         STree.Set_Node_Lex_String (Sym  => Pack_Sym,
                                    Node => IdNode);
      else
         ErrorHandler.SemanticError (606,
                                     ErrorHandler.NoReference,
                                     NodePosition (Exp_Node),
                                     Name);
      end if;
   end CheckRepresentSameName;

   ------------------------------------------------------------------

begin --wf_elaborate_body
   IdNode := Child_Node (PragmaNode);
   if Dictionary.IsPackage (PackSym) and then
      Dictionary.GetScope (PackSym) = Dictionary.GlobalScope
   then --legal, library-level package
      Dictionary.SetPackageElaborateBodyFound (PackSym);
      ExpNode := Child_Node (Child_Node (Next_Sibling (IdNode)));
      if SyntaxNodeType (ExpNode) /= SPSymbols.ADA_expression then
         --wrong number of arguments
         ErrorHandler.SemanticError (605,
                                     ErrorHandler.NoReference,
                                     NodePosition (IdNode),
                                     LexTokenManager.Null_String);
      else
         CheckRepresentSameName (Exp_Node => ExpNode,
                                 Pack_Sym => PackSym);
      end if;

   else --not a library level package
      ErrorHandler.SemanticError (72,
                                  ErrorHandler.NoReference,
                                  NodePosition (PragmaNode),
                                  LexTokenManager.Elaborate_Body_Token);
   end if;
end wf_elaborate_body;
