-- $Id: sem-compunit-wf_context_clause.adb 15674 2010-01-20 16:17:20Z spark $
--------------------------------------------------------------------------------
-- (C) Altran Praxis Limited
--------------------------------------------------------------------------------
--
-- The SPARK toolset is free software; you can redistribute it and/or modify it
-- under terms of the GNU General Public License as published by the Free
-- Software Foundation; either version 3, or (at your option) any later
-- version. The SPARK toolset is distributed in the hope that it will be
-- useful, but WITHOUT ANY WARRANTY; without even the implied warranty of
-- MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the GNU General
-- Public License for more details. You should have received a copy of the GNU
-- General Public License distributed with the SPARK toolset; see file
-- COPYING3. If not, go to http://www.gnu.org/licenses for a complete copy of
-- the license.
--
--==============================================================================

separate (Sem.CompUnit)

procedure wf_context_clause (Node    : in STree.SyntaxNode;
                             CompSym : in Dictionary.Symbol;
                             Scope   : in Dictionary.Scopes)
is
   NextNode    : STree.SyntaxNode;

   procedure with_clause (Node    : in STree.SyntaxNode;
                          CompSym : in Dictionary.Symbol;
                          Scope   : in Dictionary.Scopes)
   --# global in     CommandLineData.Content;
   --#        in     ContextManager.Ops.UnitStack;
   --#        in     LexTokenManager.State;
   --#        in out Dictionary.Dict;
   --#        in out ErrorHandler.ErrorContext;
   --#        in out SPARK_IO.FILE_SYS;
   --#        in out STree.Table;
   --# derives ErrorHandler.ErrorContext,
   --#         SPARK_IO.FILE_SYS         from CommandLineData.Content,
   --#                                        CompSym,
   --#                                        ContextManager.Ops.UnitStack,
   --#                                        Dictionary.Dict,
   --#                                        ErrorHandler.ErrorContext,
   --#                                        LexTokenManager.State,
   --#                                        Node,
   --#                                        Scope,
   --#                                        SPARK_IO.File_Sys,
   --#                                        STree.Table &
   --#         Dictionary.Dict,
   --#         STree.Table               from CommandLineData.Content,
   --#                                        CompSym,
   --#                                        ContextManager.Ops.UnitStack,
   --#                                        Dictionary.Dict,
   --#                                        LexTokenManager.State,
   --#                                        Node,
   --#                                        Scope,
   --#                                        STree.Table;
      is separate;

   procedure use_clause (Node  : in STree.SyntaxNode;
                         Scope : in Dictionary.Scopes)
   --# global in     CommandLineData.Content;
   --#        in     ContextManager.Ops.UnitStack;
   --#        in     LexTokenManager.State;
   --#        in out Dictionary.Dict;
   --#        in out ErrorHandler.ErrorContext;
   --#        in out SPARK_IO.FILE_SYS;
   --#        in out STree.Table;
   --# derives ErrorHandler.ErrorContext,
   --#         SPARK_IO.FILE_SYS         from CommandLineData.Content,
   --#                                        ContextManager.Ops.UnitStack,
   --#                                        Dictionary.Dict,
   --#                                        ErrorHandler.ErrorContext,
   --#                                        LexTokenManager.State,
   --#                                        Node,
   --#                                        Scope,
   --#                                        SPARK_IO.File_Sys,
   --#                                        STree.Table &
   --#         Dictionary.Dict,
   --#         STree.Table               from CommandLineData.Content,
   --#                                        ContextManager.Ops.UnitStack,
   --#                                        Dictionary.Dict,
   --#                                        LexTokenManager.State,
   --#                                        Node,
   --#                                        Scope,
   --#                                        STree.Table;
      is separate;

begin --wf_context_clause
   NextNode := Child_Node (Node); --this must be a with node
   with_clause (NextNode,
                CompSym,
                Scope);

   NextNode := Next_Sibling (NextNode);
   if Child_Node (NextNode) /= STree.NullNode then
      --there is one or more further with clause or usetype clause to process
      NextNode := LastChildOf (NextNode);
      NextNode := Next_Sibling (NextNode);
      loop
         exit when SyntaxNodeType (NextNode) /= SPSymbols.with_clause and
            SyntaxNodeType (NextNode) /= SPSymbols.use_type_clause;

         if SyntaxNodeType (NextNode) = SPSymbols.with_clause then
            with_clause (NextNode,
                         CompSym,
                         Scope);
         else
            use_clause (NextNode,
                        Scope);
         end if;
         NextNode := Next_Sibling (ParentNode (NextNode));
      end loop;
   end if;
end wf_context_clause;
