-- $Id: sem-compunit-wf_context_clause-use_clause.adb 15674 2010-01-20 16:17:20Z spark $
--------------------------------------------------------------------------------
-- (C) Altran Praxis Limited
--------------------------------------------------------------------------------
--
-- The SPARK toolset is free software; you can redistribute it and/or modify it
-- under terms of the GNU General Public License as published by the Free
-- Software Foundation; either version 3, or (at your option) any later
-- version. The SPARK toolset is distributed in the hope that it will be
-- useful, but WITHOUT ANY WARRANTY; without even the implied warranty of
-- MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the GNU General
-- Public License for more details. You should have received a copy of the GNU
-- General Public License distributed with the SPARK toolset; see file
-- COPYING3. If not, go to http://www.gnu.org/licenses for a complete copy of
-- the license.
--
--==============================================================================


separate (Sem.CompUnit.wf_context_clause)

procedure use_clause (Node  : in STree.SyntaxNode;
                      Scope : in Dictionary.Scopes)
is
   Sym         : Dictionary.Symbol;
   NextNode    : STree.SyntaxNode;
   It          : STree.Iterator;
   PrefixOk    : Boolean;
   OkToAdd     : Boolean := True;

   procedure CheckPrefix (TypeNode : in     STree.SyntaxNode;
                          PrefixOk :    out Boolean)
   --# global in     CommandLineData.Content;
   --#        in     Dictionary.Dict;
   --#        in     LexTokenManager.State;
   --#        in     Scope;
   --#        in out ErrorHandler.ErrorContext;
   --#        in out SPARK_IO.FILE_SYS;
   --#        in out STree.Table;
   --# derives ErrorHandler.ErrorContext,
   --#         SPARK_IO.FILE_SYS         from CommandLineData.Content,
   --#                                        Dictionary.Dict,
   --#                                        ErrorHandler.ErrorContext,
   --#                                        LexTokenManager.State,
   --#                                        Scope,
   --#                                        SPARK_IO.FILE_SYS,
   --#                                        STree.Table,
   --#                                        TypeNode &
   --#         PrefixOk,
   --#         STree.Table               from CommandLineData.Content,
   --#                                        Dictionary.Dict,
   --#                                        LexTokenManager.State,
   --#                                        Scope,
   --#                                        STree.Table,
   --#                                        TypeNode;
   is
      CurrNode    : STree.SyntaxNode;
      LastNode    : STree.SyntaxNode;
      Sym         : Dictionary.Symbol;
      ParentSym   : Dictionary.Symbol;
      LibSym      : Dictionary.Symbol;
      Ok          : Boolean := True;
   begin
      LibSym := Dictionary.GetLibraryPackage (Scope);
      LastNode := Child_Node (
                                  Child_Node (TypeNode));
      CurrNode := LastChildOf (TypeNode);
      ParentSym := Dictionary.NullSymbol;
      Sym := Dictionary.LookupItem (Name    => NodeLexString (CurrNode),
                                    Scope   => Dictionary.GlobalScope,
                                    Context => Dictionary.ProgramContext);
      loop
         if Sym = Dictionary.NullSymbol then --not declared or not visible
            Ok := False;
            ErrorHandler.SemanticError (131,
                                        ErrorHandler.NoReference,
                                        NodePosition (CurrNode),
                                        NodeLexString (CurrNode));
         elsif not Dictionary.IsPackage (Sym) then
            Ok := False;
            ErrorHandler.SemanticError (18,
                                        ErrorHandler.NoReference,
                                        NodePosition (CurrNode),
                                        NodeLexString (CurrNode));
         end if;

         exit when not Ok;
         STree.Set_Node_Lex_String (Sym  => Sym,
                                    Node => CurrNode);
         -- normal exit, prefix exhausted:
         exit when ParentNode (CurrNode) = LastNode;

         -- special case, null prefix:
         exit when CurrNode = LastNode;

         CurrNode := Next_Sibling (ParentNode (CurrNode));
         ParentSym := Sym;
         Sym := Dictionary.LookupSelectedItem (Prefix   => Sym,
                                               Selector => NodeLexString (CurrNode),
                                               Scope    => Dictionary.GlobalScope,
                                               Context  => Dictionary.ProofContext);
      end loop;

      if Ok then
         -- check visibility in current scope
         if Sym = LibSym then -- using self
            Sym := Dictionary.NullSymbol;
            Ok := False;
            ErrorHandler.SemanticError (130,
                                        ErrorHandler.NoReference,
                                        NodePosition (CurrNode),
                                        NodeLexString (CurrNode));
         else
            if ParentSym = Dictionary.NullSymbol
               or else
               Dictionary.IsProperDescendent (LibSym, Sym)
               -- using an ancestor
               or else
               Dictionary.IsProperDescendent (LibSym, ParentSym)
               -- using child of ancestor
               or else
               ParentSym = LibSym  -- using own child
            then -- look up directly
               Sym := Dictionary.LookupItem (Name    => NodeLexString (CurrNode),
                                             Scope   => Scope,
                                             Context => Dictionary.ProgramContext);
            else
               Sym := Dictionary.LookupSelectedItem (Prefix   => ParentSym,
                                                     Selector => NodeLexString (CurrNode),
                                                     Scope    => Scope,
                                                     Context  => Dictionary.ProgramContext);
            end if;
            if Sym = Dictionary.NullSymbol then
               Ok := False;
               ErrorHandler.SemanticError (1,
                                           ErrorHandler.NoReference,
                                           NodePosition (CurrNode),
                                           NodeLexString (CurrNode));
            elsif Dictionary.IsProperDescendent (LibSym, Sym) then  -- using an ancestor
               Ok := False;
               ErrorHandler.SemanticError (624,
                                           ErrorHandler.NoReference,
                                           NodePosition (CurrNode),
                                           NodeLexString (CurrNode));
            else
               STree.Set_Node_Lex_String (Sym  => Sym,
                                          Node => CurrNode);
            end if;
         end if;
      end if;

      if Ok and then not Dictionary.IsWithedLocally (Sym, Scope) then
         Ok := False;
         ErrorHandler.SemanticError (555,
                                     ErrorHandler.NoReference,
                                     NodePosition (CurrNode),
                                     NodeLexString (CurrNode));
      end if;
      PrefixOk := Ok;
   end CheckPrefix;

begin -- use_clause
   case CommandLineData.Content.LanguageProfile is
      when CommandLineData.SPARK83 =>

         ErrorHandler.SemanticError (550,
                                     ErrorHandler.NoReference,
                                     NodePosition (Node),
                                     LexTokenManager.Null_String);
      when CommandLineData.SPARK95 |
        CommandLineData.SPARK2005 =>

         Dictionary.AddUseTypeClause (Scope,
                                      Dictionary.Location'(NodePosition (Node),
                                                           NodePosition (Node)));

         It := FindFirstNode (NodeKind    => SPSymbols.type_mark,
                              FromRoot    => Node,
                              InDirection => STree.Down);

         while not STree.IsNull (It) loop --for each type_mark in use type list

            NextNode := GetNode (It);

            -- first we must check that the prefix is a package which is locally withed
            CheckPrefix (NextNode,
                         -- to get
                         PrefixOk);

            if not PrefixOk then
               Sym := Dictionary.GetUnknownTypeMark;
            else  -- there's a valid package prefix so go on to check that whole thing
                  -- is a suitable type mark
               wf_type_mark (NextNode,
                             Dictionary.GlobalScope,
                             Dictionary.ProofContext,
                             -- to get
                             Sym);
            end if;
            -- no action if any error found during wffing of type mark
            if not Dictionary.IsUnknownTypeMark (Sym) then
               -- work entirely in terms of base types
               Sym := Dictionary.GetRootType (Sym);

               if Next_Sibling (Child_Node (Child_Node (NextNode))) =
                 STree.NullNode or else
                 (Dictionary.GetScope (Sym) =
                    Dictionary.VisibleScope (Dictionary.GetPredefinedPackageStandard))
               then -- from standard or there is no dotted part so all operators are already visible
                  OkToAdd := False;
                  ErrorHandler.SemanticErrorSym (551,
                                                 ErrorHandler.NoReference,
                                                 NodePosition (NextNode),
                                                 Sym,
                                                 Scope);
               end if;

               -- check for duplicates
               if Dictionary.IsUsedLocally (Sym, Scope) then
                  OkToAdd := False;
                  ErrorHandler.SemanticErrorSym (552, ErrorHandler.NoReference,
                                                 NodePosition (NextNode),
                                                 Sym,
                                                 Scope);
               end if;

               -- limited private type, no operators avaiable
               if Dictionary.TypeIsLimited (Sym, Scope) then
                  OkToAdd := False;
                  ErrorHandler.SemanticErrorSym (554, ErrorHandler.NoReference,
                                                 NodePosition (NextNode),
                                                 Sym,
                                                 Scope);
               end if;

               if OkToAdd then
                  Dictionary.AddUseTypeReference
                    (Scope         => Scope,
                     TheType       => Sym,
                     Comp_Unit     => ContextManager.Ops.CurrentUnit,
                     TypeReference => Dictionary.Location'(NodePosition (NextNode),
                                                           NodePosition (NextNode)));
               end if;
            end if; -- not unknown type mark
            It := STree.NextNode (It);
         end loop;
   end case;

end use_clause;
