-- $Id: sem-compunit-wf_array_type_definition.adb 16669 2010-04-01 11:26:15Z spark $
--------------------------------------------------------------------------------
-- (C) Altran Praxis Limited
--------------------------------------------------------------------------------
--
-- The SPARK toolset is free software; you can redistribute it and/or modify it
-- under terms of the GNU General Public License as published by the Free
-- Software Foundation; either version 3, or (at your option) any later
-- version. The SPARK toolset is distributed in the hope that it will be
-- useful, but WITHOUT ANY WARRANTY; without even the implied warranty of
-- MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the GNU General
-- Public License for more details. You should have received a copy of the GNU
-- General Public License distributed with the SPARK toolset; see file
-- COPYING3. If not, go to http://www.gnu.org/licenses for a complete copy of
-- the license.
--
--==============================================================================

with SLI;

separate (Sem.CompUnit)

procedure wf_array_type_definition (Node        : in     STree.SyntaxNode;
                                    Scope       : in     Dictionary.Scopes;
                                    Ident_Node  : in     STree.SyntaxNode;
                                    DecLoc      : in     LexTokenManager.Token_Position;
                                    IsGeneric   : in     Boolean;
                                    ErrorsFound :    out Boolean;
                                    TheArray    :    out Dictionary.Symbol)
is
   RootNode,
   TypeNode,
   NextNode    : STree.SyntaxNode;
   It          : STree.Iterator;
   Constrained : Boolean;
   TypeSym     : Dictionary.Symbol;
   TypePos     : LexTokenManager.Token_Position;
begin --wf_array_type_definition
   -- ASSUME Node = array_type_definition

   RootNode := Child_Node (Node);
   Constrained := SyntaxNodeType (RootNode) =
      SPSymbols.constrained_array_definition;
   RootNode := Child_Node (RootNode);
   TypeNode :=  Next_Sibling (RootNode);
   TypePos  := NodePosition (TypeNode);
   TheArray := Dictionary.GetUnknownTypeMark; -- default answer in case of errors
   ErrorsFound := False;
   wf_type_mark (TypeNode,
                 Scope,
                 Dictionary.ProgramContext,
                  --to get
                 TypeSym);
   if not Dictionary.IsUnknownTypeMark (TypeSym) and then
      Dictionary.IsUnconstrainedArrayType (TypeSym)
   then
      ErrorsFound := True;
      ErrorHandler.SemanticError (39,
                                  ErrorHandler.NoReference,
                                  NodePosition (TypeNode),
                                  LexTokenManager.Null_String);
   end if;

   -- Check that the type is not a suspension object or protected type
   if Dictionary.IsPredefinedSuspensionObjectType (TypeSym) or
     Dictionary.TypeIsProtected (TypeSym) then
      ErrorsFound := True;
      ErrorHandler.SemanticError (906,
                                  ErrorHandler.NoReference,
                                  NodePosition (TypeNode),
                                  LexTokenManager.Null_String);

   else

      Dictionary.AddArrayType (Name                   => NodeLexString (Ident_Node),
                               Comp_Unit              => ContextManager.Ops.CurrentUnit,
                               Declaration            => Dictionary.Location'(DecLoc, DecLoc),
                               Scope                  => Scope,
                               Context                => Dictionary.ProgramContext,
                               Constrained            => Constrained,
                               ComponentType          => TypeSym,
                               ComponentTypeReference => Dictionary.Location'(TypePos, TypePos),
                               IsGeneric              => IsGeneric,
                               --to get
                               TheArrayType           => TheArray);
      if ErrorHandler.Generate_SLI then
         SLI.Generate_Xref_Symbol (Comp_Unit      => ContextManager.Ops.CurrentUnit,
                                   Parse_Tree     => Ident_Node,
                                   Symbol         => TheArray,
                                   Is_Declaration => True);
      end if;
      --now loop through all the index type marks

      It := FindFirstNode (NodeKind    => SPSymbols.type_mark,
                           FromRoot    => RootNode,
                           InDirection => STree.Down);

      while not STree.IsNull (It) loop
         NextNode := GetNode (It);
         wf_type_mark (NextNode,
                       Scope,
                       Dictionary.ProgramContext,
                        --to get
                       TypeSym);

         if not Dictionary.IsUnknownTypeMark (TypeSym) then
            if TypeSym = TheArray then
               -- Type of index is same as type of array being declared
               ErrorsFound := True;
               ErrorHandler.SemanticError (750,
                                           ErrorHandler.NoReference,
                                           NodePosition (NextNode),
                                           Dictionary.GetSimpleName (TypeSym));
            else   --no self-reference attempted
               if not Dictionary.IsDiscreteTypeMark (TypeSym,
                                                     Scope)
               then
                  ErrorsFound := True;
                  ErrorHandler.SemanticError (46,
                                              ErrorHandler.NoReference,
                                              NodePosition (NextNode),
                                              LexTokenManager.Null_String);
               end if;
               if not Dictionary.TypeIsWellformed (TypeSym) then
                  ErrorsFound := True;
                  ErrorHandler.SemanticError (47,
                                              1,
                                              NodePosition (NextNode),
                                              LexTokenManager.Null_String);
               end if;
            end if;
         end if;
         Dictionary.AddArrayIndex (TheArrayType       => TheArray,
                                   TheIndexType       => TypeSym,
                                   Comp_Unit          => ContextManager.Ops.CurrentUnit,
                                   IndexTypeReference => Dictionary.Location'(NodePosition (NextNode),
                                                                              NodePosition (NextNode)));
         It := STree.NextNode (It);
      end loop;

   end if;
end wf_array_type_definition;
