-- $Id: sem-compunit-walkstatements-wf_return.adb 11946 2008-12-18 16:11:11Z rod chapman $
--------------------------------------------------------------------------------
-- (C) Altran Praxis Limited
--------------------------------------------------------------------------------
--
-- The SPARK toolset is free software; you can redistribute it and/or modify it
-- under terms of the GNU General Public License as published by the Free
-- Software Foundation; either version 3, or (at your option) any later
-- version. The SPARK toolset is distributed in the hope that it will be
-- useful, but WITHOUT ANY WARRANTY; without even the implied warranty of
-- MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the GNU General
-- Public License for more details. You should have received a copy of the GNU
-- General Public License distributed with the SPARK toolset; see file
-- COPYING3. If not, go to http://www.gnu.org/licenses for a complete copy of
-- the license.
--
--==============================================================================


separate (Sem.CompUnit.WalkStatements)

procedure wf_return (Node  : in STree.SyntaxNode;
                     Scope : in Dictionary.Scopes)
is
   SubProgSym,
   ExpectedType : Dictionary.Symbol;
   ResultType   : ExpRecord;
   LocalNode    : STree.SyntaxNode;
   RefVar       : SeqAlgebra.Seq;

begin
   -- ASSUME Node = return_statement
   -- conditions of Section 5.8 of the SPARK definition apply to this statement.

   SeqAlgebra.CreateSeq (TheHeap, RefVar);
   SubProgSym := Dictionary.GetEnclosingCompilationUnit (Scope);

   if Dictionary.IsProcedure (SubProgSym) then
      ErrorHandler.ControlFlowError (ErrorHandler.ReturnInProc,
                                     NodePosition (Node));

   else --subprogram is a function, check location of return within it;
      LocalNode := ParentOfSequence (Node);
      case SyntaxNodeType (LocalNode) is
         when SPSymbols.if_statement             |
            SPSymbols.elsif_part                 |
            SPSymbols.else_part                  |
            SPSymbols.loop_statement             |
            SPSymbols.case_statement_alternative |
            SPSymbols.others_part =>
            ErrorHandler.ControlFlowError (ErrorHandler.MisplacedReturn,
                                           NodePosition (Node));
         when others =>
            if not IsLastInSequence (Node) then
               ErrorHandler.ControlFlowError (ErrorHandler.MisplacedReturn,
                                              NodePosition (Node));
            end if;
      end case;
      -- seed syntax tree with expected type for run-time check
      ExpectedType := Dictionary.GetType (SubProgSym);
      STree.AddNodeSymbol (Node, ExpectedType);

      -- now check return type is correct
      WalkExpression (ExpNode               => Child_Node (Node),
                      Scope                 => Scope,
                      TypeContext           => ExpectedType,
                      ContextRequiresStatic => False,
                        -- to get
                      Result  => ResultType,
                      RefVar  => RefVar,
                      ComponentData => GlobalComponentData);
      AssignmentCheck (NodePosition (Node),
                       Scope,
                       ExpectedType,
                       ResultType);

      -- if expression represents an IN stream variable then issue warning about
      -- possible validity problems if it is not marked valid
      if ResultType.IsAVariable and then
        Dictionary.GetOwnVariableOrConstituentMode (ResultType.VariableSymbol) =
        Dictionary.InMode then
         -- Check to see if the variable has been marked valid. Note that the
         -- OtherSymbol is checked,not the variableSymbol, since this will be
         -- the Subcomponent symbol if we are referring to a record component
         if Dictionary.VariableOrSubcomponentIsMarkedValid
                     (ResultType.OtherSymbol) then
            --MCA: do we also need to add a use of 'Valid to the summary?
            -- Debug.PrintSym ("Return Access is Valid =", ResultType.OtherSymbol);
            null;
         else
            -- The warning is stronger when the external variable is a type that doesn't
            -- generate run-time checks
            if Dictionary.TypeIsScalar (ResultType.TypeSymbol) and then
              not Dictionary.TypeIsBoolean (ResultType.TypeSymbol) then
               --weaker warning
               ErrorHandler.SemanticWarningSym (392,
                                                NodePosition (Child_Node (Node)),
                                                ResultType.OtherSymbol,
                                                Scope);
            else
               --stronger warning
               ErrorHandler.SemanticWarningSym (393,
                                                NodePosition (Child_Node (Node)),
                                                ResultType.OtherSymbol,
                                                Scope);
            end if;
         end if;
      end if;
   end if;
   -- add reference variable list to RefList hash table
   RefList.AddRelation (Table,
                        TheHeap,
                        Node,
                        Dictionary.NullSymbol,
                        RefVar);
end wf_return;
