-- $Id: sem-compunit-walkstatements-wf_loop_param.adb 15520 2010-01-07 12:53:45Z spark $
--------------------------------------------------------------------------------
-- (C) Altran Praxis Limited
--------------------------------------------------------------------------------
--
-- The SPARK toolset is free software; you can redistribute it and/or modify it
-- under terms of the GNU General Public License as published by the Free
-- Software Foundation; either version 3, or (at your option) any later
-- version. The SPARK toolset is distributed in the hope that it will be
-- useful, but WITHOUT ANY WARRANTY; without even the implied warranty of
-- MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the GNU General
-- Public License for more details. You should have received a copy of the GNU
-- General Public License distributed with the SPARK toolset; see file
-- COPYING3. If not, go to http://www.gnu.org/licenses for a complete copy of
-- the license.
--
--==============================================================================


separate (Sem.CompUnit.WalkStatements)
procedure wf_loop_param (Node  : in STree.SyntaxNode;
                         Scope : in Dictionary.Scopes)
is
   IdentNode,
   TypeNode,
   DirectionNode,
   RangeNode    : STree.SyntaxNode;
   IdentStr     : LexTokenManager.Lex_String;
   TypeSym      : Dictionary.Symbol;
   OkToAdd      : Boolean;
   RangeResult  : ExpRecord;
   RefVar       : SeqAlgebra.Seq;
   LoopParamSym : Dictionary.Symbol;
   Unused       : Maths.Value;
   HasStaticRange : Boolean := True;
   IsReverseLoop  : Boolean;

begin  -- wf_loop_param
   -- assume node=loop_parameter_specification

   SeqAlgebra.CreateSeq (TheHeap, RefVar);
   LoopParamSym := Dictionary.NullSymbol;
   IdentNode := Child_Node (Node);
   IdentStr  := NodeLexString (IdentNode);
   DirectionNode := Next_Sibling (IdentNode);
   TypeNode  := Next_Sibling (DirectionNode);
   RangeNode := Next_Sibling (TypeNode);

   IsReverseLoop := SyntaxNodeType (DirectionNode) = SPSymbols.backward;

   if Dictionary.IsDefined (IdentStr,
                            Scope,
                            Dictionary.ProofContext)
   then
      OkToAdd := False;
      ErrorHandler.SemanticError (10,
                                  ErrorHandler.NoReference,
                                  NodePosition (IdentNode),
                                  IdentStr);
   else
      OkToAdd := True;
   end if;

   wf_type_mark (TypeNode,
                 Scope,
                 Dictionary.ProgramContext,
                  -- to get
                 TypeSym);

   -- plant type for use by VCG
   STree.AddNodeSymbol (TypeNode, TypeSym);


   if not Dictionary.IsUnknownTypeMark (TypeSym) and then
     (not Dictionary.TypeIsDiscrete (TypeSym) or
      Dictionary.IsPrivateType (TypeSym, Scope))
   then
      ErrorHandler.SemanticError (46,
                                  ErrorHandler.NoReference,
                                  NodePosition (TypeNode),
                                  LexTokenManager.Null_String);
   end if;

   if RangeNode /= STree.NullNode then
      WalkExpression (ExpNode               => RangeNode,
                      Scope                 => Scope,
                      TypeContext           => TypeSym,
                      ContextRequiresStatic => False,
                        --to get
                      Result  => RangeResult,
                      RefVar  => RefVar,
                      ComponentData => GlobalComponentData);
      if not Dictionary.IsUnknownTypeMark (RangeResult.TypeSymbol) then
         if not RangeResult.IsARange then
            ErrorHandler.SemanticError (98,
                                        ErrorHandler.NoReference,
                                        NodePosition (RangeNode),
                                        LexTokenManager.Null_String);
         elsif not Dictionary.CompatibleTypes (Scope,
                                               TypeSym,
                                               RangeResult.TypeSymbol)
         then
            ErrorHandler.SemanticError (106,
                                        ErrorHandler.NoReference,
                                        NodePosition (RangeNode),
                                        LexTokenManager.Null_String);

         else
            -- determine whether explicit range is statically known
            HasStaticRange := not (Maths.HasNoValue (RangeResult.Value) or else
                                     Maths.HasNoValue (RangeResult.RangeRHS));
            -- static range check of any explicit range
            --# accept Flow, 10, Unused, "Expected ineffective assignment";
            ConstraintCheck (Val          => RangeResult.Value,
                             NewVal       => Unused,
                             IsAnnotation => False,
                             Typ          => TypeSym,
                             Position     => NodePosition (RangeNode));
            ConstraintCheck (Val          => RangeResult.RangeRHS,
                             NewVal       => Unused,
                             IsAnnotation => False,
                             Typ          => TypeSym,
                             Position     => NodePosition (RangeNode));
            --# end accept;
         end if;
      end if;
   end if;

   if OkToAdd then
      Dictionary.AddLoopParameter (TheLoop       => Dictionary.GetRegion (Scope),
                                   Comp_Unit     => ContextManager.Ops.CurrentUnit,
                                   Declaration   => Dictionary.Location'(NodePosition (IdentNode),
                                                                         NodePosition (IdentNode)),
                                   Name          => IdentStr,
                                   TypeMark      => TypeSym,
                                   StaticRange   => HasStaticRange,
                                   IsReverse     => IsReverseLoop,
                                   TypeReference => Dictionary.Location'(NodePosition (Node),
                                                                         NodePosition (Node)));

      LoopParamSym := Dictionary.GetLoopParameter (Dictionary.GetRegion (Scope));
   end if;
   -- add reference variable list to RefList hash table
   RefList.AddRelation (Table,
                        TheHeap,
                        Node,
                        LoopParamSym,
                        RefVar);
   --# accept Flow, 33, Unused, "Expected to be neither referenced nor exported";
end wf_loop_param;
