-- $Id: sem-compunit-walkstatements-up_loop.adb 15520 2010-01-07 12:53:45Z spark $
--------------------------------------------------------------------------------
-- (C) Altran Praxis Limited
--------------------------------------------------------------------------------
--
-- The SPARK toolset is free software; you can redistribute it and/or modify it
-- under terms of the GNU General Public License as published by the Free
-- Software Foundation; either version 3, or (at your option) any later
-- version. The SPARK toolset is distributed in the hope that it will be
-- useful, but WITHOUT ANY WARRANTY; without even the implied warranty of
-- MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the GNU General
-- Public License for more details. You should have received a copy of the GNU
-- General Public License distributed with the SPARK toolset; see file
-- COPYING3. If not, go to http://www.gnu.org/licenses for a complete copy of
-- the license.
--
--==============================================================================


separate (Sem.CompUnit.WalkStatements)

procedure up_loop (Node  : in     STree.SyntaxNode;
                   Scope : in out Dictionary.Scopes)
is
   -- On entry, NodeType (Node) = loop_statement

   FirstIdentNode,
   SecondIdentNode  : STree.SyntaxNode;
   LocalNode        : STree.SyntaxNode;
   EndlessLoopError : Boolean := False;


   function PositionToReportError (Node : STree.SyntaxNode)
                                  return LexTokenManager.Token_Position
   --# global in STree.Table;
   is
      LocalNode : STree.SyntaxNode;
   begin
      LocalNode := Child_Node (Node);
      if SyntaxNodeType (LocalNode) = SPSymbols.simple_name then
         -- loop has a name
         LocalNode := LastSiblingOf (LocalNode); -- closing name location
      else
         -- loop has no name, find last statement in sequence of statements
         LocalNode := Child_Node (Next_Sibling (LocalNode));
         -- LocalNode is either a Statement (which is the only one in the sequence)
         -- or it's a sequence_of_statements in which case the last statement is to it's right
         if SyntaxNodeType (LocalNode) = SPSymbols.sequence_of_statements then
            LocalNode := Next_Sibling (LocalNode);
         end if;
      end if;
      return NodePosition (LocalNode);
   end PositionToReportError;

begin
   FirstIdentNode := Child_Node (Node);
   if SyntaxNodeType (FirstIdentNode) = SPSymbols.simple_name then
      SecondIdentNode := Child_Node (LastSiblingOf (FirstIdentNode));
      FirstIdentNode := Child_Node (FirstIdentNode);
      if LexTokenManager.Lex_String_Case_Insensitive_Compare (Lex_Str1 => NodeLexString (FirstIdentNode),
                                                              Lex_Str2 => NodeLexString (SecondIdentNode)) /= LexTokenManager.Str_Eq then
         ErrorHandler.SemanticError (58,
                                     ErrorHandler.NoReference,
                                     NodePosition (SecondIdentNode),
                                     NodeLexString (FirstIdentNode));
      end if;
   end if;

   -- Make checks that any loops without exits are the last statement of the main prgoram
   -- or task body.
   -- We may need to allow a proof statement or pragma to follow and infinite loop (and, perhaps
   -- a null statement) but for now we allow nothing to follow.

   if not Dictionary.GetLoopHasExits (Dictionary.GetRegion (Scope)) then
      -- Loop is infinite, checks are required
      -- First check that it is main program or in task type
      if not (Dictionary.IsMainProgram (Dictionary.GetRegion (Dictionary.GetEnclosingScope (Scope))) or else
        Dictionary.IsTaskType (Dictionary.GetRegion (Dictionary.GetEnclosingScope (Scope)))) then
         EndlessLoopError := True;
      else
         LocalNode := ParentOfSequence (Node);
         case SyntaxNodeType (LocalNode) is
            when SPSymbols.if_statement             |
               SPSymbols.elsif_part                 |
               SPSymbols.else_part                  |
               SPSymbols.loop_statement             |
               SPSymbols.case_statement_alternative |
               SPSymbols.others_part =>
               EndlessLoopError := True;

            when others =>
               if not IsLastInSequence (Node) then
                  EndlessLoopError := True;
               end if;
         end case;
      end if;
      if EndlessLoopError then
         ErrorHandler.SemanticError (730,
                                     ErrorHandler.NoReference,
                                     PositionToReportError (Node),
                                     LexTokenManager.Null_String);
      end if;
   end if;

   -- move out of loop scope
   Scope := Dictionary.GetEnclosingScope (Scope);

end up_loop;
