-- $Id: sem-compunit-walkstatements-up_case.adb 15520 2010-01-07 12:53:45Z spark $
--------------------------------------------------------------------------------
-- (C) Altran Praxis Limited
--------------------------------------------------------------------------------
--
-- The SPARK toolset is free software; you can redistribute it and/or modify it
-- under terms of the GNU General Public License as published by the Free
-- Software Foundation; either version 3, or (at your option) any later
-- version. The SPARK toolset is distributed in the hope that it will be
-- useful, but WITHOUT ANY WARRANTY; without even the implied warranty of
-- MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the GNU General
-- Public License for more details. You should have received a copy of the GNU
-- General Public License distributed with the SPARK toolset; see file
-- COPYING3. If not, go to http://www.gnu.org/licenses for a complete copy of
-- the license.
--
--==============================================================================


separate (Sem.CompUnit.WalkStatements)

procedure up_case (Node : in STree.SyntaxNode)
is
   Unused1      : Dictionary.Symbol;
   CaseFlags    : TypCaseFlags;
   Unused2      : TypTypeBound;
   Unused3      : TypTypeBound;
   CompleteADT  : CompleteCheck.T;
   OthersFound  : Boolean;
begin
   -- ASSUME Node = case_statement
   --# accept Flow, 10, Unused1, "Expected ineffective assignment" &
   --#        Flow, 10, Unused2, "Expected ineffective assignment" &
   --#        Flow, 10, Unused3, "Expected ineffective assignment";
   CaseStack.Pop (CaseFlags,         -- 3 flow errors expected
                  CompleteADT,
                  Unused1,
                  Unused2,
                  Unused3);
   --# end accept;

   -- if there is an others clause record the fact and inform ADT
   if Child_Node (Next_Sibling (Next_Sibling (Child_Node (Node)))) /=
      STree.NullNode
   then
      OthersFound := True;
      -- check to see if case was already complete before others found
      if CaseFlags.CheckCompleteness and then
         CompleteCheck.IsComplete (CompleteADT) = CompleteCheck.Complete
      then
         ErrorHandler.SemanticWarning (11,
                                       NodePosition
                                         (Child_Node
                                            (Next_Sibling
                                               (Next_Sibling
                                                  (Child_Node (Node))))),
                                       LexTokenManager.Null_String);
      end if;
      -- now signal "others found"  to completeness checker
      CompleteCheck.SeenOthers (CompleteADT);
   else
      OthersFound := False;
   end if;

   if CaseFlags.CheckCompleteness then
      if CompleteADT.Undeterminable and
        not OthersFound then
         ErrorHandler.SemanticWarning (304,
                                       NodePosition (Node),
                                       LexTokenManager.Null_String);

      elsif CompleteCheck.IsComplete (CompleteADT) = CompleteCheck.Incomplete then
         ErrorHandler.SemanticError (408,
                                     ErrorHandler.NoReference,
                                     NodePosition (Node),
                                     LexTokenManager.Null_String);
      end if;
   end if;

   if CaseFlags.SignalOutOfRange and CaseFlags.OutOfRangeSeen then
      ErrorHandler.SemanticWarning (303,
                                    NodePosition (Node),
                                    LexTokenManager.Null_String);
   end if;

   if CaseFlags.WarnNoOthers and
     not OthersFound and
     not (CaseFlags.CheckCompleteness and    -- don't output
            CompleteADT.Undeterminable)      -- 304 twice.
   then
      ErrorHandler.SemanticWarning (304,
                                    NodePosition (Node),
                                    LexTokenManager.Null_String);
   end if;

   if CaseFlags.OthersMandatory and not OthersFound then
      ErrorHandler.SemanticError (411,
                                  ErrorHandler.NoReference,
                                  NodePosition (Node),
                                  LexTokenManager.Null_String);
   end if;
   --# accept Flow, 33, Unused1, "Expected to be neither referenced nor exported" &
   --#        Flow, 33, Unused2, "Expected to be neither referenced nor exported" &
   --#        Flow, 33, Unused3, "Expected to be neither referenced nor exported";
end up_case;
