-- $Id: sem-compunit-up_wf_store.adb 15674 2010-01-20 16:17:20Z spark $
--------------------------------------------------------------------------------
-- (C) Altran Praxis Limited
--------------------------------------------------------------------------------
--
-- The SPARK toolset is free software; you can redistribute it and/or modify it
-- under terms of the GNU General Public License as published by the Free
-- Software Foundation; either version 3, or (at your option) any later
-- version. The SPARK toolset is distributed in the hope that it will be
-- useful, but WITHOUT ANY WARRANTY; without even the implied warranty of
-- MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the GNU General
-- Public License for more details. You should have received a copy of the GNU
-- General Public License distributed with the SPARK toolset; see file
-- COPYING3. If not, go to http://www.gnu.org/licenses for a complete copy of
-- the license.
--
--==============================================================================


separate (Sem.CompUnit)

procedure up_wf_store (Node   : in     STree.SyntaxNode;
                       Scope  : in     Dictionary.Scopes;
                       EStack : in out ExpStack.ExpStackType)
is
   TypeInfo,
   ExpResult      : ExpRecord;
   Sym            : Dictionary.Symbol;
   FieldIdentNode : STree.SyntaxNode;
   FieldIdent     : LexTokenManager.Lex_String;
   FieldSymbol    : Dictionary.Symbol;
   ErrorFound : Boolean := False;

   function BranchesFound (StartNode,
                           EndNode   : STree.SyntaxNode) return Boolean
   --# global in STree.Table;
   is
      NextNode : STree.SyntaxNode;
      result : Boolean;

   begin
      result := False;
      NextNode := ParentNode (StartNode);
      while NextNode /= EndNode loop
         if Next_Sibling (NextNode) /= STree.NullNode then
            result := True;
            exit;
         end if;
         NextNode := ParentNode (NextNode);
      end loop;
      return result;
   end BranchesFound;

   ----------------------------------------------------

begin
   ExpStack.Pop (ExpResult, EStack);
   ExpStack.Pop (TypeInfo, EStack);
   Sym := TypeInfo.OtherSymbol;

   if Dictionary.IsArrayTypeMark (TypeInfo.TypeSymbol, Scope) then
      if TypeInfo.ParamCount =
         Dictionary.GetNumberOfDimensions (TypeInfo.TypeSymbol)
      then
         --right number of index expressions so just check type check needed
         if not Dictionary.CompatibleTypes
            (Scope,
             Dictionary.GetArrayComponent (TypeInfo.TypeSymbol),
             ExpResult.TypeSymbol)
         then
            ErrorFound := True;
            ErrorHandler.SemanticError (38,
                                        ErrorHandler.NoReference,
                                        NodePosition
                                        (Next_Sibling (Child_Node (Node))),
                                        LexTokenManager.Null_String);
         end if;
      else
         --insufficient index expressions
         TypeInfo := UnknownSymbolRecord;
         ErrorHandler.SemanticError (93,
                                     ErrorHandler.NoReference,
                                     NodePosition (Node),
                                     Dictionary.GetSimpleName (Sym));
      end if;

   else --must be record
      --multiple field name check
      if SyntaxNodeType (Child_Node (Child_Node (Node))) = SPSymbols.store_list then
         ErrorFound := True;
         ErrorHandler.SemanticError (324,
                                     ErrorHandler.NoReference,
                                     NodePosition (Node),
                                     LexTokenManager.Null_String);
      else
         FieldIdentNode := LastChildOf (Node);
         if SyntaxNodeType (FieldIdentNode) = SPSymbols.identifier then
            if BranchesFound (FieldIdentNode,
                              Child_Node (Node))
            then
               ErrorFound := True;
               ErrorHandler.SemanticError (102,
                                           ErrorHandler.NoReference, --field name expected
                                           NodePosition (FieldIdentNode),
                                           Dictionary.GetSimpleName (TypeInfo.OtherSymbol));
            else
               FieldIdent := NodeLexString (FieldIdentNode);
               FieldSymbol := Dictionary.LookupSelectedItem (Prefix   => TypeInfo.TypeSymbol,
                                                             Selector => FieldIdent,
                                                             Scope    => Scope,
                                                             Context  => Dictionary.ProofContext);
               if FieldSymbol = Dictionary.NullSymbol or else
                 not Dictionary.IsRecordComponent (FieldSymbol) then
                  --no such field
                  ErrorFound := True;
                  ErrorHandler.SemanticError (8,
                                              ErrorHandler.NoReference,
                                              NodePosition (FieldIdentNode),
                                              FieldIdent);
               else --field name exists so type check of result assigned to it required
                  if Dictionary.CompatibleTypes (Scope,
                                                 Dictionary.GetType (FieldSymbol),
                                                 ExpResult.TypeSymbol) then
                     STree.Set_Node_Lex_String (Sym  => FieldSymbol,
                                                Node => FieldIdentNode);
                  else
                     ErrorFound := True;
                     ErrorHandler.SemanticError (38,
                                                 ErrorHandler.NoReference,
                                                 NodePosition
                                                 (Next_Sibling
                                                  (Child_Node (Node))),
                                                 LexTokenManager.Null_String);
                  end if;
               end if;
            end if;
         else --identifier not found
            ErrorFound := True;
            ErrorHandler.SemanticError (102,
                                        ErrorHandler.NoReference, --field name expected
                                        NodePosition (FieldIdentNode),
                                        Dictionary.GetSimpleName (TypeInfo.OtherSymbol));
         end if;
      end if;
   end if;
   TypeInfo.ErrorsInExpression := ErrorFound or
      TypeInfo.ErrorsInExpression or
      ExpResult.ErrorsInExpression;
   ExpStack.Push (TypeInfo, EStack);

end up_wf_store;
