-- $Id: sem-compunit-up_wf_quantifier.adb 15674 2010-01-20 16:17:20Z spark $
--------------------------------------------------------------------------------
-- (C) Altran Praxis Limited
--------------------------------------------------------------------------------
--
-- The SPARK toolset is free software; you can redistribute it and/or modify it
-- under terms of the GNU General Public License as published by the Free
-- Software Foundation; either version 3, or (at your option) any later
-- version. The SPARK toolset is distributed in the hope that it will be
-- useful, but WITHOUT ANY WARRANTY; without even the implied warranty of
-- MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the GNU General
-- Public License for more details. You should have received a copy of the GNU
-- General Public License distributed with the SPARK toolset; see file
-- COPYING3. If not, go to http://www.gnu.org/licenses for a complete copy of
-- the license.
--
--==============================================================================

separate (Sem.CompUnit)

procedure up_wf_quantifier (Node   : in     STree.SyntaxNode;
                            Estack : in out ExpStack.ExpStackType;
                            Scope  : in out Dictionary.Scopes)
is
   ErrorsFound,
   RangeFound      : Boolean;
   RangeNode       : STree.SyntaxNode;
   PredicateResult,
   RangeResult     : ExpRecord;
   QuantifierType  : Dictionary.Symbol;
begin --up_wf_quantifier

   -- Node is quantified_expression
   -- top of Estack is predicate data
   -- 2nd tos Estack is range info iff a range node exists

   RangeNode  := Next_Sibling (Next_Sibling
                                     (Next_Sibling
                                      (Child_Node (Node))));
   RangeFound := SyntaxNodeType (RangeNode) = SPSymbols.annotation_arange;

   ExpStack.Pop (PredicateResult, Estack); --result of predicate node
   ErrorsFound := PredicateResult.ErrorsInExpression;
   if  not Dictionary.IsBooleanTypeMark (PredicateResult.TypeSymbol) then --error case
      ErrorsFound := True;
      ErrorHandler.SemanticError (326,
                                  ErrorHandler.NoReference,
                                  NodePosition
                                  (LastSiblingOf
                                   (Child_Node (Node))), --predicate node
                                  LexTokenManager.Null_String);
   end if;

   --if the arange node exists there will be other stuff on the stack here
   if RangeFound then
      ExpStack.Pop (RangeResult, Estack);
      ErrorsFound := ErrorsFound or RangeResult.ErrorsInExpression;

      QuantifierType := Dictionary.GetType (Dictionary.GetRegion (Scope));

      -- If the quantifier is over Boolean or a subtype of Boolean, then
      -- an explicit range is illegal.
      if Dictionary.TypeIsBoolean (QuantifierType) then
         ErrorHandler.SemanticError (412,
                                     ErrorHandler.NoReference,
                                     NodePosition (RangeNode),
                                     LexTokenManager.Null_String);

      elsif not RangeResult.IsARange then
         ErrorsFound := True;
         ErrorHandler.SemanticError (98,
                                     ErrorHandler.NoReference,
                                     NodePosition (RangeNode),
                                     LexTokenManager.Null_String);
      elsif not Dictionary.CompatibleTypes (Scope,
                                            QuantifierType,
                                            RangeResult.TypeSymbol)
      then
         ErrorsFound := True;
         ErrorHandler.SemanticError (106,
                                     ErrorHandler.NoReference,
                                     NodePosition (RangeNode),
                                     LexTokenManager.Null_String);
      end if;
   end if;

   -- turn result into a Boolean type result
   ExpStack.Push (ExpRecord'(TypeSymbol            => Dictionary.GetPredefinedBooleanType,
                             OtherSymbol           => Dictionary.NullSymbol,
                             StreamSymbol          => Dictionary.NullSymbol,
                             TaggedParameterSymbol => Dictionary.NullSymbol,
                             VariableSymbol        => Dictionary.NullSymbol,
                             ParamCount            => 0,
                             ParamList             => Lists.Null_List,
                             Sort                  => TypeResult,
                             ArgListFound          => False,
                             IsAVariable           => False,
                             IsAnEntireVariable    => False,
                             ErrorsInExpression    => ErrorsFound,
                             HasOperators          => False,
                             IsConstant            => False,
                             IsStatic              => False,
                             IsARange              => False,
                             Value                 => Maths.NoValue,
                             RangeRHS              => Maths.NoValue),
                  Estack);
   -- leave local scope of quantifier
   Scope := Dictionary.GetEnclosingScope (Scope);
end up_wf_quantifier;
