-- $Id: sem-compunit-up_wf_named_record_component_association.adb 15520 2010-01-07 12:53:45Z spark $
--------------------------------------------------------------------------------
-- (C) Altran Praxis Limited
--------------------------------------------------------------------------------
--
-- The SPARK toolset is free software; you can redistribute it and/or modify it
-- under terms of the GNU General Public License as published by the Free
-- Software Foundation; either version 3, or (at your option) any later
-- version. The SPARK toolset is distributed in the hope that it will be
-- useful, but WITHOUT ANY WARRANTY; without even the implied warranty of
-- MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the GNU General
-- Public License for more details. You should have received a copy of the GNU
-- General Public License distributed with the SPARK toolset; see file
-- COPYING3. If not, go to http://www.gnu.org/licenses for a complete copy of
-- the license.
--
--==============================================================================


separate (Sem.CompUnit)

procedure up_wf_named_record_component_association (Node         : in     STree.SyntaxNode;
                                                    Scope        : in     Dictionary.Scopes;
                                                    EStack       : in out ExpStack.ExpStackType;
                                                    HeapParam    : in out Lists.List_Heap)
is
   NameExp,
   FieldName,
   ExpResult      : ExpRecord;
   ExpectedType   : Dictionary.Symbol;
   ErrorFound     : Boolean := False;

   function ExpressionLocation return STree.SyntaxNode
   --# global in Node;
   --#        in STree.Table;
   --  pre SyntaxNodeType (Node) = SPSymbols.named_record_component_association or
   --      SyntaxNodeType (Node) = SPSymbols.annotation_named_record_component_association;
   is
      LocalNode : STree.SyntaxNode;
   begin
      LocalNode := Child_Node (Node);
      if SyntaxNodeType (LocalNode) /= SPSymbols.record_component_selector_name then
         LocalNode := Next_Sibling (LocalNode);
      end if;
      return Next_Sibling (LocalNode);
   end ExpressionLocation;

   --------------------------------------------

   procedure CheckRecordCompleteness (NameExp : in out ExpRecord)
   --# global in     CommandLineData.Content;
   --#        in     Dictionary.Dict;
   --#        in     LexTokenManager.State;
   --#        in     Node;
   --#        in     STree.Table;
   --#        in out ErrorFound;
   --#        in out ErrorHandler.ErrorContext;
   --#        in out HeapParam;
   --#        in out SPARK_IO.File_Sys;
   --# derives ErrorFound                from *,
   --#                                        Dictionary.Dict,
   --#                                        HeapParam,
   --#                                        LexTokenManager.State,
   --#                                        NameExp &
   --#         ErrorHandler.ErrorContext,
   --#         SPARK_IO.File_Sys         from CommandLineData.Content,
   --#                                        Dictionary.Dict,
   --#                                        ErrorHandler.ErrorContext,
   --#                                        HeapParam,
   --#                                        LexTokenManager.State,
   --#                                        NameExp,
   --#                                        Node,
   --#                                        SPARK_IO.File_Sys,
   --#                                        STree.Table &
   --#         NameExp                   from * &
   --#         HeapParam                 from *,
   --#                                        LexTokenManager.State,
   --#                                        NameExp;
   is
      FieldStr  : LexTokenManager.Lex_String;
      ErrorPos  : LexTokenManager.Token_Position;
      Ptr       : Lists.List;
   begin
      ErrorPos := NodePosition (ExpressionLocation);
      for I in Positive range
        Dictionary.GetNumberOfComponents (NameExp.OtherSymbol) + 1 ..    -- ancestor field count
        Dictionary.GetNumberOfComponents (NameExp.TypeSymbol) loop       -- total field count

         FieldStr := Dictionary.GetSimpleName (Dictionary.GetRecordComponent (NameExp.TypeSymbol, I));
         if not Lists.Is_Member (Heap     => HeapParam,
                                 The_List => NameExp.ParamList,
                                 Str      => FieldStr) then
            ErrorFound := True;
            ErrorHandler.SemanticError (104,
                                        ErrorHandler.NoReference,
                                        ErrorPos,
                                        FieldStr);
         end if;
      end loop;
      Ptr := NameExp.ParamList;
      DisposeOfNameList (Ptr, HeapParam);
      NameExp.ParamList := Ptr;
   end CheckRecordCompleteness;

   -------------------------------------------------------------

begin
   -- TOS is the result of walking an expression to be associated with a record field name
   -- 2nd TOS is the field name in a parameter record
   -- 3rd TOS is the aggregate type with the ancestor type in its OtherSymbol field

   ExpStack.Pop (ExpResult, EStack);
   ExpStack.Pop (FieldName, EStack);
   ExpStack.Pop (NameExp, EStack);

   if FieldName.OtherSymbol = Dictionary.NullSymbol then
      null;

   else
      ExpectedType := Dictionary.GetType (FieldName.OtherSymbol);
      STree.AddNodeSymbol (Node,
                                       ExpectedType);
      AssignmentCheck (NodePosition (ExpressionLocation),
                       Scope,
                       ExpectedType,
                       ExpResult);
      NameExp.IsConstant := NameExp.IsConstant and ExpResult.IsConstant;

      if Next_Sibling (Node) =
        STree.NullNode
      then
         --this is the last named association so we need to check that
         --all fields have been given a value
         CheckRecordCompleteness (NameExp);
      end if;
   end if;
   NameExp.ErrorsInExpression := ErrorFound or
     NameExp.ErrorsInExpression or
     ExpResult.ErrorsInExpression;
   ExpStack.Push (NameExp, EStack);
end up_wf_named_record_component_association;
