-- $Id: sem-compunit-up_wf_name_argument_list.adb 15520 2010-01-07 12:53:45Z spark $
--------------------------------------------------------------------------------
-- (C) Altran Praxis Limited
--------------------------------------------------------------------------------
--
-- The SPARK toolset is free software; you can redistribute it and/or modify it
-- under terms of the GNU General Public License as published by the Free
-- Software Foundation; either version 3, or (at your option) any later
-- version. The SPARK toolset is distributed in the hope that it will be
-- useful, but WITHOUT ANY WARRANTY; without even the implied warranty of
-- MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the GNU General
-- Public License for more details. You should have received a copy of the GNU
-- General Public License distributed with the SPARK toolset; see file
-- COPYING3. If not, go to http://www.gnu.org/licenses for a complete copy of
-- the license.
--
--==============================================================================


separate (Sem.CompUnit)

procedure up_wf_name_argument_list (Node         : in     STree.SyntaxNode;
                                    EStack       : in out ExpStack.ExpStackType;
                                    HeapParam    : in out Lists.List_Heap;
                                    IsAnnotation : in     Boolean)
is
   POS_ASSOC_LOOKUP : constant Annotation_Symbol_Table :=
      Annotation_Symbol_Table'(False => SPSymbols.positional_argument_association,
                               True  => SPSymbols.annotation_positional_argument_association);

   TypeInfo : ExpRecord;
   Sym      : Dictionary.Symbol;
   AllFound : Boolean;
   Ptr      : Lists.List;

   UnusedValue : Maths.Value;

   -----------------------------------------------------------------------

   procedure CheckNamesAreAllThere (Node     : in     STree.SyntaxNode;
                                    FunSym   : in     Dictionary.Symbol;
                                    List     : in     Lists.List;
                                    AllThere :    out Boolean)
   --# global in     CommandLineData.Content;
   --#        in     Dictionary.Dict;
   --#        in     HeapParam;
   --#        in     LexTokenManager.State;
   --#        in     STree.Table;
   --#        in out ErrorHandler.ErrorContext;
   --#        in out SPARK_IO.File_Sys;
   --# derives AllThere                  from Dictionary.Dict,
   --#                                        FunSym,
   --#                                        HeapParam,
   --#                                        LexTokenManager.State,
   --#                                        List &
   --#         ErrorHandler.ErrorContext,
   --#         SPARK_IO.File_Sys         from CommandLineData.Content,
   --#                                        Dictionary.Dict,
   --#                                        ErrorHandler.ErrorContext,
   --#                                        FunSym,
   --#                                        HeapParam,
   --#                                        LexTokenManager.State,
   --#                                        List,
   --#                                        Node,
   --#                                        SPARK_IO.File_Sys,
   --#                                        STree.Table;
   is
      It : Dictionary.Iterator;
      ParamStr : LexTokenManager.Lex_String;

   begin
      AllThere := True;
      It := Dictionary.FirstSubprogramParameter (FunSym);
      while not Dictionary.IsNullIterator (It) loop
         ParamStr := Dictionary.GetSimpleName (Dictionary.CurrentSymbol (It));
         if not Lists.Is_Member (Heap     => HeapParam,
                                 The_List => List,
                                 Str      => ParamStr) then
            AllThere := False;
            ErrorHandler.SemanticError (23,
                                        ErrorHandler.NoReference,
                                        NodePosition (Node),
                                        ParamStr);
         end if;

         It := Dictionary.NextSymbol (It);
      end loop;
   end CheckNamesAreAllThere;

   -----------------------------------------------------------------------

begin --up_wf_name_argument_list
   ExpStack.Pop (TypeInfo, EStack);
   Sym := TypeInfo.OtherSymbol;


   case TypeInfo.Sort is
      when IsFunction =>
         if SyntaxNodeType (Child_Node (Node)) =
            POS_ASSOC_LOOKUP (IsAnnotation)
         then
            if TypeInfo.ParamCount =
               Dictionary.GetNumberOfSubprogramParameters (Sym)
            then
               TypeInfo.Sort := IsObject;
            else
               TypeInfo := UnknownSymbolRecord;
               ErrorHandler.SemanticError (3,
                                           ErrorHandler.NoReference,
                                           NodePosition (Node),
                                           Dictionary.GetSimpleName (Sym));
            end if;

         else  --named association checks needed
            CheckNamesAreAllThere (Node,
                                   Sym,
                                   TypeInfo.ParamList,
                                    --to get
                                   AllFound);
            Ptr := TypeInfo.ParamList;
            DisposeOfNameList (Ptr, HeapParam);
            TypeInfo.ParamList := Ptr;
            if AllFound then
               TypeInfo.Sort := IsObject;
            else
               TypeInfo := UnknownSymbolRecord;
            end if;
         end if;

      when IsObject =>
         if TypeInfo.ParamCount =
            Dictionary.GetNumberOfDimensions (TypeInfo.TypeSymbol)
         then
            TypeInfo.TypeSymbol :=
               Dictionary.GetArrayComponent (TypeInfo.TypeSymbol);
            if not IsAnnotation then
               TypeInfo.IsAnEntireVariable := False;
            end if;
            TypeInfo.IsConstant := False;
         else
            TypeInfo := UnknownSymbolRecord;
            ErrorHandler.SemanticError (93,
                                        ErrorHandler.NoReference,
                                        NodePosition (Node),
                                        Dictionary.GetSimpleName (Sym));
         end if;

      when TypeResult =>
         -- Must be a type conversion expression.

         -- If the type is scalar, and the argument is static, then
         -- we can do a ConstraintCheck here in SPARK95 or 2005 modes.
         -- Type conversions are never considered static in SPARK83,
         -- so we've no business checking them here in SPARK83 mode.
         if CommandLineData.Content.LanguageProfile /= CommandLineData.SPARK83 and then
           TypeInfo.IsStatic and then
           Dictionary.TypeIsScalar (TypeInfo.TypeSymbol) then

            --# accept F, 10, UnusedValue, "UnusedValue not needed here.";
            ConstraintCheck (Val          => TypeInfo.Value,
                             NewVal       => UnusedValue,
                             IsAnnotation => IsAnnotation,
                             Typ          => TypeInfo.TypeSymbol,
                             Position     => NodePosition (Node));
            --# end accept;
         end if;

      when others =>
         null;
   end case;

   ExpStack.Push (TypeInfo, EStack);

   --# accept F, 33, UnusedValue, "UnusedValue not needed here.";
end up_wf_name_argument_list;
