-- $Id: sem-compunit-up_wf_component_association.adb 11354 2008-10-06 17:02:56Z Bill Ellis $
--------------------------------------------------------------------------------
-- (C) Altran Praxis Limited
--------------------------------------------------------------------------------
--
-- The SPARK toolset is free software; you can redistribute it and/or modify it
-- under terms of the GNU General Public License as published by the Free
-- Software Foundation; either version 3, or (at your option) any later
-- version. The SPARK toolset is distributed in the hope that it will be
-- useful, but WITHOUT ANY WARRANTY; without even the implied warranty of
-- MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the GNU General
-- Public License for more details. You should have received a copy of the GNU
-- General Public License distributed with the SPARK toolset; see file
-- COPYING3. If not, go to http://www.gnu.org/licenses for a complete copy of
-- the license.
--
--==============================================================================


separate (Sem.CompUnit)

procedure up_wf_component_association (Node         : in     STree.SyntaxNode;
                                       Scope        : in     Dictionary.Scopes;
                                       EStack       : in out ExpStack.ExpStackType;
                                       IsAnnotation : in     Boolean)
is
   AGG_LOOKUP : constant Annotation_Symbol_Table :=
      Annotation_Symbol_Table'(False => SPSymbols.aggregate,
                               True  => SPSymbols.annotation_aggregate);
   POS_ASS_LOOKUP : constant Annotation_Symbol_Table :=
      Annotation_Symbol_Table'(False => SPSymbols.positional_association,
                               True  => SPSymbols.annotation_positional_association);
   EXP_LOOKUP : constant Annotation_Symbol_Table :=
      Annotation_Symbol_Table'(False => SPSymbols.expression,
                               True  => SPSymbols.annotation_expression);

   NameExp,
   ExpResult       : ExpRecord;
   OthersNode      : STree.SyntaxNode;
   HasOthersClause : Boolean;
   ExpectedType    : Dictionary.Symbol;

   ---------------------------------------------------------

   function DoingEmbeddedAggregate (Node : STree.SyntaxNode) return Boolean
   --# global in IsAnnotation;
   --#        in STree.Table;
   is
   begin
      return SyntaxNodeType
         (Child_Node
          (Next_Sibling
           (Child_Node
            (Child_Node (Node))))) = AGG_LOOKUP (IsAnnotation);
   end DoingEmbeddedAggregate;

   ---------------------------------------------------------

begin -- up_wf_component_association
      --check for positional_association in which case we do nothing
      --neither do we do anything if others part is an embedded aggregate
   if (not DoingEmbeddedAggregate (Node)) and then
      SyntaxNodeType (Child_Node (Node)) /= POS_ASS_LOOKUP (IsAnnotation) then
      OthersNode :=  Child_Node (Child_Node (Node));
      if SyntaxNodeType (OthersNode) = EXP_LOOKUP (IsAnnotation) then
         HasOthersClause := True;
      else
         OthersNode := Child_Node (Next_Sibling (OthersNode));
         if SyntaxNodeType (OthersNode) = EXP_LOOKUP (IsAnnotation) then
            HasOthersClause := True;
         else
            HasOthersClause := False;
         end if;
      end if;

      if HasOthersClause then
         ExpStack.Pop (ExpResult, EStack);
         ExpStack.Pop (NameExp, EStack);
         if Dictionary.IsUnknownTypeMark (NameExp.TypeSymbol) then
            NameExp.ErrorsInExpression := True;
         elsif Dictionary.TypeIsArray (NameExp.TypeSymbol) then
            ExpectedType := Dictionary.GetArrayComponent (NameExp.TypeSymbol);
            AssignmentCheck (NodePosition (OthersNode),
                             Scope,
                             ExpectedType,
                             ExpResult);
            NameExp.IsStatic := False;
            NameExp.IsConstant := NameExp.IsConstant and ExpResult.IsConstant;
            STree.AddNodeSymbol (Node,
                                             ExpectedType);
         end if;
         NameExp.ErrorsInExpression := NameExp.ErrorsInExpression or
            ExpResult.ErrorsInExpression;
         ExpStack.Push (NameExp, EStack);
      end if;
   end if;
end up_wf_component_association;
