-- $Id: sem-compunit-up_wf_aggregate_or_expression.adb 12351 2009-02-02 15:03:51Z Rod Chapman $
--------------------------------------------------------------------------------
-- (C) Altran Praxis Limited
--------------------------------------------------------------------------------
--
-- The SPARK toolset is free software; you can redistribute it and/or modify it
-- under terms of the GNU General Public License as published by the Free
-- Software Foundation; either version 3, or (at your option) any later
-- version. The SPARK toolset is distributed in the hope that it will be
-- useful, but WITHOUT ANY WARRANTY; without even the implied warranty of
-- MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the GNU General
-- Public License for more details. You should have received a copy of the GNU
-- General Public License distributed with the SPARK toolset; see file
-- COPYING3. If not, go to http://www.gnu.org/licenses for a complete copy of
-- the license.
--
--==============================================================================


separate (Sem.CompUnit)

procedure up_wf_aggregate_or_expression (Node         : in out STree.SyntaxNode;
                                         Scope        : in     Dictionary.Scopes;
                                         EStack       : in out ExpStack.ExpStackType;
                                         IsAnnotation : in     Boolean)
is
   EXPR_LOOKUP : constant Annotation_Symbol_Table :=
      Annotation_Symbol_Table'(False => SPSymbols.expression,
                               True  => SPSymbols.annotation_expression);
   CA_LOOKUP : constant Annotation_Symbol_Table :=
      Annotation_Symbol_Table'(False => SPSymbols.component_association,
                               True  => SPSymbols.annotation_component_association);
   PA_LOOKUP : constant Annotation_Symbol_Table :=
      Annotation_Symbol_Table'(False => SPSymbols.positional_association,
                               True  => SPSymbols.annotation_positional_association);
   PA_REP_LOOKUP : constant Annotation_Symbol_Table :=
      Annotation_Symbol_Table'(False => SPSymbols.positional_association_rep,
                               True  => SPSymbols.annotation_positional_association_rep);

   Parent          : SPSymbols.SPSymbol;
   NameExp,
   ExpResult       : ExpRecord;
   ExpectedType    : Dictionary.Symbol;
   IndexTypeSymbol : Dictionary.Symbol;
   TypeLowerBound  : TypTypeBound;
   TypeUpperBound  : TypTypeBound;
   AggregateFlags  : TypAggFlags;
   EntryCounter    : Natural;
   CompleteRec     : CompleteCheck.T;

   --------------------------------------------------------------

   procedure ChainUpToComponentAssociation (Node : in out STree.SyntaxNode)
   --# global in IsAnnotation;
   --#        in STree.Table;
   --# derives Node from *,
   --#                   IsAnnotation,
   --#                   STree.Table;
   is
   begin
      while SyntaxNodeType (Node) /= CA_LOOKUP (IsAnnotation)
      loop
         Node := ParentNode (Node);
      end loop;
   end ChainUpToComponentAssociation;

   -------------------------------------------------------------------

   --type is needed at aggregate_or_expression node except if it associated
   --with an "others" clause in which case it is needed at component_association
   --node; this procedure puts it in the right place
   procedure PlantType (ExpectedType : in Dictionary.Symbol)
   --# global in     IsAnnotation;
   --#        in     Node;
   --#        in     Parent;
   --#        in out STree.Table;
   --# derives STree.Table from *,
   --#                          ExpectedType,
   --#                          IsAnnotation,
   --#                          Node,
   --#                          Parent;
   is
   begin
      if (Parent = PA_LOOKUP (IsAnnotation)) and then
         Next_Sibling (Node) = STree.NullNode
      then --we are dealing with an others clause
         STree.AddNodeSymbol (ParentNode (ParentNode (Node)), ExpectedType);
      else --not an others clause
         STree.AddNodeSymbol (Node, ExpectedType);
      end if;
   end PlantType;

   -------------------------------------------------------------------

begin --up_wf_aggregate_or_expression
   Parent := SyntaxNodeType (ParentNode (Node));
   if SyntaxNodeType (Child_Node (Node)) = EXPR_LOOKUP (IsAnnotation) then -- [anno]expression
      if Parent = PA_REP_LOOKUP (IsAnnotation) or else  -- [anno]pos_ass_rep
         Parent = PA_LOOKUP (IsAnnotation)              -- [anno]pos_ass
      then
         ExpStack.Pop (ExpResult, EStack);
         ExpStack.Pop (NameExp, EStack);

         if Dictionary.IsUnknownTypeMark (NameExp.TypeSymbol) then
            ExpStack.Push (NameExp, EStack);
         elsif Dictionary.TypeIsArray (NameExp.TypeSymbol) then
            ExpectedType :=  Dictionary.GetArrayComponent (NameExp.TypeSymbol);
            PlantType (ExpectedType);
            AssignmentCheck (NodePosition (Child_Node (Node)),
                             Scope,
                             ExpectedType,
                             ExpResult);
            NameExp.IsConstant := NameExp.IsConstant and ExpResult.IsConstant;

            -- if this is not the others clause
            -- increment the entry counter on the aggregate stack
            -- nb: we already know that it's positional association here
            if Parent = PA_REP_LOOKUP (IsAnnotation) then
               AggregateStack.Pop (IndexTypeSymbol,
                                   TypeLowerBound,
                                   TypeUpperBound,
                                   AggregateFlags,
                                   EntryCounter,
                                   CompleteRec);
               if EntryCounter = Natural'Last then
                  AggregateFlags.MoreEntriesThanNatural := True;
               else
                  EntryCounter := EntryCounter + 1;
               end if;
               AggregateStack.Push (IndexTypeSymbol,
                                    TypeLowerBound,
                                    TypeUpperBound,
                                    AggregateFlags,
                                    EntryCounter,
                                    CompleteRec);
            end if;

            NameExp.ErrorsInExpression := NameExp.ErrorsInExpression or
               ExpResult.ErrorsInExpression;
            ExpStack.Push (NameExp, EStack);

         elsif Dictionary.TypeIsRecord (NameExp.TypeSymbol) then
            if NameExp.ParamCount =
               Dictionary.GetNumberOfComponents (NameExp.TypeSymbol)
            then
               ExpStack.Push (UnknownTypeRecord, EStack);
               ErrorHandler.SemanticError (105,
                                           ErrorHandler.NoReference,
                                           NodePosition (Child_Node (Node)),
                                           Dictionary.GetSimpleName (NameExp.OtherSymbol));
               ChainUpToComponentAssociation (Node);
            else
               NameExp.ParamCount := NameExp.ParamCount + 1;
               ExpectedType := Dictionary.GetType
                  (Dictionary.GetRecordComponent (NameExp.TypeSymbol,
                                                  NameExp.ParamCount));
               PlantType (ExpectedType);
               AssignmentCheck (NodePosition (Child_Node (Node)),
                                Scope,
                                ExpectedType,
                                ExpResult);
               NameExp.IsConstant := NameExp.IsConstant and ExpResult.IsConstant;

               ExpStack.Push (NameExp, EStack);
            end if;
         end if;
      end if;
      -- else clause needed to deal with derivative node being an aggregate
   else
      if Parent = PA_REP_LOOKUP (IsAnnotation) then
         ExpStack.Pop (NameExp, EStack);
         if Dictionary.TypeIsArray (NameExp.TypeSymbol) then
            AggregateStack.Pop (IndexTypeSymbol,
                                TypeLowerBound,
                                TypeUpperBound,
                                AggregateFlags,
                                EntryCounter,
                                CompleteRec);
            if EntryCounter = Natural'Last then
               AggregateFlags.MoreEntriesThanNatural := True;
            else
               EntryCounter := EntryCounter + 1;
            end if;
            AggregateStack.Push (IndexTypeSymbol,
                                 TypeLowerBound,
                                 TypeUpperBound,
                                 AggregateFlags,
                                 EntryCounter,
                                 CompleteRec);
         end if;
         ExpStack.Push (NameExp, EStack);
      end if;
   end if;
end up_wf_aggregate_or_expression;
