-- $Id: sem-compunit-typecontextstack.adb 14620 2009-10-28 13:40:30Z spark $
--------------------------------------------------------------------------------
-- (C) Altran Praxis Limited
--------------------------------------------------------------------------------
--
-- The SPARK toolset is free software; you can redistribute it and/or modify it
-- under terms of the GNU General Public License as published by the Free
-- Software Foundation; either version 3, or (at your option) any later
-- version. The SPARK toolset is distributed in the hope that it will be
-- useful, but WITHOUT ANY WARRANTY; without even the implied warranty of
-- MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the GNU General
-- Public License for more details. You should have received a copy of the GNU
-- General Public License distributed with the SPARK toolset; see file
-- COPYING3. If not, go to http://www.gnu.org/licenses for a complete copy of
-- the license.
--
--==============================================================================

with SPARK_IO;
separate (Sem.CompUnit)
package body TypeContextStack
is

   procedure Init (Stack : out TStackType)
   is
   begin
      Stack.TopPtr := 0;
      --# accept Flow, 32, Stack.S, "Safe partial initialisation" &
      --#        Flow, 31, Stack.S, "Safe partial initialisation" &
      --#        Flow, 602, Stack, Stack.S, "Safe partial initialisation";
   end Init;  -- 2 Flow errors and 1 Warning expected: non init of Stack.S

   procedure Push (X      : in     Dictionary.Symbol;
                   Stack  : in out TStackType)
   is
      procedure Debug
      --# derives ;
      is
         --# hide Debug;
         Str : EStrings.T;
      begin
         if CommandLineData.Content.Debug.Expressions then
            SPARK_IO.Put_String (SPARK_IO.Standard_Output, "TypeContextStack PUSH : ", 0);
            Dictionary.GenerateSimpleName (X, ".", Str);
            EStrings.Put_String (File  => SPARK_IO.Standard_Output,
                                 E_Str => Str);
            SPARK_IO.New_Line (SPARK_IO.Standard_Output, 1);
         end if;
      end Debug;
   begin
      if Stack.TopPtr < ExaminerConstants.WalkExpStackMax then
         Stack.TopPtr := Stack.TopPtr + 1;
         Stack.S (Stack.TopPtr) := X;
         Debug;
      else
         SystemErrors.FatalError (SystemErrors.TypeContextStackOverflow, "");
      end if;
   end Push;

   procedure Pop (Stack : in out TStackType)
   is
      procedure Debug
      --# derives ;
      is
         --# hide Debug;
         Str : EStrings.T;
      begin
         if CommandLineData.Content.Debug.Expressions then
            SPARK_IO.Put_String (SPARK_IO.Standard_Output, "TypeContextStack POP  : ", 0);
            Dictionary.GenerateSimpleName (Stack.S (Stack.TopPtr), ".", Str);
            EStrings.Put_String (File  => SPARK_IO.Standard_Output,
                                 E_Str => Str);
            SPARK_IO.New_Line (SPARK_IO.Standard_Output, 1);
         end if;
      end Debug;
   begin
      if Stack.TopPtr > 0 then
         Debug; -- Call Debug _before_ we move the stack pointer!
         Stack.TopPtr := Stack.TopPtr - 1;
      else
         SystemErrors.FatalError (SystemErrors.TypeContextStackUnderflow, "");
      end if;
   end Pop;

   function Top (Stack : in TStackType) return Dictionary.Symbol
   is
   begin
      return Stack.S (Stack.TopPtr);
   end Top;

   function HasOneEntry (Stack : in TStackType) return Boolean
   is
   begin
      return Stack.TopPtr = 1;
   end HasOneEntry;

end TypeContextStack;
