-- $Id: sem-compunit-nulltyperecord.adb 15520 2010-01-07 12:53:45Z spark $
--------------------------------------------------------------------------------
-- (C) Altran Praxis Limited
--------------------------------------------------------------------------------
--
-- The SPARK toolset is free software; you can redistribute it and/or modify it
-- under terms of the GNU General Public License as published by the Free
-- Software Foundation; either version 3, or (at your option) any later
-- version. The SPARK toolset is distributed in the hope that it will be
-- useful, but WITHOUT ANY WARRANTY; without even the implied warranty of
-- MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the GNU General
-- Public License for more details. You should have received a copy of the GNU
-- General Public License distributed with the SPARK toolset; see file
-- COPYING3. If not, go to http://www.gnu.org/licenses for a complete copy of
-- the license.
--
--==============================================================================


separate (Sem.CompUnit)

function NullTypeRecord return ExpRecord
is
begin
   return ExpRecord'(TypeSymbol            => Dictionary.GetUnknownTypeMark,
                     OtherSymbol           => Dictionary.NullSymbol,
                     StreamSymbol          => Dictionary.NullSymbol,
                     TaggedParameterSymbol => Dictionary.NullSymbol,
                     VariableSymbol        => Dictionary.NullSymbol,
                     ParamCount            => 0,
                     ParamList             => Lists.Null_List,
                     Sort                  => TypeResult,
                     ArgListFound          => False,
                     IsAVariable           => False,
                     IsAnEntireVariable    => False,
                     ErrorsInExpression    => False,
                     HasOperators          => False,
                     IsStatic              => False,
                     IsConstant            => False,
                     IsARange              => False,
                     Value                 => Maths.NoValue,
                     RangeRHS              => Maths.NoValue);
end NullTypeRecord;
