-- $Id: sem-compunit-expstack.adb 14620 2009-10-28 13:40:30Z spark $
--------------------------------------------------------------------------------
-- (C) Altran Praxis Limited
--------------------------------------------------------------------------------
--
-- The SPARK toolset is free software; you can redistribute it and/or modify it
-- under terms of the GNU General Public License as published by the Free
-- Software Foundation; either version 3, or (at your option) any later
-- version. The SPARK toolset is distributed in the hope that it will be
-- useful, but WITHOUT ANY WARRANTY; without even the implied warranty of
-- MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the GNU General
-- Public License for more details. You should have received a copy of the GNU
-- General Public License distributed with the SPARK toolset; see file
-- COPYING3. If not, go to http://www.gnu.org/licenses for a complete copy of
-- the license.
--
--==============================================================================

with Ada.Text_IO;

separate (Sem.CompUnit)
package body ExpStack
is

   procedure Debug_Item (Op   : in String;
                         Item : in Sem.ExpRecord)
   --# derives null from Item,
   --#                   Op;
   is
      --# hide Debug_Item;
      Str : EStrings.T;
   begin
      Ada.Text_IO.Put_Line (Op);
      if Item.TypeSymbol /= Dictionary.NullSymbol then
         Ada.Text_IO.Put ("   ExpRecord.TypeSymbol = ");
         Dictionary.GenerateSimpleName (Item.TypeSymbol, ".", Str);
         EStrings.Put_Line (File  => SPARK_IO.Standard_Output,
                            E_Str => Str);
      end if;
      if Item.OtherSymbol /= Dictionary.NullSymbol then
         Ada.Text_IO.Put ("   ExpRecord.OtherSymbol = ");
         Dictionary.GenerateSimpleName (Item.OtherSymbol, ".", Str);
         EStrings.Put_Line (File  => SPARK_IO.Standard_Output,
                            E_Str => Str);
      end if;
      if Item.StreamSymbol /= Dictionary.NullSymbol then
         Ada.Text_IO.Put ("   ExpRecord.StreamSymbol = ");
         Dictionary.GenerateSimpleName (Item.StreamSymbol, ".", Str);
         EStrings.Put_Line (File  => SPARK_IO.Standard_Output,
                            E_Str => Str);
      end if;
      if Item.TaggedParameterSymbol /= Dictionary.NullSymbol then
         Ada.Text_IO.Put ("   ExpRecord.TaggedParameterSymbol = ");
         Dictionary.GenerateSimpleName (Item.TaggedParameterSymbol, ".", Str);
         EStrings.Put_Line (File  => SPARK_IO.Standard_Output,
                            E_Str => Str);
      end if;
      if Item.VariableSymbol /= Dictionary.NullSymbol then
         Ada.Text_IO.Put ("   ExpRecord.VariableSymbol = ");
         Dictionary.GenerateSimpleName (Item.VariableSymbol, ".", Str);
         EStrings.Put_Line (File  => SPARK_IO.Standard_Output,
                            E_Str => Str);
      end if;
   end Debug_Item;

   procedure Debug_Stack (Stack : in ExpStackType)
   --# derives null from Stack;
   is
      --# hide Debug_Stack;
   begin
      Ada.Text_IO.Put_Line ("----------------------------------------");
      for I in IndexRange'First .. Stack.TopPtr loop
         Debug_Item (Op   => "ExpStack.Debug_Stack",
                     Item => Stack.S (I));
      end loop;
      Ada.Text_IO.Put_Line ("----------------------------------------");
   end Debug_Stack;

   procedure Init (Stack : out ExpStackType)
   is
   begin
      Stack.TopPtr := 0;
      --# accept Flow, 32, Stack.S, "Safe partial initialisation" &
      --#        Flow, 31, Stack.S, "Safe partial initialisation" &
      --#        Flow, 602, Stack, Stack.S, "Safe partial initialisation";
   end Init;  -- 2 Flow errors and 1 Warning expected: non init of Stack.S

   procedure Push (X      : in     Sem.ExpRecord;
                   Stack : in out ExpStackType)
   is
   begin

      if CommandLineData.Content.Debug.Expressions then
         Debug_Item ("ExpStack.Push", X);
      end if;

      if Stack.TopPtr < ExaminerConstants.WalkExpStackMax then
         Stack.TopPtr := Stack.TopPtr + 1;
         Stack.S (Stack.TopPtr) := X;
      else
         SystemErrors.FatalError (SystemErrors.ExpressionStackOverflow, "");
      end if;

      if CommandLineData.Content.Debug.Expressions then
         Debug_Stack (Stack);
      end if;

   end Push;

   procedure Pop (Item   :    out Sem.ExpRecord;
                  Stack : in out ExpStackType)
   is
   begin
      if Stack.TopPtr > 0 then
         Item := Stack.S (Stack.TopPtr);
         Stack.TopPtr := Stack.TopPtr - 1;

         if CommandLineData.Content.Debug.Expressions then
            Debug_Item ("ExpStack.Pop", Item);
            Debug_Stack (Stack);
         end if;

      else
         SystemErrors.FatalError (SystemErrors.ExpressionStackUnderflow, "");
         Item := Stack.S (Stack.TopPtr);
      end if;
   end Pop;

   function Top (Stack : ExpStackType) return Sem.ExpRecord
   is
   begin
      return Stack.S (Stack.TopPtr);
   end Top;

   function HasOneEntry (Stack  : ExpStackType) return Boolean
   is
   begin
      return Stack.TopPtr = 1;
   end HasOneEntry;

   function IsEmpty (Stack  : ExpStackType) return Boolean
   is
   begin
      return Stack.TopPtr = 0;
   end IsEmpty;

end ExpStack;
