-- $Id: sem-compunit-down_wf_store.adb 15520 2010-01-07 12:53:45Z spark $
--------------------------------------------------------------------------------
-- (C) Altran Praxis Limited
--------------------------------------------------------------------------------
--
-- The SPARK toolset is free software; you can redistribute it and/or modify it
-- under terms of the GNU General Public License as published by the Free
-- Software Foundation; either version 3, or (at your option) any later
-- version. The SPARK toolset is distributed in the hope that it will be
-- useful, but WITHOUT ANY WARRANTY; without even the implied warranty of
-- MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the GNU General
-- Public License for more details. You should have received a copy of the GNU
-- General Public License distributed with the SPARK toolset; see file
-- COPYING3. If not, go to http://www.gnu.org/licenses for a complete copy of
-- the license.
--
--==============================================================================


separate (Sem.CompUnit)
procedure down_wf_store (Node     : in     STree.SyntaxNode;
                         Scope    : in     Dictionary.Scopes;
                         EStack   : in out ExpStack.ExpStackType;
                         NextNode :    out STree.SyntaxNode)
is
   TypeInfo    : ExpRecord;
   ErrorFound  : Boolean := False;


begin
   ExpStack.Pop (TypeInfo, EStack);

   case TypeInfo.Sort is
      when IsUnknown =>
         TypeInfo := UnknownSymbolRecord;
         NextNode := STree.NullNode;

      when IsObject =>
         if Dictionary.IsArrayTypeMark (TypeInfo.TypeSymbol, Scope) then
            TypeInfo.ParamCount := 0;
            NextNode := Child_Node (Node);
         elsif Dictionary.IsRecordTypeMark (TypeInfo.TypeSymbol, Scope) then
            NextNode := Child_Node (Node);
         else --neither record nor array
            ErrorFound := True;
            ErrorHandler.SemanticError (323, ErrorHandler.NoReference,
                                        NodePosition (ParentNode (Node)),
                                        LexTokenManager.Null_String);
            NextNode := STree.NullNode;

         end if;

      when others =>
         TypeInfo := UnknownSymbolRecord;
         ErrorHandler.SemanticError (323, ErrorHandler.NoReference,
                                     NodePosition (ParentNode (Node)),
                                     LexTokenManager.Null_String);
         NextNode := STree.NullNode;
   end case;

   TypeInfo.ErrorsInExpression := TypeInfo.ErrorsInExpression or ErrorFound;
   ExpStack.Push (TypeInfo, EStack);
end down_wf_store;
