-- $Id: sem-compunit-createinterruptstreamvariables.adb 11354 2008-10-06 17:02:56Z Bill Ellis $
--------------------------------------------------------------------------------
-- (C) Altran Praxis Limited
--------------------------------------------------------------------------------
--
-- The SPARK toolset is free software; you can redistribute it and/or modify it
-- under terms of the GNU General Public License as published by the Free
-- Software Foundation; either version 3, or (at your option) any later
-- version. The SPARK toolset is distributed in the hope that it will be
-- useful, but WITHOUT ANY WARRANTY; without even the implied warranty of
-- MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the GNU General
-- Public License for more details. You should have received a copy of the GNU
-- General Public License distributed with the SPARK toolset; see file
-- COPYING3. If not, go to http://www.gnu.org/licenses for a complete copy of
-- the license.
--
--==============================================================================


separate (Sem.CompUnit)

procedure CreateInterruptStreamVariables
  (ForPO     : in Dictionary.Symbol;
   ErrorNode : in STree.SyntaxNode) is

   It         : Dictionary.Iterator;
   TheMapping : Dictionary.Symbol;

begin
   It := Dictionary.FirstInterruptStreamMapping (ForPO);
   while not Dictionary.IsNullIterator (It) loop
      TheMapping := Dictionary.CurrentSymbol (It);
      CreateInterruptStreamVariable
        (ForPO             => ForPO,
         TheHandler        => Dictionary.GetInterruptStreamMappingHandler (TheMapping),
         TheStreamVariable => Dictionary.GetInterruptStreamMappingStream (TheMapping),
         ErrorNode         => ErrorNode);
      It := Dictionary.NextSymbol (It);
   end loop;
end CreateInterruptStreamVariables;
