-- $Id: sem-compunit-checksuspendslistaccountedfor.adb 11354 2008-10-06 17:02:56Z Bill Ellis $
--------------------------------------------------------------------------------
-- (C) Altran Praxis Limited
--------------------------------------------------------------------------------
--
-- The SPARK toolset is free software; you can redistribute it and/or modify it
-- under terms of the GNU General Public License as published by the Free
-- Software Foundation; either version 3, or (at your option) any later
-- version. The SPARK toolset is distributed in the hope that it will be
-- useful, but WITHOUT ANY WARRANTY; without even the implied warranty of
-- MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the GNU General
-- Public License for more details. You should have received a copy of the GNU
-- General Public License distributed with the SPARK toolset; see file
-- COPYING3. If not, go to http://www.gnu.org/licenses for a complete copy of
-- the license.
--
--==============================================================================


separate (Sem.CompUnit)

procedure CheckSuspendsListAccountedFor (ProcOrTask : in     Dictionary.Symbol;
                                         Node       : in     STree.SyntaxNode)
is
   It        : Dictionary.Iterator;
   ThePOorSO : Dictionary.Symbol;
begin
   if not Dictionary.BodyIsHidden (ProcOrTask) then
      It := Dictionary.FirstSuspendsListItem (ProcOrTask);
      while not Dictionary.IsNullIterator (It) loop
         ThePOorSO := Dictionary.CurrentSymbol (It);
         if not Dictionary.SuspendsListItemIsAccountedFor
           (TheTaskOrProc => ProcOrTask,
            ThePOorSO     => ThePOorSO) then
            ErrorHandler.SemanticError (914,
                                        ErrorHandler.NoReference,
                                        NodePosition (Node),
                                        Dictionary.GetSimpleName (ThePOorSO));
         end if;
         It := Dictionary.NextSymbol (It);
      end loop;
   end if;
end CheckSuspendsListAccountedFor;
