-- $Id: sem-compunit-checksuspendablepropertyconsistency.adb 11354 2008-10-06 17:02:56Z Bill Ellis $
--------------------------------------------------------------------------------
-- (C) Altran Praxis Limited
--------------------------------------------------------------------------------
--
-- The SPARK toolset is free software; you can redistribute it and/or modify it
-- under terms of the GNU General Public License as published by the Free
-- Software Foundation; either version 3, or (at your option) any later
-- version. The SPARK toolset is distributed in the hope that it will be
-- useful, but WITHOUT ANY WARRANTY; without even the implied warranty of
-- MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the GNU General
-- Public License for more details. You should have received a copy of the GNU
-- General Public License distributed with the SPARK toolset; see file
-- COPYING3. If not, go to http://www.gnu.org/licenses for a complete copy of
-- the license.
--
--==============================================================================

separate (Sem.CompUnit)
procedure CheckSuspendablePropertyConsistency
  (Sym              : in     Dictionary.Symbol;
   TypeSym          : in     Dictionary.Symbol;
   IsInSuspendsList : in     Boolean;
   ErrorNode        : in     STree.SyntaxNode;
   Consistent       :    out Boolean) is

   TheError : Natural;

   function TypeIsSuspendable (TypeSym : Dictionary.Symbol) return Boolean
   --# global in CommandLineData.Content;
   --#        in Dictionary.Dict;
   is
   begin
      -- To suspend the type must be a protected type with an entry or
      -- a suspension object type.
      return (Dictionary.TypeIsProtected (TypeSym) and then
                Dictionary.GetProtectedTypeHasEntry
                (Dictionary.GetRootType (TypeSym))) or else
        Dictionary.IsPredefinedSuspensionObjectType (TypeSym);
   end TypeIsSuspendable;

begin
   TheError := 0;

   if IsInSuspendsList then

      if not (Dictionary.IsOwnVariable (Sym) or else
                Dictionary.IsConstituent (Sym)) then

         -- We have an entry in a suspends list that it not being applied
         -- to an own variable.
         TheError := 924;

      elsif (Dictionary.IsOwnVariable (Sym) and then
               not Dictionary.GetOwnVariableProtected (Sym))
      then

         -- The own variable is not protected and hence cannot suspend.
         TheError := 924;

      elsif (Dictionary.IsDeclared (TypeSym) or
               Dictionary.IsPredefined (TypeSym)) and then
        not TypeIsSuspendable (TypeSym) then

         -- We have a protected own variable whose type we know cannot suspend.
         TheError := 924;

      end if;

   elsif Dictionary.IsOwnVariable (Sym) and then
     Dictionary.GetOwnVariableProtected (Sym) and then
     TypeIsSuspendable (TypeSym) then

      -- We are declaring an object that can suspend but does not have a
      -- suspendable property declared in the own variable annotation.
      TheError := 889;

   end if;

   Consistent := TheError = 0;

   if TheError /= 0 then
      ErrorHandler.SemanticError (TheError,
                                  ErrorHandler.NoReference,
                                  NodePosition (ErrorNode),
                                  Dictionary.GetSimpleName (Sym));
   end if;
end CheckSuspendablePropertyConsistency;
