-- $Id: requiredunits.ads 13063 2009-04-21 12:05:08Z Rod Chapman $
--------------------------------------------------------------------------------
-- (C) Altran Praxis Limited
--------------------------------------------------------------------------------
--
-- The SPARK toolset is free software; you can redistribute it and/or modify it
-- under terms of the GNU General Public License as published by the Free
-- Software Foundation; either version 3, or (at your option) any later
-- version. The SPARK toolset is distributed in the hope that it will be
-- useful, but WITHOUT ANY WARRANTY; without even the implied warranty of
-- MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the GNU General
-- Public License for more details. You should have received a copy of the GNU
-- General Public License distributed with the SPARK toolset; see file
-- COPYING3. If not, go to http://www.gnu.org/licenses for a complete copy of
-- the license.
--
--==============================================================================

with ContextManager,
     STree,
     LexTokenLists;

use type STree.SyntaxNode;

--# inherit ContextManager,
--#         STree,
--#         SPSymbols,
--#         LexTokenLists,
--#         SystemErrors;
package RequiredUnits
is

   procedure Init (TopNode    : in     STree.SyntaxNode;
                   InheritPtr :    out STree.SyntaxNode;
                   UnitType   :    out ContextManager.UnitTypes;
                   UnitName   :    out LexTokenLists.Lists);
   --# global in STree.Table;
   --# derives InheritPtr,
   --#         UnitName,
   --#         UnitType   from STree.Table,
   --#                         TopNode;


   procedure Next (InheritPtr   : in out STree.SyntaxNode;
                   RequiredUnit :    out LexTokenLists.Lists;
                   Found        :    out Boolean);
   --# global in STree.Table;
   --# derives Found        from InheritPtr &
   --#         InheritPtr,
   --#         RequiredUnit from InheritPtr,
   --#                           STree.Table;
end RequiredUnits;
