-- $Id: relationalgebra-debug.ads 11354 2008-10-06 17:02:56Z Bill Ellis $
--------------------------------------------------------------------------------
-- (C) Altran Praxis Limited
--------------------------------------------------------------------------------
--
-- The SPARK toolset is free software; you can redistribute it and/or modify it
-- under terms of the GNU General Public License as published by the Free
-- Software Foundation; either version 3, or (at your option) any later
-- version. The SPARK toolset is distributed in the hope that it will be
-- useful, but WITHOUT ANY WARRANTY; without even the implied warranty of
-- MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the GNU General
-- Public License for more details. You should have received a copy of the GNU
-- General Public License distributed with the SPARK toolset; see file
-- COPYING3. If not, go to http://www.gnu.org/licenses for a complete copy of
-- the license.
--
--==============================================================================

-- This package is for use in debugging the Examiner.  It facilitates the
-- printing of the flow relations generated during flow analysis.
-- The package only need be with'd and inherited when debugging.
-- The body of this package is not SPARK and need not be included in analysis.
-- The entire body is hidden.

--# inherit Heap,
--#         RelationAlgebra;
package RelationAlgebra.Debug
is

   -- Print out the Rho relation to standard output.
   procedure Print_Rho (Msg     : in String;
                        Rho     : in RelationAlgebra.Relation;
                        TheHeap : in Heap.HeapRecord);
   --# derives null from Msg,
   --#                   Rho,
   --#                   TheHeap;

   -- Print out the Mu relation to standard output.
   procedure Print_Mu (Msg     : in String;
                       Mu      : in RelationAlgebra.Relation;
                       TheHeap : in Heap.HeapRecord);
   --# derives null from Msg,
   --#                   Mu,
   --#                   TheHeap;

   -- Print out the Lambda relation to standard output.
   procedure Print_Lambda (Msg     : in String;
                           Lambda  : in RelationAlgebra.Relation;
                           TheHeap : in Heap.HeapRecord);
   --# derives null from Lambda,
   --#                   Msg,
   --#                   TheHeap;

end RelationAlgebra.Debug;
