-- $Id: metafile.ads 14620 2009-10-28 13:40:30Z spark $
--------------------------------------------------------------------------------
-- (C) Altran Praxis Limited
--------------------------------------------------------------------------------
--
-- The SPARK toolset is free software; you can redistribute it and/or modify it
-- under terms of the GNU General Public License as published by the Free
-- Software Foundation; either version 3, or (at your option) any later
-- version. The SPARK toolset is distributed in the hope that it will be
-- useful, but WITHOUT ANY WARRANTY; without even the implied warranty of
-- MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the GNU General
-- Public License for more details. You should have received a copy of the GNU
-- General Public License distributed with the SPARK toolset; see file
-- COPYING3. If not, go to http://www.gnu.org/licenses for a complete copy of
-- the license.
--
--==============================================================================

--Provides routines to support analysis of "files of files"
--------------------------------------------------------------------------------

with EStrings;
with SPARK_IO;

use type SPARK_IO.File_Status;

--# inherit Ada.Characters.Latin_1,
--#         CommandLineData,
--#         CommandLineHandler,
--#         ErrorHandler,
--#         EStrings,
--#         FileSystem,
--#         ScreenEcho,
--#         SPARK_IO,
--#         SystemErrors,
--#         XMLReport;

package MetaFile
is
   type MetaFiles  is private;

   --Meta File Operations

   procedure Create (FileName    : in     EStrings.T;
                     TheMetaFile :    out MetaFiles);
   --# global in     CommandLineData.Content;
   --#        in out SPARK_IO.File_Sys;
   --# derives SPARK_IO.File_Sys from *,
   --#                                CommandLineData.Content,
   --#                                FileName &
   --#         TheMetaFile       from FileName,
   --#                                SPARK_IO.File_Sys;

   procedure NextName (TheMetaFile    : in out MetaFiles;
                       TheFileName    :    out EStrings.T;
                       DoListing      :    out Boolean;
                       TheListingName :    out EStrings.T;
                       FileFound      :    out Boolean);
   --# global in     CommandLineData.Content;
   --#        in out ErrorHandler.ErrorContext;
   --#        in out SPARK_IO.File_Sys;
   --# derives DoListing,
   --#         FileFound,
   --#         SPARK_IO.File_Sys,
   --#         TheFileName,
   --#         TheListingName,
   --#         TheMetaFile               from CommandLineData.Content,
   --#                                        SPARK_IO.File_Sys,
   --#                                        TheMetaFile &
   --#         ErrorHandler.ErrorContext from *,
   --#                                        CommandLineData.Content,
   --#                                        SPARK_IO.File_Sys,
   --#                                        TheMetaFile;


   procedure ReportFileContent (ToFile       : in     SPARK_IO.File_Type;
                                FileName     : in     EStrings.T;
                                MetaFileUsed : in out Boolean);
   --# global in     CommandLineData.Content;
   --#        in out SPARK_IO.File_Sys;
   --#        in out XMLReport.State;
   --# derives MetaFileUsed      from *,
   --#                                FileName,
   --#                                SPARK_IO.File_Sys &
   --#         SPARK_IO.File_Sys,
   --#         XMLReport.State   from CommandLineData.Content,
   --#                                FileName,
   --#                                MetaFileUsed,
   --#                                SPARK_IO.File_Sys,
   --#                                ToFile,
   --#                                XMLReport.State;

private
   StackSize : constant := 100;
   type Ptrs is range 0 .. StackSize;
   subtype Indexes is Ptrs range 1 .. StackSize;

   type MetaFileElement is record
      File_Handle : SPARK_IO.File_Type;
      PathName    : EStrings.T;
   end record;

   type Vectors is array (Indexes) of MetaFileElement;

   type MetaFiles is record
      Vector : Vectors;
      Ptr    : Ptrs;
   end record;


end MetaFile;
