-- $Id: maths-valuetostring.adb 14620 2009-10-28 13:40:30Z spark $
--------------------------------------------------------------------------------
-- (C) Altran Praxis Limited
--------------------------------------------------------------------------------
--
-- The SPARK toolset is free software; you can redistribute it and/or modify it
-- under terms of the GNU General Public License as published by the Free
-- Software Foundation; either version 3, or (at your option) any later
-- version. The SPARK toolset is distributed in the hope that it will be
-- useful, but WITHOUT ANY WARRANTY; without even the implied warranty of
-- MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the GNU General
-- Public License for more details. You should have received a copy of the GNU
-- General Public License distributed with the SPARK toolset; see file
-- COPYING3. If not, go to http://www.gnu.org/licenses for a complete copy of
-- the license.
--
--==============================================================================


separate (Maths)
function ValueToString (Num : Value) return ELStrings.T
is
   OutBuffer  : ELStrings.T;

   ---------------------------------------------------------

   procedure WriteChar (Ch : in     Character)
   --# global in out outBuffer;
   --# derives outBuffer from *,
   --#                        ch;
   is
      Success : Boolean;
   begin
      --# accept F, 10, Success, "Ineffective assignment here OK";
      ELStrings.Append_Char (E_Str   => OutBuffer,
                             Ch      => Ch,
                             Success => Success);
      --# end accept;
      --# accept F, 33, Success, "Expect Success unused";
   end WriteChar;

   ---------------------------------------------------------

   procedure DoSign
   --# global in     Num;
   --#        in out outBuffer;
   --# derives outBuffer from *,
   --#                        Num;
   is
   begin
      if not Num.IsPositive then
         WriteChar ('-');
      end if;
   end DoSign;

   ---------------------------------------------------------

   procedure PartToString (P    : in     Part;
                           Str  :    out ELStrings.T)
   --# derives Str from P;
   is
      Hi      : Natural;
      Success : Boolean;
   begin
      Str := ELStrings.Empty_String;
      Hi := P.Length;
      for I in Natural range 1 .. Hi loop
         --# accept F, 10, Success, "Ineffective assignment here OK";
         ELStrings.Append_Char (E_Str   => Str,
                                Ch      => DigitToChar (P.Numerals ((Hi - I) + 1)),
                                Success => Success);
         --# end accept;
      end loop;
      --# accept F, 33, Success, "Expect Success unused";
   end PartToString;

   ----------------------------------------------

   procedure IntegerToString
      --# global in     Num;
      --#        in out outBuffer;
      --# derives outBuffer from *,
      --#                        Num;
   is
      ItemBuffer : ELStrings.T;
   begin
      DoSign;
      PartToString (Num.Numerator, ItemBuffer);
      ELStrings.Append_Examiner_Long_String (E_Str1 => OutBuffer,
                                             E_Str2 => ItemBuffer);
   end IntegerToString;

   ----------------------------------------------

   procedure RealToString
      --# global in     Num;
      --#        in out outBuffer;
      --# derives outBuffer from *,
      --#                        Num;
   is
      ItemBuffer : ELStrings.T;
      IsRational : Boolean;
   begin
      IsRational := not (Num.Denominator = OnePart);
      if IsRational then
         WriteChar ('(');
      end if;
      DoSign;
      PartToString (Num.Numerator, ItemBuffer);
      ELStrings.Append_Examiner_Long_String (E_Str1 => OutBuffer,
                                             E_Str2 => ItemBuffer);
      if IsRational then
         WriteChar ('/');
         --EStrings.AppendString(outBuffer, "/");
         PartToString (Num.Denominator, ItemBuffer);
         ELStrings.Append_Examiner_Long_String (E_Str1 => OutBuffer,
                                                E_Str2 => ItemBuffer);
         WriteChar (')');
      end if;
   end RealToString;

   ----------------------------------------------

begin --ValueToString
   if Num.Sort = UnknownValue then
      OutBuffer := ELStrings.Copy_String (Str => "unknown value");
   elsif Num.Sort = TruthValue then
      if Num = FalseValue then
         OutBuffer := ELStrings.Copy_String (Str => "false");
      else
         OutBuffer := ELStrings.Copy_String (Str => "true");
      end if;
   else
      OutBuffer  := ELStrings.Empty_String;
      if Num.Sort = IntegerValue then
         IntegerToString;
      else  --its a real
         RealToString;
      end if;
   end if;
   return OutBuffer;
end ValueToString;
