-- $Id: maths-literaltovalue.adb 15520 2010-01-07 12:53:45Z spark $
--------------------------------------------------------------------------------
-- (C) Altran Praxis Limited
--------------------------------------------------------------------------------
--
-- The SPARK toolset is free software; you can redistribute it and/or modify it
-- under terms of the GNU General Public License as published by the Free
-- Software Foundation; either version 3, or (at your option) any later
-- version. The SPARK toolset is distributed in the hope that it will be
-- useful, but WITHOUT ANY WARRANTY; without even the implied warranty of
-- MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the GNU General
-- Public License for more details. You should have received a copy of the GNU
-- General Public License distributed with the SPARK toolset; see file
-- COPYING3. If not, go to http://www.gnu.org/licenses for a complete copy of
-- the license.
--
--==============================================================================


separate (Maths)
procedure LiteralToValue (Str    : in     LexTokenManager.Lex_String;
                          Num    :    out Value;
                          Ok     :    out ErrorCode)
is
   DecimalPointFound,
   ExponentFound,
   BaseFound          :  Boolean;
   Base               :  Natural;
   CoreString,
   ExpString          :  EStrings.T;
   ExpSign            :  Character;
   PlacesAfterPoint   :  EStrings.Lengths;
   LegalSyntax        :  Boolean;
   Exponent           :  Integer;
   NumLocal           :  Value;
   OkLocal            :  ErrorCode;

   ---------------------------------------------------------

   procedure MakeInteger
      --# global in     Base;
      --#        in     BaseFound;
      --#        in     CoreString;
      --#        in     Exponent;
      --#        in     ExponentFound;
      --#        in out NumLocal;
      --#        in out OkLocal;
      --# derives NumLocal from *,
      --#                       Base,
      --#                       BaseFound,
      --#                       CoreString,
      --#                       Exponent,
      --#                       ExponentFound &
      --#         OkLocal  from *,
      --#                       CoreString,
      --#                       Exponent,
      --#                       ExponentFound;
   is
      CoreLocal  : EStrings.T;
      PaddedOk   : Boolean;

      -------------------------------

      procedure PadStringWithZeros (Str : in out EStrings.T;
                                    By  : in     Natural;
                                    Ok  :    out Boolean)
      --# derives Ok,
      --#         Str from By,
      --#                  Str;
      is
         Success : Boolean;
      begin
         if (EStrings.Get_Length (E_Str => Str) + By) < EStrings.Max_String_Length then
            Ok := True;
            for I in Integer range 1 .. By loop
               --# accept F, 10, Success, "Ineffective assignment here OK";
               EStrings.Append_Char (E_Str   => Str,
                                     Ch      => '0',
                                     Success => Success);
               --# end accept;
            end loop;
         else
            Ok := False;
         end if;
         --# accept F, 33, Success, "Expect Success unused";
      end PadStringWithZeros;

      -------------------------------

   begin -- MakeInteger
      NumLocal.Sort := IntegerValue;
      CoreLocal := CoreString;
      if ExponentFound then
         PadStringWithZeros (CoreLocal, Exponent, PaddedOk);
      else
         PaddedOk := True;
      end if;
      if PaddedOk then
         if BaseFound then
            NumLocal.Numerator   := StripLeadingZeros (StringToPart (Base, CoreLocal));
         else
            NumLocal.Numerator   := StripLeadingZeros (DecStringToPart (CoreLocal));
         end if;
      else
         NumLocal := NoValue;
         OkLocal  := OverFlow;
      end if;
   end MakeInteger;

   ---------------------------------------------------------

   procedure MakeReal
      --# global in     CoreString;
      --#        in     Exponent;
      --#        in     PlacesAfterPoint;
      --#        in out NumLocal;
      --# derives NumLocal from *,
      --#                       CoreString,
      --#                       Exponent,
      --#                       PlacesAfterPoint;
   is
      ExpLocal : Integer;
      DenPart,
      NumPart  : Part;

   begin
      ExpLocal      := Exponent;
      NumLocal.Sort := RealValue;
      NumPart       := DecStringToPart (CoreString);
      DenPart       := OnePart;
      ExpLocal := ExpLocal - PlacesAfterPoint;
      if ExpLocal > 0 then
         for i in Integer range 1 .. ExpLocal loop
            NumPart := ShiftUpPart (NumPart);
         end loop;
      elsif ExpLocal < 0 then
         ExpLocal := -ExpLocal;
         for i in Integer range 1 .. ExpLocal loop
            DenPart := ShiftUpPart (DenPart);
         end loop;
         --else do nothing about exponent
      end if;
      NumLocal.Numerator   := NumPart;
      NumLocal.Denominator := DenPart;
      Normalize (NumLocal);
   end MakeReal;

   ---------------------------------------------------------

begin -- LiteralToValue
   if LexTokenManager.Lex_String_Case_Insensitive_Compare (Lex_Str1 => Str,
                                                           Lex_Str2 => LexTokenManager.Null_String) = LexTokenManager.Str_Eq then
      Num := NoValue;
      OkLocal  := NoError;
   else
      NumLocal := NoValue;  --must return something if error
      ParseString (LexTokenManager.Lex_String_To_String (Lex_Str => Str),
                   DecimalPointFound,
                   ExponentFound,
                   BaseFound,
                   Base,
                   CoreString,
                   ExpString,
                   ExpSign,
                   PlacesAfterPoint,
                   LegalSyntax);

      if LegalSyntax then
         OkLocal := NoError;
         Exponent := StringToNatural (ExpString);
         if ExpSign = '-' then
            Exponent := -Exponent;
         end if;
         if DecimalPointFound then
            MakeReal;
         else
            MakeInteger;
         end if;
      else
         OkLocal  := IllegalValue;
      end if;

      OkLocal  := OverflowCheck (OkLocal, NumLocal);

      if OkLocal = NoError then
         Num := NumLocal;
      else
         Num := NoValue;
      end if;
   end if;
   Ok := OkLocal;
end LiteralToValue;
