-- $Id: mainloop.ads 15674 2010-01-20 16:17:20Z spark $
--------------------------------------------------------------------------------
-- (C) Altran Praxis Limited
--------------------------------------------------------------------------------
--
-- The SPARK toolset is free software; you can redistribute it and/or modify it
-- under terms of the GNU General Public License as published by the Free
-- Software Foundation; either version 3, or (at your option) any later
-- version. The SPARK toolset is distributed in the hope that it will be
-- useful, but WITHOUT ANY WARRANTY; without even the implied warranty of
-- MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the GNU General
-- Public License for more details. You should have received a copy of the GNU
-- General Public License distributed with the SPARK toolset; see file
-- COPYING3. If not, go to http://www.gnu.org/licenses for a complete copy of
-- the license.
--
--==============================================================================

--# inherit Casing,
--#         CommandLineData,
--#         ConfigFile,
--#         ContextManager,
--#         ContextManager.Ops,
--#         Declarations,
--#         Dictionary,
--#         Error_Types,
--#         ErrorHandler,
--#         EStrings,
--#         ELStrings,
--#         File_Utils,
--#         FileSystem,
--#         Graph,
--#         IndexManager,
--#         LexTokenLists,
--#         LexTokenManager,
--#         MetaFile,
--#         RequiredUnits,
--#         ScreenEcho,
--#         Sem,
--#         SLI,
--#         SPARK_IO,
--#         SparkHTML,
--#         SparkLex,
--#         SPParser,
--#         Statistics,
--#         StmtStack,
--#         STree,
--#         VCG,
--#         XMLReport;
package MainLoop
is
   procedure ProcessFiles;
   --# global in     CommandLineData.Content;
   --#        in out ContextManager.Ops.FileHeap;
   --#        in out ContextManager.Ops.UnitHeap;
   --#        in out ContextManager.Ops.UnitStack;
   --#        in out Declarations.State;
   --#        in out ErrorHandler.ErrorContext;
   --#        in out Graph.Table;
   --#        in out IndexManager.LastChar;
   --#        in out IndexManager.State;
   --#        in out LexTokenManager.State;
   --#        in out SLI.State;
   --#        in out SparkHTML.GenerateHTML;
   --#        in out SPARK_IO.File_Sys;
   --#        in out Statistics.TableUsage;
   --#        in out StmtStack.S;
   --#        in out STree.Table;
   --#        in out VCG.Invoked;
   --#           out ConfigFile.State;
   --#           out Dictionary.Dict;
   --#           out SparkHTML.HTMLWorkDir;
   --#           out SparkHTML.SparkWorkDir;
   --#           out SparkLex.CurrLine;
   --#           out XMLReport.State;
   --# derives ConfigFile.State             from CommandLineData.Content,
   --#                                           ErrorHandler.ErrorContext,
   --#                                           LexTokenManager.State,
   --#                                           SPARK_IO.File_Sys &
   --#         ContextManager.Ops.UnitHeap,
   --#         ContextManager.Ops.UnitStack,
   --#         Declarations.State,
   --#         Graph.Table,
   --#         IndexManager.LastChar,
   --#         IndexManager.State,
   --#         SLI.State,
   --#         Statistics.TableUsage,
   --#         StmtStack.S,
   --#         STree.Table,
   --#         VCG.Invoked                  from *,
   --#                                           CommandLineData.Content,
   --#                                           ContextManager.Ops.FileHeap,
   --#                                           ContextManager.Ops.UnitHeap,
   --#                                           ContextManager.Ops.UnitStack,
   --#                                           ErrorHandler.ErrorContext,
   --#                                           IndexManager.State,
   --#                                           LexTokenManager.State,
   --#                                           SLI.State,
   --#                                           SparkHTML.GenerateHTML,
   --#                                           SPARK_IO.File_Sys,
   --#                                           STree.Table &
   --#         ContextManager.Ops.FileHeap,
   --#         ErrorHandler.ErrorContext,
   --#         LexTokenManager.State,
   --#         SparkLex.CurrLine,
   --#         XMLReport.State              from CommandLineData.Content,
   --#                                           ContextManager.Ops.FileHeap,
   --#                                           ContextManager.Ops.UnitHeap,
   --#                                           ContextManager.Ops.UnitStack,
   --#                                           ErrorHandler.ErrorContext,
   --#                                           IndexManager.State,
   --#                                           LexTokenManager.State,
   --#                                           SLI.State,
   --#                                           SparkHTML.GenerateHTML,
   --#                                           SPARK_IO.File_Sys,
   --#                                           STree.Table &
   --#         Dictionary.Dict,
   --#         SparkHTML.GenerateHTML       from CommandLineData.Content,
   --#                                           ContextManager.Ops.FileHeap,
   --#                                           ContextManager.Ops.UnitHeap,
   --#                                           ContextManager.Ops.UnitStack,
   --#                                           ErrorHandler.ErrorContext,
   --#                                           IndexManager.State,
   --#                                           LexTokenManager.State,
   --#                                           SLI.State,
   --#                                           SparkHTML.GenerateHTML,
   --#                                           SPARK_IO.File_Sys,
   --#                                           Statistics.TableUsage,
   --#                                           STree.Table &
   --#         SPARK_IO.File_Sys            from *,
   --#                                           CommandLineData.Content,
   --#                                           ContextManager.Ops.FileHeap,
   --#                                           ContextManager.Ops.UnitHeap,
   --#                                           ContextManager.Ops.UnitStack,
   --#                                           ErrorHandler.ErrorContext,
   --#                                           IndexManager.State,
   --#                                           LexTokenManager.State,
   --#                                           SLI.State,
   --#                                           SparkHTML.GenerateHTML,
   --#                                           Statistics.TableUsage,
   --#                                           STree.Table,
   --#                                           VCG.Invoked &
   --#         SparkHTML.HTMLWorkDir,
   --#         SparkHTML.SparkWorkDir       from CommandLineData.Content,
   --#                                           LexTokenManager.State,
   --#                                           SPARK_IO.File_Sys;
end MainLoop;
