-- $Id: lextokenmanager.ads 15674 2010-01-20 16:17:20Z spark $
--------------------------------------------------------------------------------
-- (C) Altran Praxis Limited
--------------------------------------------------------------------------------
--
-- The SPARK toolset is free software; you can redistribute it and/or modify it
-- under terms of the GNU General Public License as published by the Free
-- Software Foundation; either version 3, or (at your option) any later
-- version. The SPARK toolset is distributed in the hope that it will be
-- useful, but WITHOUT ANY WARRANTY; without even the implied warranty of
-- MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the GNU General
-- Public License for more details. You should have received a copy of the GNU
-- General Public License distributed with the SPARK toolset; see file
-- COPYING3. If not, go to http://www.gnu.org/licenses for a complete copy of
-- the license.
--
--==============================================================================

with CommandLineData;
with ExaminerConstants;
with ELStrings;
with EStrings;

--# inherit Ada.Characters.Handling,
--#         Ada.Characters.Latin_1,
--#         CommandLineData,
--#         ELStrings,
--#         EStrings,
--#         ExaminerConstants,
--#         SPARK_IO,
--#         Statistics,
--#         SystemErrors;

package LexTokenManager
--# own State;
--# initializes State;
is
   type Lex_String is private;

   Null_String                    : constant Lex_String;

   The_First_Token                : constant Lex_String;

   -- Common Attributes
   Aft_Token                      : constant Lex_String;
   Base_Token                     : constant Lex_String;
   Delta_Token                    : constant Lex_String;
   Digits_Token                   : constant Lex_String;
   Emax_Token                     : constant Lex_String;
   Epsilon_Token                  : constant Lex_String;
   First_Token                    : constant Lex_String;
   Fore_Token                     : constant Lex_String;
   Large_Token                    : constant Lex_String;
   Last_Token                     : constant Lex_String;
   Length_Token                   : constant Lex_String;
   Machine_Emax_Token             : constant Lex_String;
   Machine_Emin_Token             : constant Lex_String;
   Machine_Mantissa_Token         : constant Lex_String;
   Machine_Overflows_Token        : constant Lex_String;
   Machine_Radix_Token            : constant Lex_String;
   Machine_Rounds_Token           : constant Lex_String;
   Mantissa_Token                 : constant Lex_String;
   Pos_Token                      : constant Lex_String;
   Pred_Token                     : constant Lex_String;
   Range_Token                    : constant Lex_String;
   Safe_Emax_Token                : constant Lex_String;
   Safe_Large_Token               : constant Lex_String;
   Safe_Small_Token               : constant Lex_String;
   Size_Token                     : constant Lex_String;
   Small_Token                    : constant Lex_String;
   Succ_Token                     : constant Lex_String;
   Val_Token                      : constant Lex_String;

   -- Identifiers in Standard
   Left_Token                     : constant Lex_String;
   Right_Token                    : constant Lex_String;
   True_Token                     : constant Lex_String;
   False_Token                    : constant Lex_String;

   -- Numeric literals
   Zero_Value                     : constant Lex_String;
   One_Value                      : constant Lex_String;

   -- Index file
   Super_Index_Token              : constant Lex_String;

   -- Pragmas
   Interface_Token                : constant Lex_String;
   Import_Token                   : constant Lex_String;
   Link_Name_Token                : constant Lex_String;
   External_Name_Token            : constant Lex_String;
   Entity_Token                   : constant Lex_String;
   Convention_Token               : constant Lex_String;
   Elaborate_Body_Token           : constant Lex_String;

   -- SPARK95 Predefined packages
   Ada_Token                      : constant Lex_String;

   -- SPARK95 Attributes
   Denorm_Token                   : constant Lex_String;
   Model_Emin_Token               : constant Lex_String;
   Model_Epsilon_Token            : constant Lex_String;
   Model_Mantissa_Token           : constant Lex_String;
   Model_Small_Token              : constant Lex_String;
   Safe_First_Token               : constant Lex_String;
   Safe_Last_Token                : constant Lex_String;
   Component_Size_Token           : constant Lex_String;
   Min_Token                      : constant Lex_String;
   Max_Token                      : constant Lex_String;
   Signed_Zeros_Token             : constant Lex_String;
   Valid_Token                    : constant Lex_String;

   -- More SPARK95 Predefined packages
   Characters_Token               : constant Lex_String;
   Latin_1_Token                  : constant Lex_String;

   -- More SPARK95 Attributes
   Adjacent_Token                 : constant Lex_String;
   Compose_Token                  : constant Lex_String;
   Copy_Sign_Token                : constant Lex_String;
   Leading_Part_Token             : constant Lex_String;
   Remainder_Token                : constant Lex_String;
   Scaling_Token                  : constant Lex_String;
   Ceiling_Token                  : constant Lex_String;
   Exponent_Token                 : constant Lex_String;
   Floor_Token                    : constant Lex_String;
   Fraction_Token                 : constant Lex_String;
   Machine_Token                  : constant Lex_String;
   Model_Token                    : constant Lex_String;
   Rounding_Token                 : constant Lex_String;
   Truncation_Token               : constant Lex_String;
   Unbiased_Rounding_Token        : constant Lex_String;
   Address_Token                  : constant Lex_String;
   Modulus_Token                  : constant Lex_String;

   -- SPARK95 Proof Attributes
   Tail_Token                     : constant Lex_String;
   Append_Token                   : constant Lex_String;

   -- Package System and its constants and types. "Address" is already
   -- defined above.
   System_Token                   : constant Lex_String;
   Min_Int_Token                  : constant Lex_String;
   Max_Int_Token                  : constant Lex_String;
   Max_Binary_Modulus_Token       : constant Lex_String;
   Max_Base_Digits_Token          : constant Lex_String;
   Max_Digits_Token               : constant Lex_String;
   Max_Mantissa_Token             : constant Lex_String;
   Fine_Delta_Token               : constant Lex_String;
   Null_Address_Token             : constant Lex_String;
   Storage_Unit_Token             : constant Lex_String;
   Word_Size_Token                : constant Lex_String;
   Any_Priority_Token             : constant Lex_String;
   Priority_Token                 : constant Lex_String;
   Interrupt_Priority_Token       : constant Lex_String;
   Default_Priority_Token         : constant Lex_String;

   -- RavenSPARK Pragmas, attributes and packages
   Atomic_Token                   : constant Lex_String;
   Real_Time_Token                : constant Lex_String;
   Inherit_Token                  : constant Lex_String;
   Synchronous_Task_Control_Token : constant Lex_String;
   Attach_Handler_Token           : constant Lex_String;
   Interrupt_Handler_Token        : constant Lex_String;
   Interrupts_Token               : constant Lex_String;
   Access_Token                   : constant Lex_String;
   Atomic_Components_Token        : constant Lex_String;
   Volatile_Components_Token      : constant Lex_String;
   Main_Program_Token             : constant Lex_String;

   -- predefined generic units
   Unchecked_Conversion_Token     : constant Lex_String;

   -- composite constant rule generation
   Rule_Token                     : constant Lex_String;
   No_Rule_Token                  : constant Lex_String;

   -- the 'Always_Valid token
   Always_Valid_Token             : constant Lex_String;

   -- Ada0Y identifiers.
   --
   -- "Assert" is a predefined pragma in Ada0Y.  It's already
   -- a reserved word in SPARK, but we still
   -- need a token for it so the corresponding warning can
   -- be suppressed in the warning control file.
   --
   -- There is a special production in the grammar to
   -- allow "pragma Assert ..."
   Assert_Token                   : constant Lex_String;

   -- "overriding" will become a pseudo-reserved word in
   -- Ada0Y.  Eventually, we might make it a fully reserved word
   -- in SPARK, but for now let's have a token for it so we
   -- can at least issue a warning
   Overriding_Token               : constant Lex_String;

   -- Package System - more predefined identifiers
   Bit_Order_Token                : constant Lex_String;
   High_Order_First_Token         : constant Lex_String;
   Low_Order_First_Token          : constant Lex_String;
   Default_Bit_Order_Token        : constant Lex_String;

   -- More Pragmas
   All_Calls_Remote_Token         : constant Lex_String;
   Asynchronous_Token             : constant Lex_String;
   Controlled_Token               : constant Lex_String;
   Discard_Names_Token            : constant Lex_String;
   Elaborate_Token                : constant Lex_String;
   Elaborate_All_Token            : constant Lex_String;
   Export_Token                   : constant Lex_String;
   Inline_Token                   : constant Lex_String;
   Inspection_Point_Token         : constant Lex_String;
   Linker_Options_Token           : constant Lex_String;
   List_Token                     : constant Lex_String;
   Locking_Policy_Token           : constant Lex_String;
   Normalize_Scalars_Token        : constant Lex_String;
   Optimize_Token                 : constant Lex_String;
   Pack_Token                     : constant Lex_String;
   Page_Token                     : constant Lex_String;
   Preelaborate_Token             : constant Lex_String;
   Pure_Token                     : constant Lex_String;
   Queueing_Policy_Token          : constant Lex_String;
   Remote_Call_Interface_Token    : constant Lex_String;
   Remote_Types_Token             : constant Lex_String;
   Restrictions_Token             : constant Lex_String;
   Reviewable_Token               : constant Lex_String;
   Shared_Passive_Token           : constant Lex_String;
   Storage_Size_Token             : constant Lex_String;
   Suppress_Token                 : constant Lex_String;
   Task_Dispatching_Policy_Token  : constant Lex_String;
   Volatile_Token                 : constant Lex_String;

   -- More Ada '83 Pragmas
   Memory_Size_Token              : constant Lex_String;
   Shared_Token                   : constant Lex_String;
   System_Name_Token              : constant Lex_String;

   -- Ada 2005
   Mod_Token                      : constant Lex_String;
   Machine_Rounding_Token         : constant Lex_String;

   Priority_Last_Token            : constant Lex_String;
   Standard_Token                 : constant Lex_String;
   Integer_Token                  : constant Lex_String;
   Float_Token                    : constant Lex_String;
   Seconds_Count_Token            : constant Lex_String;
   Interrupt_ID_Token             : constant Lex_String;

   -- Dictionary types
   Universal_Integer_Token        : constant Lex_String;
   Universal_Real_Token           : constant Lex_String;
   Universal_Fixed_Token          : constant Lex_String;
   Character_Token                : constant Lex_String;
   Boolean_Token                  : constant Lex_String;
   Duration_Token                 : constant Lex_String;
   String_Token                   : constant Lex_String;
   Natural_Token                  : constant Lex_String;
   Positive_Token                 : constant Lex_String;

   type Line_Numbers is range 0 .. ExaminerConstants.Max_Line_Number;
   --# assert Line_Numbers'Base is Integer; -- for the "Large" Examiner

   type Token_Position is record
      Start_Line_No : Line_Numbers;
      Start_Pos     : EStrings.Lengths;
   end record;

   Null_Token_Position : constant Token_Position := Token_Position'(Start_Line_No => 0,
                                                                    Start_Pos     => 0);

   type Lex_Value is record
      Position  : Token_Position;
      Token_Str : Lex_String;
   end record;

   -- Type to identify result of string comparisons
   type Str_Comp_Result is (Str_Eq, Str_First, Str_Second);

   -- Performs case insensitive comparison of two Lex_Strings and
   -- returns a value of type StrCompResult (see above) to indicate
   -- which string comes first when ordered alphabetically.
   -- If both strings are null it returns StrEqual.
   -- If just one string is null then the null string is considered
   -- to come first.
   -- If one string is of length n chars and the other string is
   -- longer but identical for the first n chars then the shorter
   -- string is considered to come first.
   -- (See also CompStr and CompStrCaseSensitive in package body)
   function Lex_String_Case_Insensitive_Compare
     (Lex_Str1 : Lex_String;
      Lex_Str2 : Lex_String) return Str_Comp_Result;
   --# global in State;

   function Lex_String_Case_Sensitive_Compare
     (Lex_Str1 : Lex_String;
      Lex_Str2 : Lex_String) return Str_Comp_Result;
   --# global in State;

   function Comp_Str_Case_Insensitive
     (Str     : ELStrings.T;
      Lex_Str : Lex_String) return Boolean;
   --# global in State;

   function Comp_Str_Case_Sensitive
     (Str     : ELStrings.T;
      Lex_Str : Lex_String) return Boolean;
   --# global in State;

   procedure Insert_Examiner_String
     (Str     : in     EStrings.T;
      Lex_Str :    out Lex_String);
   --# global in out State;
   --# derives Lex_Str,
   --#         State   from State,
   --#                      Str;

   procedure Insert_Examiner_Long_String
     (Str     : in     ELStrings.T;
      Lex_Str :    out Lex_String);
   --# global in out State;
   --# derives Lex_Str,
   --#         State   from State,
   --#                      Str;

   function Lex_String_To_String (Lex_Str : Lex_String) return EStrings.T;
   --# global in State;

   function Lex_String_To_Long_String (Lex_Str : Lex_String) return ELStrings.T;
   --# global in State;

   function Is_Attribute_Token (Tok      : Lex_String;
                                Language : CommandLineData.LanguageProfiles) return Boolean;
   --# global in State;

   procedure Initialise_String_Table;
   --# global in out State;
   --# derives State from *;

   procedure Report_Usage;
   --# global in     State;
   --#        in out Statistics.TableUsage;
   --# derives Statistics.TableUsage from *,
   --#                                    State;

   procedure Insert_Nat (N       : in     Natural;
                         Lex_Str :    out Lex_String);
   --# global in out State;
   --# derives Lex_Str,
   --#         State   from N,
   --#                      State;

   function Is_Standard_Token (Lex_Str : Lex_String) return Boolean;
   --# global in State;

   procedure Set_Last_Token;
   --# global in out State;
   --# derives State from *;

private
   type Lex_String is range 0 .. ExaminerConstants.String_Table_Size;
   --# assert Lex_String'Base is Integer;

   Null_String                    : constant Lex_String := 0;
   The_First_Token                : constant Lex_String := 1;
   Aft_Token                      : constant Lex_String := 1;
   Base_Token                     : constant Lex_String := 8;
   Delta_Token                    : constant Lex_String := 16;
   Digits_Token                   : constant Lex_String := 25;
   Emax_Token                     : constant Lex_String := 35;
   Epsilon_Token                  : constant Lex_String := 43;
   First_Token                    : constant Lex_String := 54;
   Fore_Token                     : constant Lex_String := 63;
   Large_Token                    : constant Lex_String := 71;
   Last_Token                     : constant Lex_String := 80;
   Length_Token                   : constant Lex_String := 88;
   Machine_Emax_Token             : constant Lex_String := 98;
   Machine_Emin_Token             : constant Lex_String := 114;
   Machine_Mantissa_Token         : constant Lex_String := 130;
   Machine_Overflows_Token        : constant Lex_String := 150;
   Machine_Radix_Token            : constant Lex_String := 171;
   Machine_Rounds_Token           : constant Lex_String := 188;
   Mantissa_Token                 : constant Lex_String := 206;
   Pos_Token                      : constant Lex_String := 218;
   Pred_Token                     : constant Lex_String := 225;
   Range_Token                    : constant Lex_String := 233;
   Safe_Emax_Token                : constant Lex_String := 242;
   Safe_Large_Token               : constant Lex_String := 255;
   Safe_Small_Token               : constant Lex_String := 269;
   Size_Token                     : constant Lex_String := 283;
   Small_Token                    : constant Lex_String := 291;
   Succ_Token                     : constant Lex_String := 300;
   Val_Token                      : constant Lex_String := 308;
   Left_Token                     : constant Lex_String := 315;
   Right_Token                    : constant Lex_String := 323;
   True_Token                     : constant Lex_String := 332;
   False_Token                    : constant Lex_String := 340;
   Zero_Value                     : constant Lex_String := 349;
   One_Value                      : constant Lex_String := 354;
   Super_Index_Token              : constant Lex_String := 359;
   Interface_Token                : constant Lex_String := 373;
   Import_Token                   : constant Lex_String := 386;
   Link_Name_Token                : constant Lex_String := 396;
   External_Name_Token            : constant Lex_String := 409;
   Entity_Token                   : constant Lex_String := 426;
   Convention_Token               : constant Lex_String := 436;
   Elaborate_Body_Token           : constant Lex_String := 450;
   Ada_Token                      : constant Lex_String := 468;
   Denorm_Token                   : constant Lex_String := 475;
   Model_Emin_Token               : constant Lex_String := 485;
   Model_Epsilon_Token            : constant Lex_String := 499;
   Model_Mantissa_Token           : constant Lex_String := 516;
   Model_Small_Token              : constant Lex_String := 534;
   Safe_First_Token               : constant Lex_String := 549;
   Safe_Last_Token                : constant Lex_String := 563;
   Component_Size_Token           : constant Lex_String := 576;
   Min_Token                      : constant Lex_String := 594;
   Max_Token                      : constant Lex_String := 601;
   Signed_Zeros_Token             : constant Lex_String := 608;
   Valid_Token                    : constant Lex_String := 624;
   Characters_Token               : constant Lex_String := 633;
   Latin_1_Token                  : constant Lex_String := 647;
   Adjacent_Token                 : constant Lex_String := 658;
   Compose_Token                  : constant Lex_String := 670;
   Copy_Sign_Token                : constant Lex_String := 681;
   Leading_Part_Token             : constant Lex_String := 694;
   Remainder_Token                : constant Lex_String := 710;
   Scaling_Token                  : constant Lex_String := 723;
   Ceiling_Token                  : constant Lex_String := 734;
   Exponent_Token                 : constant Lex_String := 745;
   Floor_Token                    : constant Lex_String := 757;
   Fraction_Token                 : constant Lex_String := 766;
   Machine_Token                  : constant Lex_String := 778;
   Model_Token                    : constant Lex_String := 789;
   Rounding_Token                 : constant Lex_String := 798;
   Truncation_Token               : constant Lex_String := 810;
   Unbiased_Rounding_Token        : constant Lex_String := 824;
   Address_Token                  : constant Lex_String := 845;
   Modulus_Token                  : constant Lex_String := 856;
   Tail_Token                     : constant Lex_String := 867;
   Append_Token                   : constant Lex_String := 875;

   -- System and its constants and types. "Address" is already
   -- defined above.
   System_Token                   : constant Lex_String := 885;
   Min_Int_Token                  : constant Lex_String := 895;
   Max_Int_Token                  : constant Lex_String := 906;
   Max_Binary_Modulus_Token       : constant Lex_String := 917;
   Max_Base_Digits_Token          : constant Lex_String := 939;
   Max_Digits_Token               : constant Lex_String := 958;
   Max_Mantissa_Token             : constant Lex_String := 972;
   Fine_Delta_Token               : constant Lex_String := 988;
   Null_Address_Token             : constant Lex_String := 1002;
   Storage_Unit_Token             : constant Lex_String := 1018;
   Word_Size_Token                : constant Lex_String := 1034;
   Any_Priority_Token             : constant Lex_String := 1047;
   Priority_Token                 : constant Lex_String := 1063;
   Interrupt_Priority_Token       : constant Lex_String := 1075;
   Default_Priority_Token         : constant Lex_String := 1097;

   -- RavenSPARK Pragmas, attributes, and identifiers
   Atomic_Token                   : constant Lex_String := 1117;
   Real_Time_Token                : constant Lex_String := 1127;
   Inherit_Token                  : constant Lex_String := 1140;
   Synchronous_Task_Control_Token : constant Lex_String := 1151;
   Attach_Handler_Token           : constant Lex_String := 1179;
   Interrupt_Handler_Token        : constant Lex_String := 1197;
   Interrupts_Token               : constant Lex_String := 1218;
   Access_Token                   : constant Lex_String := 1232;
   Atomic_Components_Token        : constant Lex_String := 1242;
   Volatile_Components_Token      : constant Lex_String := 1263;
   Main_Program_Token             : constant Lex_String := 1286;

   -- Ada0Y identifiers.
   Assert_Token                   : constant Lex_String := 1302;
   Overriding_Token               : constant Lex_String := 1312;

   -- Predefined generics
   Unchecked_Conversion_Token     : constant Lex_String := 1326;

   -- Composite constant rule generation
   Rule_Token                     : constant Lex_String := 1350;
   No_Rule_Token                  : constant Lex_String := 1358;

   -- the 'Always_Valid token
   Always_Valid_Token             : constant Lex_String := 1368;

   Bit_Order_Token                : constant Lex_String := 1384;
   High_Order_First_Token         : constant Lex_String := 1397;
   Low_Order_First_Token          : constant Lex_String := 1417;
   Default_Bit_Order_Token        : constant Lex_String := 1436;

   -- More Pragmas
   All_Calls_Remote_Token         : constant Lex_String := 1457;
   Asynchronous_Token             : constant Lex_String := 1477;
   Controlled_Token               : constant Lex_String := 1493;
   Discard_Names_Token            : constant Lex_String := 1507;
   Elaborate_Token                : constant Lex_String := 1524;
   Elaborate_All_Token            : constant Lex_String := 1537;
   Export_Token                   : constant Lex_String := 1554;
   Inline_Token                   : constant Lex_String := 1564;
   Inspection_Point_Token         : constant Lex_String := 1574;
   Linker_Options_Token           : constant Lex_String := 1594;
   List_Token                     : constant Lex_String := 1612;
   Locking_Policy_Token           : constant Lex_String := 1620;
   Normalize_Scalars_Token        : constant Lex_String := 1638;
   Optimize_Token                 : constant Lex_String := 1659;
   Pack_Token                     : constant Lex_String := 1671;
   Page_Token                     : constant Lex_String := 1679;
   Preelaborate_Token             : constant Lex_String := 1687;
   Pure_Token                     : constant Lex_String := 1703;
   Queueing_Policy_Token          : constant Lex_String := 1711;
   Remote_Call_Interface_Token    : constant Lex_String := 1730;
   Remote_Types_Token             : constant Lex_String := 1755;
   Restrictions_Token             : constant Lex_String := 1771;
   Reviewable_Token               : constant Lex_String := 1787;
   Shared_Passive_Token           : constant Lex_String := 1801;
   Storage_Size_Token             : constant Lex_String := 1819;
   Suppress_Token                 : constant Lex_String := 1835;
   Task_Dispatching_Policy_Token  : constant Lex_String := 1847;
   Volatile_Token                 : constant Lex_String := 1874;

   -- More Ada '83 Pragmas
   Memory_Size_Token              : constant Lex_String := 1886;
   Shared_Token                   : constant Lex_String := 1901;
   System_Name_Token              : constant Lex_String := 1911;

   -- Ada 2005 Mod attribute
   Mod_Token                      : constant Lex_String := 1926;
   Machine_Rounding_Token         : constant Lex_String := 1933;

   Priority_Last_Token            : constant Lex_String := 1953;
   Standard_Token                 : constant Lex_String := 1970;
   Integer_Token                  : constant Lex_String := 1982;
   Float_Token                    : constant Lex_String := 1993;
   Seconds_Count_Token            : constant Lex_String := 2002;
   Interrupt_ID_Token             : constant Lex_String := 2019;

   -- Dictionary types
   Universal_Integer_Token        : constant Lex_String := 2035;
   Universal_Real_Token           : constant Lex_String := 2056;
   Universal_Fixed_Token          : constant Lex_String := 2074;
   Character_Token                : constant Lex_String := 2093;
   Boolean_Token                  : constant Lex_String := 2106;
   Duration_Token                 : constant Lex_String := 2117;
   String_Token                   : constant Lex_String := 2129;
   Natural_Token                  : constant Lex_String := 2139;
   Positive_Token                 : constant Lex_String := 2150;

end LexTokenManager;
